/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import maninhouse.epicfight.animation.Animator;
import maninhouse.epicfight.animation.AnimatorServer;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.CapabilityEntity;
import maninhouse.epicfight.capabilities.entity.DataKeys;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.client.particle.HierarchicalParticle;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Colliders;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.item.ModItems;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCPlayAnimation;
import maninhouse.epicfight.particle.HitParticleType;
import maninhouse.epicfight.particle.Particles;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.utils.game.DamageAttributes;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import maninhouse.epicfight.utils.math.Mat4f;
import maninhouse.epicfight.utils.math.MathUtils;
import maninhouse.epicfight.utils.math.Vec3f;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public abstract class LivingData<T extends LivingEntity>
extends CapabilityEntity<T> {
    private float stunTimeReduction;
    protected boolean inaction;
    protected boolean gatherDamageDealt;
    public Vec3f prevMotion;
    public LivingMotion currentMotion = LivingMotion.IDLE;
    public LivingMotion currentMixMotion = LivingMotion.NONE;
    protected Animator animator;
    protected Field entitySizeSeeker = ObfuscationReflectionHelper.findField(Entity.class, (String)"field_213325_aI");
    public static final IAttribute MAX_STUN_RESISTANCE = new RangedAttribute((IAttribute)null, "epicfight:stun resistance", 0.0, 0.0, Double.MAX_VALUE).func_111112_a(true);
    public static final IAttribute WEIGHT = new RangedAttribute((IAttribute)null, "epicfight:weight", 0.0, 0.0, Double.MAX_VALUE).func_111112_a(true);
    public List<Entity> currentlyAttackedEntity;
    protected AbstractAttributeMap volatileAttributes;
    @OnlyIn(value=Dist.CLIENT)
    public List<HierarchicalParticle> hierarchicalParticles;

    @Override
    public void init() {
        if (((LivingEntity)this.orgEntity).field_70170_p.field_72995_K) {
            this.animator = new AnimatorClient(this);
            this.initAnimator(this.getClientAnimator());
            this.hierarchicalParticles = Lists.newArrayList();
        } else {
            this.animator = new AnimatorServer(this);
        }
        this.inaction = false;
        this.gatherDamageDealt = false;
        this.prevMotion = new Vec3f();
        this.currentlyAttackedEntity = new ArrayList<Entity>();
        this.volatileAttributes = new AttributeMap();
        this.volatileAttributes.func_111150_b(DamageAttributes.IMPACT).func_111128_a(0.5);
        this.volatileAttributes.func_111150_b(DamageAttributes.DEFENCE_IGNORE).func_111128_a(0.0);
        this.volatileAttributes.func_111150_b(DamageAttributes.MULTIPLE_HIT).func_111128_a(1.0);
        this.volatileAttributes.func_111150_b(WEIGHT).func_111128_a((double)((LivingEntity)this.orgEntity).func_110138_aP() * 2.0);
    }

    @Override
    public void registerAttribute(LivingEntity entity) {
    }

    protected abstract void initAnimator(AnimatorClient var1);

    public abstract void updateMotion();

    public abstract Model getEntityModel();

    @Override
    protected void updateOnClient() {
        AnimatorClient animator = this.getClientAnimator();
        if (this.inaction) {
            this.currentMotion = LivingMotion.IDLE;
        } else {
            this.updateMotion();
        }
        if (!animator.compareMotion(this.currentMotion)) {
            animator.playLoopMotion();
        }
        if (!animator.compareMixMotion(this.currentMixMotion)) {
            animator.playMixLoopMotion();
        }
    }

    @Override
    protected void updateOnServer() {
        if (this.stunTimeReduction > 0.0f) {
            this.stunTimeReduction = Math.max(0.0f, this.stunTimeReduction - 0.05f);
        }
    }

    @Override
    public void update() {
        this.updateInactionState();
        if (this.isRemote()) {
            this.updateOnClient();
        } else {
            this.updateOnServer();
        }
        this.animator.update();
        if (((LivingEntity)this.orgEntity).field_70725_aQ == 19) {
            this.aboutToDeath();
        }
    }

    public void updateInactionState() {
        EntityState state = this.getEntityState();
        this.inaction = state != EntityState.FREE && state != EntityState.FREE_INPUT;
    }

    protected final void commonBipedCreatureAnimatorInit(AnimatorClient animator) {
        animator.addLivingAnimation(LivingMotion.IDLE, Animations.BIPED_IDLE);
        animator.addLivingAnimation(LivingMotion.WALKING, Animations.BIPED_WALK);
        animator.addLivingAnimation(LivingMotion.FALL, Animations.BIPED_FALL);
        animator.addLivingAnimation(LivingMotion.MOUNT, Animations.BIPED_MOUNT);
        animator.addLivingAnimation(LivingMotion.DEATH, Animations.BIPED_DEATH);
    }

    protected final void commonCreatureUpdateMotion() {
        this.currentMotion = ((LivingEntity)this.orgEntity).func_184187_bx() != null ? LivingMotion.MOUNT : (((LivingEntity)this.orgEntity).func_213322_ci().field_72448_b < (double)-0.55f ? LivingMotion.FALL : (((LivingEntity)this.orgEntity).field_70721_aZ > 0.01f ? LivingMotion.WALKING : LivingMotion.IDLE));
    }

    public void cancelUsingItem() {
        ((LivingEntity)this.orgEntity).func_184602_cy();
        ForgeEventFactory.onUseItemStop((LivingEntity)((LivingEntity)this.orgEntity), (ItemStack)((LivingEntity)this.orgEntity).func_184607_cu(), (int)((LivingEntity)this.orgEntity).func_184605_cv());
    }

    public CapabilityItem getHeldItemCapability(Hand hand) {
        CapabilityItem itemCap = (CapabilityItem)((LivingEntity)this.orgEntity).func_184586_b(hand).getCapability(ModCapabilities.CAPABILITY_ITEM, null).orElse(null);
        return itemCap;
    }

    public boolean isInaction() {
        return this.inaction;
    }

    public boolean attackEntityFrom(DamageSource damageSource, float amount) {
        float currentStunResistance = this.getStunResistance();
        if (currentStunResistance > 0.0f && damageSource instanceof IExtendedDamageSource) {
            float impact = ((IExtendedDamageSource)damageSource).getImpact();
            ((LivingEntity)this.orgEntity).func_184212_Q().func_187227_b(DataKeys.STUN_RESISTANCE, (Object)Float.valueOf(currentStunResistance - (float)((double)(impact * 40.0f) / this.getWeight())));
        }
        return true;
    }

    public IExtendedDamageSource getDamageSource(IExtendedDamageSource.StunType stunType, IExtendedDamageSource.DamageType damageType, int animationId) {
        return IExtendedDamageSource.causeMobDamage((LivingEntity)this.orgEntity, stunType, damageType, animationId);
    }

    public float getDamageToEntity(Entity targetEntity, Hand hand) {
        float damage = 0.0f;
        if (hand == Hand.MAIN_HAND) {
            damage = (float)((LivingEntity)this.orgEntity).func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        } else {
            damage += 1.0f;
            for (AttributeModifier mods : ((LivingEntity)this.orgEntity).func_184592_cb().func_111283_C(EquipmentSlotType.MAINHAND).get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a())) {
                damage = (float)((double)damage + mods.func_111164_d());
            }
        }
        float bonus = targetEntity instanceof LivingEntity ? EnchantmentHelper.func_152377_a((ItemStack)((LivingEntity)this.orgEntity).func_184586_b(hand), (CreatureAttribute)((LivingEntity)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)((LivingEntity)this.orgEntity).func_184586_b(hand), (CreatureAttribute)CreatureAttribute.field_223222_a_);
        return damage + bonus;
    }

    public boolean hurtEntity(Entity hitTarget, IExtendedDamageSource source, float amount) {
        boolean succed = hitTarget.func_70097_a((DamageSource)source, amount);
        return succed;
    }

    public void gatherDamageDealt(IExtendedDamageSource source, float amount) {
    }

    public void setStunTimeReduction() {
        this.stunTimeReduction += (1.0f - this.stunTimeReduction) * 0.8f;
    }

    public float getStunTimeTimeReduction() {
        return this.stunTimeReduction;
    }

    public void knockBackEntity(Entity entityIn, float power) {
        double d1 = entityIn.field_70165_t - ((LivingEntity)this.orgEntity).field_70165_t;
        double d0 = entityIn.field_70161_v - ((LivingEntity)this.orgEntity).field_70161_v;
        while (d1 * d1 + d0 * d0 < 1.0E-4) {
            d1 = (Math.random() - Math.random()) * 0.01;
            d0 = (Math.random() - Math.random()) * 0.01;
        }
        if (((LivingEntity)this.orgEntity).func_70681_au().nextDouble() >= ((LivingEntity)this.orgEntity).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e()) {
            Vec3d vec = ((LivingEntity)this.orgEntity).func_213322_ci();
            ((LivingEntity)this.orgEntity).field_70160_al = true;
            float f = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0));
            double x = vec.field_72450_a;
            double y = vec.field_72448_b;
            double z = vec.field_72449_c;
            x /= 2.0;
            z /= 2.0;
            x -= d1 / (double)f * (double)power;
            z -= d0 / (double)f * (double)power;
            if (!((LivingEntity)this.orgEntity).field_70122_E) {
                y /= 2.0;
                if ((y += (double)power) > (double)0.4f) {
                    y = 0.4f;
                }
            }
            ((LivingEntity)this.orgEntity).func_213293_j(x, y, z);
        }
    }

    public float getMaxStunResistance() {
        IAttributeInstance stun_resistance = this.volatileAttributes.func_111151_a(MAX_STUN_RESISTANCE);
        return (float)(stun_resistance == null ? 0.0 : stun_resistance.func_111126_e());
    }

    public float getStunResistance() {
        return this.getMaxStunResistance() == 0.0f ? 0.0f : MathHelper.func_76131_a((float)((Float)((LivingEntity)this.orgEntity).func_184212_Q().func_187225_a(DataKeys.STUN_RESISTANCE)).floatValue(), (float)0.0f, (float)((float)this.volatileAttributes.func_111151_a(MAX_STUN_RESISTANCE).func_111126_e()));
    }

    public double getWeight() {
        return this.volatileAttributes.func_111151_a(WEIGHT).func_111126_e();
    }

    public void rotateTo(float degree, float limit, boolean partialSync) {
        float amount;
        T entity = this.getOriginalEntity();
        for (amount = MathHelper.func_76142_g((float)(degree - ((LivingEntity)entity).field_70177_z)); amount < -180.0f; amount += 360.0f) {
        }
        while (amount > 180.0f) {
            amount -= 360.0f;
        }
        if (amount > limit) {
            amount = limit;
        }
        if (amount < -limit) {
            amount = -limit;
        }
        float f1 = ((LivingEntity)entity).field_70177_z + amount;
        if (partialSync) {
            ((LivingEntity)entity).field_70126_B = f1;
            ((LivingEntity)entity).field_70758_at = f1;
            ((LivingEntity)entity).field_70760_ar = f1;
        }
        ((LivingEntity)entity).field_70177_z = f1;
        ((LivingEntity)entity).field_70759_as = f1;
        ((LivingEntity)entity).field_70761_aq = f1;
    }

    public void rotateTo(Entity target, float limit, boolean partialSync) {
        double d0 = target.field_70165_t - ((LivingEntity)this.orgEntity).field_70165_t;
        double d1 = target.field_70161_v - ((LivingEntity)this.orgEntity).field_70161_v;
        float degree = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.29577951308232) - 90.0f;
        this.rotateTo(degree, limit, partialSync);
    }

    public void moveForward(float forward) {
        T entity = this.getOriginalEntity();
        float x = -forward * MathHelper.func_76126_a((float)(((LivingEntity)entity).field_70177_z * ((float)Math.PI / 180)));
        float z = forward * MathHelper.func_76134_b((float)(((LivingEntity)entity).field_70177_z * ((float)Math.PI / 180)));
        entity.func_213315_a(MoverType.SELF, new Vec3d((double)x, 0.0, (double)z));
    }

    public void move(float horizontal, float vertical) {
        T entity = this.getOriginalEntity();
        float x = -horizontal * MathHelper.func_76126_a((float)(((LivingEntity)entity).field_70177_z * ((float)Math.PI / 180)));
        float z = horizontal * MathHelper.func_76134_b((float)(((LivingEntity)entity).field_70177_z * ((float)Math.PI / 180)));
        entity.func_213315_a(MoverType.SELF, new Vec3d((double)x, (double)vertical, (double)z));
    }

    public void playSound(SoundEvent sound, float minPitch, float maxPitch) {
        float randPitch = ((LivingEntity)this.orgEntity).func_70681_au().nextFloat() * 2.0f - 1.0f;
        randPitch = Math.min(Math.max(randPitch, minPitch), maxPitch);
        if (!this.isRemote()) {
            ((LivingEntity)this.orgEntity).field_70170_p.func_184148_a(null, ((LivingEntity)this.orgEntity).field_70165_t, ((LivingEntity)this.orgEntity).field_70163_u, ((LivingEntity)this.orgEntity).field_70161_v, sound, ((LivingEntity)this.orgEntity).func_184176_by(), 1.0f, 1.0f + randPitch);
        } else {
            ((LivingEntity)this.orgEntity).field_70170_p.func_184134_a(((LivingEntity)this.orgEntity).field_70165_t, ((LivingEntity)this.orgEntity).field_70163_u, ((LivingEntity)this.orgEntity).field_70161_v, sound, ((LivingEntity)this.orgEntity).func_184176_by(), 1.0f, 1.0f + randPitch, false);
        }
    }

    public LivingEntity getAttackTarget() {
        return ((LivingEntity)this.orgEntity).func_110144_aD();
    }

    public Mat4f getHeadMatrix(float partialTicks) {
        float f2;
        if (this.inaction) {
            f2 = 0.0f;
        } else {
            float f = MathUtils.interpolateRotation(((LivingEntity)this.orgEntity).field_70760_ar, ((LivingEntity)this.orgEntity).field_70761_aq, partialTicks);
            float f1 = MathUtils.interpolateRotation(((LivingEntity)this.orgEntity).field_70758_at, ((LivingEntity)this.orgEntity).field_70759_as, partialTicks);
            f2 = f1 - f;
            if (((LivingEntity)this.orgEntity).func_184187_bx() != null) {
                if (f2 > 45.0f) {
                    f2 = 45.0f;
                } else if (f2 < -45.0f) {
                    f2 = -45.0f;
                }
            }
        }
        return MathUtils.getModelMatrixIntegrated(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, ((LivingEntity)this.orgEntity).field_70127_C, ((LivingEntity)this.orgEntity).field_70125_A, f2, f2, partialTicks);
    }

    @Override
    public Mat4f getModelMatrix(float partialTicks) {
        float rotyaw;
        float prevRotYaw;
        if (((LivingEntity)this.orgEntity).func_184187_bx() instanceof LivingEntity) {
            LivingEntity ridingEntity = (LivingEntity)((LivingEntity)this.orgEntity).func_184187_bx();
            prevRotYaw = ridingEntity.field_70760_ar;
            rotyaw = ridingEntity.field_70761_aq;
        } else {
            prevRotYaw = this.inaction ? ((LivingEntity)this.orgEntity).field_70177_z : ((LivingEntity)this.orgEntity).field_70760_ar;
            rotyaw = this.inaction ? ((LivingEntity)this.orgEntity).field_70177_z : ((LivingEntity)this.orgEntity).field_70761_aq;
        }
        return MathUtils.getModelMatrixIntegrated((float)((LivingEntity)this.orgEntity).field_70142_S, (float)((LivingEntity)this.orgEntity).field_70165_t, (float)((LivingEntity)this.orgEntity).field_70137_T, (float)((LivingEntity)this.orgEntity).field_70163_u, (float)((LivingEntity)this.orgEntity).field_70136_U, (float)((LivingEntity)this.orgEntity).field_70161_v, 0.0f, 0.0f, prevRotYaw, rotyaw, partialTicks);
    }

    public void resetLivingMixLoop() {
        this.currentMixMotion = LivingMotion.NONE;
        this.getClientAnimator().resetMixMotion();
    }

    public void playAnimationSynchronize(int id, float modifyTime) {
        this.animator.playAnimation(id, modifyTime);
        ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimation(id, ((LivingEntity)this.orgEntity).func_145782_y(), modifyTime), this.orgEntity);
    }

    public void playAnimationSynchronize(StaticAnimation animation, float modifyTime) {
        this.playAnimationSynchronize(animation.getId(), modifyTime);
    }

    public void resetSize(EntitySize size) {
        EntitySize entitysize1;
        EntitySize entitysize;
        try {
            entitysize = (EntitySize)this.entitySizeSeeker.get(this.orgEntity);
            entitysize1 = size;
            this.entitySizeSeeker.set(this.orgEntity, entitysize1);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return;
        }
        if (entitysize1.field_220315_a < entitysize.field_220315_a) {
            double d0 = (double)entitysize1.field_220315_a / 2.0;
            ((LivingEntity)this.orgEntity).func_174826_a(new AxisAlignedBB(((LivingEntity)this.orgEntity).field_70165_t - d0, ((LivingEntity)this.orgEntity).field_70163_u, ((LivingEntity)this.orgEntity).field_70161_v - d0, ((LivingEntity)this.orgEntity).field_70165_t + d0, ((LivingEntity)this.orgEntity).field_70163_u + (double)entitysize1.field_220316_b, ((LivingEntity)this.orgEntity).field_70161_v + d0));
        } else {
            AxisAlignedBB axisalignedbb = ((LivingEntity)this.orgEntity).func_174813_aQ();
            ((LivingEntity)this.orgEntity).func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)entitysize1.field_220315_a, axisalignedbb.field_72338_b + (double)entitysize1.field_220316_b, axisalignedbb.field_72339_c + (double)entitysize1.field_220315_a));
            if (entitysize1.field_220315_a > entitysize.field_220315_a && !((LivingEntity)this.orgEntity).field_70170_p.field_72995_K) {
                float f = entitysize.field_220315_a - entitysize1.field_220315_a;
                ((LivingEntity)this.orgEntity).func_213315_a(MoverType.SELF, new Vec3d((double)f, 0.0, (double)f));
            }
        }
    }

    public <A extends Animator> A getAnimator() {
        return (A)this.animator;
    }

    public AnimatorClient getClientAnimator() {
        return (AnimatorClient)this.getAnimator();
    }

    public AnimatorServer getServerAnimator() {
        return (AnimatorServer)this.getAnimator();
    }

    public StaticAnimation getHitAnimation(IExtendedDamageSource.StunType stunType) {
        if (((LivingEntity)this.orgEntity).func_184187_bx() != null) {
            return Animations.BIPED_HIT_ON_MOUNT;
        }
        switch (stunType) {
            case LONG: {
                return Animations.BIPED_HIT_LONG;
            }
            case SHORT: {
                return Animations.BIPED_HIT_SHORT;
            }
            case HOLD: {
                return Animations.BIPED_HIT_SHORT;
            }
        }
        return null;
    }

    @Override
    public void aboutToDeath() {
        this.animator.onEntityDeath();
        this.animator = null;
        super.aboutToDeath();
    }

    @Override
    public T getOriginalEntity() {
        return (T)((LivingEntity)this.orgEntity);
    }

    public SoundEvent getWeaponHitSound(Hand hand) {
        CapabilityItem cap = this.getHeldItemCapability(hand);
        if (cap != null) {
            return cap.getHitSound();
        }
        return Sounds.BLUNT_HIT;
    }

    public SoundEvent getSwingSound(Hand hand) {
        CapabilityItem cap = this.getHeldItemCapability(hand);
        if (cap != null) {
            return cap.getSmashingSound();
        }
        return Sounds.WHOOSH;
    }

    public HitParticleType getWeaponHitParticle(Hand hand) {
        CapabilityItem cap = this.getHeldItemCapability(hand);
        if (cap != null) {
            return cap.getHitParticle();
        }
        return (HitParticleType)Particles.HIT_BLUNT.get();
    }

    public AbstractAttributeMap getAttributes() {
        return this.volatileAttributes;
    }

    public Collider getColliderMatching(Hand hand) {
        CapabilityItem itemCap = this.getHeldItemCapability(hand);
        return itemCap != null ? itemCap.getWeaponCollider() : Colliders.fist;
    }

    public int getHitEnemies() {
        DamageAttributes itemDamageAttributes = ModItems.getItemDamageAttribute(((LivingEntity)this.orgEntity).func_184614_ca(), ((LivingEntity)this.orgEntity).func_184592_cb().func_190926_b());
        if (itemDamageAttributes != null) {
            return itemDamageAttributes.getHitEnemies();
        }
        return (int)this.volatileAttributes.func_111151_a(DamageAttributes.MULTIPLE_HIT).func_111126_e();
    }

    public float getDefenceIgnore() {
        DamageAttributes itemDamageAttributes = ModItems.getItemDamageAttribute(((LivingEntity)this.orgEntity).func_184614_ca(), ((LivingEntity)this.orgEntity).func_184592_cb().func_190926_b());
        if (itemDamageAttributes != null) {
            return itemDamageAttributes.getDefenceIgnore();
        }
        return (float)this.volatileAttributes.func_111151_a(DamageAttributes.DEFENCE_IGNORE).func_111126_e();
    }

    public boolean isTeam(Entity entityIn) {
        if (((LivingEntity)this.orgEntity).func_184187_bx() != null && ((LivingEntity)this.orgEntity).func_184187_bx().equals((Object)entityIn)) {
            return true;
        }
        if (((LivingEntity)this.orgEntity).func_184215_y(entityIn)) {
            return true;
        }
        return ((LivingEntity)this.orgEntity).func_184191_r(entityIn);
    }

    public float getImpact() {
        DamageAttributes itemDamageAttributes = ModItems.getItemDamageAttribute(((LivingEntity)this.orgEntity).func_184614_ca(), ((LivingEntity)this.orgEntity).func_184592_cb().func_190926_b());
        if (itemDamageAttributes != null) {
            return itemDamageAttributes.getImpact();
        }
        return (float)this.volatileAttributes.func_111151_a(DamageAttributes.IMPACT).func_111126_e();
    }

    public EntityState getEntityState() {
        return this.animator.getPlayer().getPlay().getState(this.animator.getPlayer().getElapsedTime());
    }

    public static enum EntityState {
        FREE,
        FREE_CAMERA,
        FREE_INPUT,
        PRE_DELAY,
        CONTACT,
        POST_DELAY,
        HIT;

    }
}

