/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.CapabilityEntity;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.entity.mob.Faction;
import maninhouse.epicfight.entity.ai.ArcherGoal;
import maninhouse.epicfight.entity.ai.AttackPatternGoal;
import maninhouse.epicfight.entity.ai.ChasingGoal;
import maninhouse.epicfight.entity.ai.RangeAttackMobGoal;
import maninhouse.epicfight.network.server.STCMobInitialSetting;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public abstract class MobData<T extends MobEntity>
extends LivingData<T> {
    protected static Field goalSelectorSeeker = ObfuscationReflectionHelper.findField(GoalSelector.class, (String)"field_220892_d");
    protected final Faction mobFaction;

    public MobData() {
        this.mobFaction = Faction.NATURAL;
    }

    public MobData(Faction faction) {
        this.mobFaction = faction;
    }

    @Override
    public void init() {
        super.init();
        if (!this.isRemote() && !((MobEntity)this.orgEntity).func_175446_cd()) {
            this.initAI();
        }
    }

    protected void initAI() {
        this.resetCombatAI();
    }

    protected void resetCombatAI() {
        Set goals = null;
        try {
            goals = (Set)goalSelectorSeeker.get(((MobEntity)this.orgEntity).field_70714_bg);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        Iterator iterator = goals.iterator();
        ArrayList toRemove = Lists.newArrayList();
        while (iterator.hasNext()) {
            PrioritizedGoal goal = (PrioritizedGoal)iterator.next();
            Goal inner = goal.func_220772_j();
            if (!(inner instanceof MeleeAttackGoal) && !(inner instanceof RangedBowAttackGoal) && !(inner instanceof ArcherGoal) && !(inner instanceof ChasingGoal) && !(inner instanceof RangedAttackGoal) && !(inner instanceof RangeAttackMobGoal) && !(inner instanceof AttackPatternGoal) && !(inner instanceof RangedCrossbowAttackGoal)) continue;
            toRemove.add(inner);
        }
        for (Goal AI : toRemove) {
            ((MobEntity)this.orgEntity).field_70714_bg.func_85156_a(AI);
        }
    }

    public STCMobInitialSetting sendInitialInformationToClient() {
        return null;
    }

    public void clientInitialSettings(ByteBuf buf) {
    }

    @Override
    public boolean isTeam(Entity entityIn) {
        CapabilityEntity cap = (CapabilityEntity)entityIn.getCapability(ModCapabilities.CAPABILITY_ENTITY).orElse(null);
        if (cap != null && cap instanceof MobData && ((MobData)cap).mobFaction.equals((Object)this.mobFaction)) {
            Optional<LivingEntity> opt = Optional.ofNullable(this.getAttackTarget());
            return opt.map(entity -> !entity.func_70028_i(entityIn)).orElse(true);
        }
        return super.isTeam(entityIn);
    }

    @Override
    public LivingEntity getAttackTarget() {
        return ((MobEntity)this.orgEntity).func_70638_az();
    }
}

