/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity.mob;

import maninhouse.epicfight.capabilities.entity.MobData;
import maninhouse.epicfight.capabilities.entity.mob.Faction;
import maninhouse.epicfight.capabilities.entity.mob.MobAttackPatterns;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.entity.ai.ArcherGoal;
import maninhouse.epicfight.entity.ai.AttackPatternGoal;
import maninhouse.epicfight.entity.ai.ChasingGoal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.item.TridentItem;
import net.minecraft.world.Difficulty;

public abstract class BipedMobData<T extends MobEntity>
extends MobData<T> {
    public BipedMobData(Faction faction) {
        super(faction);
    }

    @Override
    public void postInit() {
        if (!this.isRemote() && !((MobEntity)this.orgEntity).func_175446_cd()) {
            super.resetCombatAI();
            Item heldItem = ((MobEntity)this.orgEntity).func_184614_ca().func_77973_b();
            if (heldItem instanceof ShootableItem && this.orgEntity instanceof IRangedAttackMob) {
                this.setAIAsRange();
            } else if (((MobEntity)this.orgEntity).func_184187_bx() != null && ((MobEntity)this.orgEntity).func_184187_bx() instanceof MobEntity) {
                this.setAIAsMounted(((MobEntity)this.orgEntity).func_184187_bx());
            } else if (this.isArmed()) {
                this.setAIAsArmed();
            } else {
                this.setAIAsUnarmed();
            }
        }
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        animatorClient.mixLayer.setJointMask("Root", "Torso");
    }

    public void setAIAsUnarmed() {
    }

    public void setAIAsArmed() {
        ((MobEntity)this.orgEntity).field_70714_bg.func_75776_a(0, (Goal)new AttackPatternGoal(this, (MobEntity)this.orgEntity, 0.0, 2.0, true, MobAttackPatterns.BIPED_ARMED_ONEHAND));
        ((MobEntity)this.orgEntity).field_70714_bg.func_75776_a(1, (Goal)new ChasingGoal(this, (MobEntity)this.orgEntity, 1.0, false));
    }

    public void setAIAsMounted(Entity ridingEntity) {
        if (this.isArmed()) {
            ((MobEntity)this.orgEntity).field_70714_bg.func_75776_a(0, (Goal)new AttackPatternGoal(this, (MobEntity)this.orgEntity, 0.0, 2.0, true, MobAttackPatterns.BIPED_MOUNT_SWORD));
            if (ridingEntity instanceof AbstractHorseEntity) {
                ((MobEntity)this.orgEntity).field_70714_bg.func_75776_a(1, (Goal)new ChasingGoal(this, (MobEntity)this.orgEntity, 1.0, false));
            }
        }
    }

    public void setAIAsRange() {
        int cooldown = ((MobEntity)this.orgEntity).field_70170_p.func_175659_aa() != Difficulty.HARD ? 40 : 20;
        ((MobEntity)this.orgEntity).field_70714_bg.func_75776_a(1, new ArcherGoal<MobEntity>(this, (MobEntity)this.orgEntity, 1.0, cooldown, 15.0f));
    }

    public boolean isArmed() {
        Item heldItem = ((MobEntity)this.orgEntity).func_184614_ca().func_77973_b();
        return heldItem instanceof SwordItem || heldItem instanceof ToolItem || heldItem instanceof TridentItem;
    }

    public void onMount(boolean isMount, Entity ridingEntity) {
        if (this.orgEntity == null) {
            return;
        }
        this.resetCombatAI();
        if (isMount) {
            this.setAIAsMounted(ridingEntity);
        } else if (this.isArmed()) {
            this.setAIAsArmed();
        } else {
            this.setAIAsUnarmed();
        }
    }
}

