/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity.mob;

import java.util.Iterator;
import java.util.Set;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninhouse.epicfight.capabilities.entity.mob.Faction;
import maninhouse.epicfight.capabilities.entity.mob.MobAttackPatterns;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.entity.ai.AttackPatternGoal;
import maninhouse.epicfight.entity.ai.AttackPatternPercentGoal;
import maninhouse.epicfight.entity.ai.ChasingGoal;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.utils.game.DamageAttributes;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;

public class IronGolemData
extends BipedMobData<IronGolemEntity> {
    private int deathTimerExt;

    public IronGolemData() {
        super(Faction.VILLAGER);
    }

    @Override
    public void init() {
        super.init();
        Set goals = null;
        try {
            goals = (Set)goalSelectorSeeker.get(((IronGolemEntity)this.orgEntity).field_70714_bg);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        Iterator iterator = goals.iterator();
        Goal toRemove = null;
        while (iterator.hasNext()) {
            PrioritizedGoal goal = (PrioritizedGoal)iterator.next();
            Goal inner = goal.func_220772_j();
            if (!(inner instanceof MoveTowardsTargetGoal)) continue;
            toRemove = inner;
            break;
        }
        if (toRemove != null) {
            ((IronGolemEntity)this.orgEntity).field_70714_bg.func_85156_a(toRemove);
        }
        this.volatileAttributes.func_111151_a(DamageAttributes.MULTIPLE_HIT).func_111128_a(4.0);
        this.volatileAttributes.func_111151_a(DamageAttributes.IMPACT).func_111128_a(10.0);
        ((IronGolemEntity)this.orgEntity).field_70144_Y = 0.2f;
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        super.initAnimator(animatorClient);
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.GOLEM_IDLE);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.GOLEM_WALK);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.GOLEM_DEATH);
        animatorClient.setCurrentLivingMotionsToDefault();
    }

    @Override
    public void updateMotion() {
        super.commonCreatureUpdateMotion();
    }

    @Override
    public void update() {
        if (((IronGolemEntity)this.orgEntity).func_110143_aJ() <= 0.0f) {
            ((IronGolemEntity)this.orgEntity).field_70125_A = 0.0f;
            if (((IronGolemEntity)this.orgEntity).field_70725_aQ > 1 && this.deathTimerExt < 20) {
                ++this.deathTimerExt;
                --((IronGolemEntity)this.orgEntity).field_70725_aQ;
            }
        }
        super.update();
    }

    @Override
    public void setAIAsUnarmed() {
        ((IronGolemEntity)this.orgEntity).field_70714_bg.func_75776_a(0, (Goal)new AttackPatternPercentGoal(this, (MobEntity)this.orgEntity, 0.0, 1.5, 0.3f, true, MobAttackPatterns.GOLEM_PATTERN1));
        ((IronGolemEntity)this.orgEntity).field_70714_bg.func_75776_a(0, (Goal)new AttackPatternPercentGoal(this, (MobEntity)this.orgEntity, 1.0, 2.5, 0.15f, true, MobAttackPatterns.GOLEM_PATTERN2));
        ((IronGolemEntity)this.orgEntity).field_70714_bg.func_75776_a(0, (Goal)new AttackPatternGoal(this, (MobEntity)this.orgEntity, 0.0, 2.0, true, MobAttackPatterns.GOLEM_PATTERN3));
        ((IronGolemEntity)this.orgEntity).field_70714_bg.func_75776_a(1, (Goal)new ChasingGoal(this, (MobEntity)this.orgEntity, 1.0, false));
    }

    @Override
    public void setAIAsArmed() {
        this.setAIAsUnarmed();
    }

    @Override
    public SoundEvent getWeaponHitSound(Hand hand) {
        return Sounds.BLUNT_HIT_HARD;
    }

    @Override
    public SoundEvent getSwingSound(Hand hand) {
        return Sounds.WHOOSH_HARD;
    }

    @Override
    public float getDamageToEntity(Entity targetEntity, Hand hand) {
        return 7 + ((IronGolemEntity)this.orgEntity).func_70681_au().nextInt(15);
    }

    @Override
    public StaticAnimation getHitAnimation(IExtendedDamageSource.StunType stunType) {
        return null;
    }

    @Override
    public Model getEntityModel() {
        return this.isRemote() ? Models.LOGICAL_CLIENT.ENTITY_GOLEM : Models.LOGICAL_SERVER.ENTITY_GOLEM;
    }
}

