/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity.mob;

import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninhouse.epicfight.capabilities.entity.mob.Faction;
import maninhouse.epicfight.capabilities.entity.mob.MobAttackPatterns;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.entity.ai.AttackPatternGoal;
import maninhouse.epicfight.entity.ai.ChasingGoal;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.VindicatorEntity;

public class VindicatorData
extends BipedMobData<VindicatorEntity> {
    public VindicatorData() {
        super(Faction.ILLAGER);
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        super.initAnimator(animatorClient);
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.ILLAGER_IDLE);
        animatorClient.addLivingAnimation(LivingMotion.ANGRY, Animations.ILLAGER_IDLE_AGGRESSIVE);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.ILLAGER_WALK);
        animatorClient.addLivingAnimation(LivingMotion.CHASING, Animations.ILLAGER_CHASE);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.ILLAGER_DEATH);
        animatorClient.setCurrentLivingMotionsToDefault();
    }

    @Override
    public void updateMotion() {
        boolean onBattle = ((VindicatorEntity)this.orgEntity).func_213398_dR();
        this.currentMotion = ((VindicatorEntity)this.orgEntity).field_70721_aZ > 0.01f ? (onBattle ? LivingMotion.CHASING : LivingMotion.WALKING) : (onBattle ? LivingMotion.ANGRY : LivingMotion.IDLE);
    }

    @Override
    public void setAIAsArmed() {
        ((VindicatorEntity)this.orgEntity).field_70714_bg.func_75776_a(0, (Goal)new AttackPatternGoal(this, (MobEntity)this.orgEntity, 0.0, 3.0, true, MobAttackPatterns.VINDICATOR_PATTERN));
        ((VindicatorEntity)this.orgEntity).field_70714_bg.func_75776_a(1, (Goal)new ChasingGoal(this, (MobEntity)this.orgEntity, 1.0, false));
    }

    @Override
    public void setAIAsUnarmed() {
    }

    @Override
    public void setAIAsMounted(Entity ridingEntity) {
    }

    @Override
    public void setAIAsRange() {
    }

    @Override
    public Model getEntityModel() {
        return this.isRemote() ? Models.LOGICAL_CLIENT.ENTITY_VINDICATOR : Models.LOGICAL_SERVER.ENTITY_VINDICATOR;
    }

    @Override
    public StaticAnimation getHitAnimation(IExtendedDamageSource.StunType stunType) {
        if (stunType == IExtendedDamageSource.StunType.LONG) {
            return Animations.ILLAGER_HIT_LONG;
        }
        return Animations.ILLAGER_HIT_SHORT;
    }
}

