/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity.mob;

import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninhouse.epicfight.capabilities.entity.mob.Faction;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.entity.ai.RangeAttackMobGoal;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCPlayAnimationTarget;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import maninhouse.epicfight.utils.math.Mat4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class WitchData
extends BipedMobData<WitchEntity> {
    private boolean isDrinking;

    public WitchData() {
        super(Faction.NATURAL);
    }

    @Override
    public void init() {
        super.init();
        this.isDrinking = false;
    }

    @Override
    public void postInit() {
        super.resetCombatAI();
        ((WitchEntity)this.orgEntity).field_70714_bg.func_75776_a(0, (Goal)new WitchThrowPotionGoal((IRangedAttackMob)this.orgEntity, this, 1.0, 60, 10.0f, 13));
    }

    @Override
    protected void initAI() {
        super.initAI();
    }

    @Override
    public void setAIAsUnarmed() {
    }

    @Override
    public void setAIAsArmed() {
    }

    public void setAIAsMounted() {
    }

    @Override
    public void setAIAsRange() {
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        super.initAnimator(animatorClient);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.ILLAGER_DEATH);
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.ILLAGER_IDLE);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.ILLAGER_WALK);
        animatorClient.setCurrentLivingMotionsToDefault();
    }

    @Override
    public void updateMotion() {
        super.commonCreatureUpdateMotion();
    }

    @Override
    protected void updateOnClient() {
        super.updateOnClient();
        if (this.isDrinking != ((WitchEntity)this.orgEntity).func_184730_o()) {
            if (!this.isDrinking && ((WitchEntity)this.orgEntity).func_110143_aJ() > 0.0f) {
                this.getClientAnimator().playMixLayerAnimationUpper(Animations.WITCH_DRINKING);
            }
            this.isDrinking = ((WitchEntity)this.orgEntity).func_184730_o();
        }
    }

    @Override
    protected void updateOnServer() {
        super.updateOnServer();
        if (this.isDrinking != ((WitchEntity)this.orgEntity).func_184730_o()) {
            if (!this.isDrinking && ((WitchEntity)this.orgEntity).func_110143_aJ() > 0.0f) {
                this.getServerAnimator().playAnimation(Animations.DUMMY_ANIMATION, 0.0f);
            }
            this.isDrinking = ((WitchEntity)this.orgEntity).func_184730_o();
        }
    }

    public Potion getPotionTypeWithTarget(LivingEntity target) {
        Vec3d vec3d = target.func_213322_ci();
        double d0 = target.field_70165_t + vec3d.field_72450_a - ((WitchEntity)this.orgEntity).field_70165_t;
        double d2 = target.field_70161_v + vec3d.field_72449_c - ((WitchEntity)this.orgEntity).field_70161_v;
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        Potion potion = Potions.field_185252_x;
        if (target instanceof AbstractRaiderEntity) {
            potion = target.func_110143_aJ() <= 4.0f ? Potions.field_185250_v : Potions.field_185220_C;
            ((WitchEntity)this.orgEntity).func_70624_b((LivingEntity)null);
        } else if (f >= 8.0f && !target.func_70644_a(Effects.field_76421_d)) {
            potion = Potions.field_185246_r;
        } else if (target.func_110143_aJ() >= 8.0f && !target.func_70644_a(Effects.field_76436_u)) {
            potion = Potions.field_185254_z;
        } else if (f <= 3.0f && !target.func_70644_a(Effects.field_76437_t) && ((WitchEntity)this.orgEntity).func_70681_au().nextFloat() < 0.25f) {
            potion = Potions.field_185226_I;
        }
        return potion;
    }

    public void throwPotion(LivingEntity target, float distanceFactor) {
        Vec3d vec3d = target.func_213322_ci();
        double d0 = target.field_70165_t + vec3d.field_72450_a - ((WitchEntity)this.orgEntity).field_70165_t;
        double d1 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f - ((WitchEntity)this.orgEntity).field_70163_u;
        double d2 = target.field_70161_v + vec3d.field_72449_c - ((WitchEntity)this.orgEntity).field_70161_v;
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        PotionEntity potionEntity = new PotionEntity(((WitchEntity)this.orgEntity).field_70170_p, (LivingEntity)this.orgEntity);
        potionEntity.func_184541_a(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)this.getPotionTypeWithTarget(target)));
        potionEntity.field_70125_A -= -20.0f;
        potionEntity.func_70186_c(d0, d1 + (double)(f * 0.2f), d2, 0.75f, 8.0f);
        ((WitchEntity)this.orgEntity).field_70170_p.func_184148_a((PlayerEntity)null, ((WitchEntity)this.orgEntity).field_70165_t, ((WitchEntity)this.orgEntity).field_70163_u, ((WitchEntity)this.orgEntity).field_70161_v, SoundEvents.field_187924_gx, ((WitchEntity)this.orgEntity).func_184176_by(), 1.0f, 0.8f + ((WitchEntity)this.orgEntity).func_70681_au().nextFloat() * 0.4f);
        ((WitchEntity)this.orgEntity).field_70170_p.func_217376_c((Entity)potionEntity);
        ((WitchEntity)this.orgEntity).func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
    }

    @Override
    public StaticAnimation getHitAnimation(IExtendedDamageSource.StunType stunType) {
        if (stunType == IExtendedDamageSource.StunType.LONG) {
            return Animations.ILLAGER_HIT_LONG;
        }
        return Animations.ILLAGER_HIT_SHORT;
    }

    @Override
    public Model getEntityModel() {
        return this.isRemote() ? Models.LOGICAL_CLIENT.ENTITY_WITCH : Models.LOGICAL_SERVER.ENTITY_WITCH;
    }

    @Override
    public Mat4f getHeadMatrix(float partialTicks) {
        if (((WitchEntity)this.orgEntity).func_184730_o()) {
            return new Mat4f();
        }
        return super.getHeadMatrix(partialTicks);
    }

    class WitchThrowPotionGoal
    extends RangeAttackMobGoal {
        public WitchThrowPotionGoal(IRangedAttackMob attacker, BipedMobData<?> entitydata, double movespeed, int maxAttackTime, float maxAttackDistanceIn, int animationFrame) {
            super(attacker, entitydata, Animations.WITCH_THROWING, movespeed, maxAttackTime, maxAttackDistanceIn, animationFrame);
        }

        @Override
        public void func_75251_c() {
            this.entityHost.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
        }

        @Override
        public void func_75246_d() {
            double d0 = this.entityHost.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
            boolean flag = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
            this.seeTime = flag ? ++this.seeTime : 0;
            if (d0 <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                this.entityHost.func_70661_as().func_75499_g();
            } else {
                this.entityHost.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
            }
            this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            if (((WitchEntity)WitchData.this.orgEntity).func_184730_o()) {
                float f2 = MathHelper.func_76133_a((double)d0) / this.attackRadius;
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (--this.rangedAttackTime == this.animationFrame && !this.entitydata.isInaction()) {
                this.entityHost.func_184201_a(EquipmentSlotType.MAINHAND, PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)WitchData.this.getPotionTypeWithTarget(this.attackTarget)));
                this.entitydata.getServerAnimator().playAnimation(this.shotAnimation, 0.0f);
                ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimationTarget(this.shotAnimation.getId(), this.entityHost.func_145782_y(), 0.0f, this.attackTarget.func_145782_y()), (Entity)this.entityHost);
            } else if (this.rangedAttackTime == 0) {
                if (!flag) {
                    return;
                }
                float f = MathHelper.func_76133_a((double)d0) / this.attackRadius;
                float lvt_5_1_ = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
                WitchData.this.throwPotion(this.attackTarget, lvt_5_1_);
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.rangedAttackTime < 0) {
                float f2 = MathHelper.func_76133_a((double)d0) / this.attackRadius;
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            }
        }
    }
}

