/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity.mob;

import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.capabilities.entity.DataKeys;
import maninhouse.epicfight.capabilities.entity.mob.MobAttackPatterns;
import maninhouse.epicfight.capabilities.entity.mob.SkeletonData;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.entity.ai.AttackPatternGoal;
import maninhouse.epicfight.entity.ai.ChasingGoal;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import maninhouse.epicfight.utils.math.Mat4f;
import maninhouse.epicfight.utils.math.Vec3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;

public class WitherSkeletonData
extends SkeletonData<WitherSkeletonEntity> {
    @Override
    public void init() {
        super.init();
        this.volatileAttributes.func_111150_b(MAX_STUN_RESISTANCE).func_111128_a(4.0);
        ((WitherSkeletonEntity)this.orgEntity).func_184212_Q().func_187214_a(DataKeys.STUN_RESISTANCE, (Object)Float.valueOf(4.0f));
    }

    @Override
    public void postInit() {
        super.resetCombatAI();
        super.postInit();
    }

    @Override
    protected void initAnimator(AnimatorClient animator) {
        animator.addLivingAnimation(LivingMotion.FALL, Animations.BIPED_FALL);
        animator.addLivingAnimation(LivingMotion.MOUNT, Animations.BIPED_MOUNT);
        animator.addLivingAnimation(LivingMotion.DEATH, Animations.BIPED_DEATH);
        animator.addLivingAnimation(LivingMotion.IDLE, Animations.WITHER_SKELETON_IDLE);
        animator.addLivingAnimation(LivingMotion.WALKING, Animations.WITHER_SKELETON_WALK);
        animator.setCurrentLivingMotionsToDefault();
    }

    @Override
    public void updateMotion() {
        super.commonCreatureUpdateMotion();
    }

    @Override
    public boolean hurtEntity(Entity hitTarget, IExtendedDamageSource source, float amount) {
        boolean succed = super.hurtEntity(hitTarget, source, amount);
        if (succed && hitTarget instanceof LivingEntity && ((WitherSkeletonEntity)this.orgEntity).func_70681_au().nextInt(10) == 0) {
            ((LivingEntity)hitTarget).func_195064_c(new EffectInstance(Effects.field_82731_v, 200));
        }
        return succed;
    }

    @Override
    public void setAIAsArmed() {
        ((WitherSkeletonEntity)this.orgEntity).field_70714_bg.func_75776_a(0, (Goal)new AttackPatternGoal(this, (MobEntity)this.orgEntity, 0.0, 2.5, true, MobAttackPatterns.WITHER_SKELETON_PATTERN));
        ((WitherSkeletonEntity)this.orgEntity).field_70714_bg.func_75776_a(1, (Goal)new ChasingGoal(this, (MobEntity)this.orgEntity, 1.2, true, Animations.WITHER_SKELETON_CHASE, Animations.WITHER_SKELETON_WALK));
    }

    @Override
    public Mat4f getModelMatrix(float partialTicks) {
        Mat4f mat = super.getModelMatrix(partialTicks);
        return Mat4f.scale(new Vec3f(1.2f, 1.2f, 1.2f), mat, mat);
    }

    @Override
    public Model getEntityModel() {
        return this.isRemote() ? Models.LOGICAL_CLIENT.ENTITY_SKELETON : Models.LOGICAL_SERVER.ENTITY_SKELETON;
    }
}

