/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity.mob;

import io.netty.buffer.ByteBuf;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninhouse.epicfight.capabilities.entity.mob.Faction;
import maninhouse.epicfight.capabilities.entity.mob.MobAttackPatterns;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.entity.ai.AttackPatternGoal;
import maninhouse.epicfight.entity.ai.ChasingGoal;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.client.CTSReqSpawnInfo;
import maninhouse.epicfight.network.server.STCLivingMotionChange;
import maninhouse.epicfight.network.server.STCMobInitialSetting;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;

public class ZombiePigmanData
extends BipedMobData<ZombiePigmanEntity> {
    public ZombiePigmanData() {
        super(Faction.HELL_ARMY);
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void postInit() {
        super.postInit();
        if (this.isRemote()) {
            AnimatorClient animator = this.getClientAnimator();
            if (((ZombiePigmanEntity)this.orgEntity).func_70631_g_()) {
                animator.addLivingAnimation(LivingMotion.DEATH, Animations.BABY_DEATH);
            } else {
                animator.addLivingAnimation(LivingMotion.DEATH, Animations.BIPED_DEATH);
            }
            ModNetworkManager.sendToServer(new CTSReqSpawnInfo(((ZombiePigmanEntity)this.orgEntity).func_145782_y()));
        }
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        super.initAnimator(animatorClient);
        super.commonBipedCreatureAnimatorInit(animatorClient);
    }

    @Override
    public STCMobInitialSetting sendInitialInformationToClient() {
        STCMobInitialSetting packet = new STCMobInitialSetting(((ZombiePigmanEntity)this.orgEntity).func_145782_y());
        PacketBuffer buf = packet.getBuffer();
        buf.writeBoolean(((ZombiePigmanEntity)this.orgEntity).func_98052_bS());
        return packet;
    }

    @Override
    public void clientInitialSettings(ByteBuf buf) {
        AnimatorClient animator = this.getClientAnimator();
        if (buf.readBoolean()) {
            animator.addLivingAnimation(LivingMotion.IDLE, Animations.BIPED_IDLE);
            animator.addLivingAnimation(LivingMotion.WALKING, Animations.BIPED_WALK);
        }
        if (((ZombiePigmanEntity)this.orgEntity).func_70631_g_()) {
            animator.addLivingAnimation(LivingMotion.IDLE, Animations.ZOMBIE_IDLE);
            animator.addLivingAnimation(LivingMotion.WALKING, Animations.BABY_RUN);
        }
    }

    @Override
    public void updateMotion() {
        super.commonCreatureUpdateMotion();
    }

    @Override
    public void setAIAsArmed() {
        ((ZombiePigmanEntity)this.orgEntity).field_70714_bg.func_75776_a(1, (Goal)new EntityAIPigmanChase(this, (MobEntity)this.orgEntity));
        ((ZombiePigmanEntity)this.orgEntity).field_70714_bg.func_75776_a(0, (Goal)new AttackPatternGoal(this, (MobEntity)this.orgEntity, 0.0, 1.5, true, MobAttackPatterns.BIPED_ARMED_ONEHAND));
    }

    @Override
    public boolean attackEntityFrom(DamageSource damageSource, float amount) {
        return !(damageSource.func_76346_g() instanceof ZombiePigmanEntity);
    }

    @Override
    public Model getEntityModel() {
        Models modeldata = this.isRemote() ? Models.LOGICAL_CLIENT : Models.LOGICAL_SERVER;
        return ((ZombiePigmanEntity)this.orgEntity).func_70631_g_() ? modeldata.ENTITY_BABY_ZOMBIE : modeldata.ENTITY_BIPED;
    }

    static class EntityAIPigmanChase
    extends ChasingGoal {
        boolean angry;

        public EntityAIPigmanChase(BipedMobData<?> entitydata, MobEntity creature) {
            super(entitydata, creature, 1.35, false, Animations.BIPED_RUN, Animations.BIPED_WALK);
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            if (!((ZombiePigmanEntity)this.attacker).func_213398_dR()) {
                if (this.angry) {
                    STCLivingMotionChange msg = new STCLivingMotionChange(this.attacker.func_145782_y(), 1);
                    msg.setMotions(LivingMotion.WALKING);
                    msg.setAnimations(this.walkingAnimation);
                    ModNetworkManager.sendToAllPlayerTrackingThisEntity(msg, (Entity)this.attacker);
                    this.angry = false;
                }
            } else if (!this.angry) {
                STCLivingMotionChange msg = new STCLivingMotionChange(this.attacker.func_145782_y(), 1);
                msg.setMotions(LivingMotion.WALKING);
                msg.setAnimations(this.chasingAnimation);
                ModNetworkManager.sendToAllPlayerTrackingThisEntity(msg, (Entity)this.attacker);
                this.angry = true;
            }
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.angry = true;
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.angry = false;
        }
    }
}

