/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity.player;

import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.entity.event.EntityEventListener;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.gamedata.Skills;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.skill.SkillContainer;
import maninhouse.epicfight.skill.SkillSlot;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;

public abstract class PlayerData<T extends PlayerEntity>
extends LivingData<T> {
    protected float yaw;
    protected EntityEventListener eventListeners;
    public SkillContainer[] skills;

    @Override
    public void init() {
        super.init();
        this.eventListeners = new EntityEventListener(this);
        SkillSlot[] slots = SkillSlot.values();
        this.skills = new SkillContainer[slots.length];
        for (SkillSlot slot : slots) {
            this.skills[slot.getIndex()] = new SkillContainer(this);
        }
        this.skills[SkillSlot.DODGE.getIndex()].setSkill(Skills.ROLL);
        this.volatileAttributes.func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.volatileAttributes.func_111150_b(SharedMonsterAttributes.field_188790_f);
    }

    @Override
    public void initAnimator(AnimatorClient animatorClient) {
        animatorClient.mixLayer.setJointMask("Root", "Torso");
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.BIPED_IDLE);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.BIPED_WALK);
        animatorClient.addLivingAnimation(LivingMotion.RUNNING, Animations.BIPED_RUN);
        animatorClient.addLivingAnimation(LivingMotion.SNEAKING, Animations.BIPED_SNEAK);
        animatorClient.addLivingAnimation(LivingMotion.SWIMMING, Animations.BIPED_SWIM);
        animatorClient.addLivingAnimation(LivingMotion.FLOATING, Animations.BIPED_FLOAT);
        animatorClient.addLivingAnimation(LivingMotion.KNEELING, Animations.BIPED_KNEEL);
        animatorClient.addLivingAnimation(LivingMotion.FALL, Animations.BIPED_FALL);
        animatorClient.addLivingAnimation(LivingMotion.MOUNT, Animations.BIPED_MOUNT);
        animatorClient.addLivingAnimation(LivingMotion.FLYING, Animations.BIPED_FLYING);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.BIPED_DEATH);
        animatorClient.addLivingAnimation(LivingMotion.JUMPING, Animations.BIPED_JUMP);
        animatorClient.addLivingMixAnimation(LivingMotion.BLOCKING, Animations.BIPED_BLOCK);
        animatorClient.addLivingMixAnimation(LivingMotion.AIM, Animations.BIPED_BOW_AIM);
        animatorClient.addLivingMixAnimation(LivingMotion.CHARGING, Animations.BIPED_CROSSBOW_CHARGE);
        animatorClient.addLivingMixAnimation(LivingMotion.REBOUND, Animations.BIPED_BOW_REBOUND);
        animatorClient.setCurrentLivingMotionsToDefault();
    }

    public void changeYaw(float amount) {
        this.yaw = amount;
    }

    @Override
    public void update() {
        if (((PlayerEntity)this.orgEntity).func_184187_bx() == null) {
            for (SkillContainer container : this.skills) {
                if (container == null) continue;
                container.update();
            }
        }
        super.update();
    }

    public SkillContainer getSkill(SkillSlot slot) {
        return this.skills[slot.getIndex()];
    }

    public SkillContainer getSkill(int slotIndex) {
        return this.skills[slotIndex];
    }

    public float getWeightPaneltyMultiplier() {
        if (this.getWeight() > 40.0) {
            return (float)(this.getWeight() / 40.0);
        }
        return 0.0f;
    }

    public float getWeightPaneltyDivider() {
        return (float)(40.0 / this.getWeight());
    }

    public float getAttackSpeed() {
        return (float)((PlayerEntity)this.orgEntity).func_110148_a(SharedMonsterAttributes.field_188790_f).func_111126_e();
    }

    public EntityEventListener getEventListener() {
        return this.eventListeners;
    }

    @Override
    public boolean attackEntityFrom(DamageSource damageSource, float amount) {
        return true;
    }

    @Override
    public IExtendedDamageSource getDamageSource(IExtendedDamageSource.StunType stunType, IExtendedDamageSource.DamageType damageType, int id) {
        return IExtendedDamageSource.causePlayerDamage((PlayerEntity)this.orgEntity, stunType, damageType, id);
    }

    public void discard() {
        super.aboutToDeath();
    }

    @Override
    public Model getEntityModel() {
        return this.isRemote() ? Models.LOGICAL_CLIENT.ENTITY_PLAYER : Models.LOGICAL_SERVER.ENTITY_PLAYER;
    }
}

