/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity.player;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCLivingMotionChange;
import maninhouse.epicfight.network.server.STCNotifyPlayerYawChanged;
import maninhouse.epicfight.network.server.STCPlayAnimation;
import maninhouse.epicfight.network.server.STCSetSkillValue;
import maninhouse.epicfight.skill.SkillContainer;
import maninhouse.epicfight.skill.SkillSlot;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;

public class ServerPlayerData
extends PlayerData<ServerPlayerEntity> {
    private Map<LivingMotion, StaticAnimation> livingMotionMap = Maps.newHashMap();
    private Map<LivingMotion, StaticAnimation> defaultLivingAnimations = Maps.newHashMap();
    private List<LivingMotion> modifiedLivingMotions = Lists.newArrayList();
    private static final UUID WEIGHT_PANELTY_ID = UUID.fromString("414fed9e-e5e3-11ea-adc1-0242ac120002");

    @Override
    public void gatherDamageDealt(IExtendedDamageSource source, float amount) {
        if (source.getSkillId() > Animations.BASIC_ATTACK_MIN && source.getSkillId() < Animations.BASIC_ATTACK_MAX) {
            float value;
            SkillContainer container = this.getSkill(SkillSlot.WEAPON_SPECIAL_ATTACK);
            CapabilityItem itemCap = this.getHeldItemCapability(Hand.MAIN_HAND);
            if (itemCap != null && container.getContaining() != null && container.getContaining().equals(itemCap.getSpecialAttack(((ServerPlayerEntity)this.orgEntity).func_184592_cb())) && (value = container.getRemainCooldown() + amount) > 0.0f) {
                this.getSkill(SkillSlot.WEAPON_SPECIAL_ATTACK).setCooldown(value);
                ModNetworkManager.sendToPlayer(new STCSetSkillValue(STCSetSkillValue.Target.COOLDOWN, SkillSlot.WEAPON_SPECIAL_ATTACK.getIndex(), value, false), (ServerPlayerEntity)this.orgEntity);
            }
        }
    }

    @Override
    public void init() {
        super.init();
        this.livingMotionMap.put(LivingMotion.IDLE, Animations.BIPED_IDLE);
        this.livingMotionMap.put(LivingMotion.WALKING, Animations.BIPED_WALK);
        this.livingMotionMap.put(LivingMotion.RUNNING, Animations.BIPED_RUN);
        this.livingMotionMap.put(LivingMotion.SNEAKING, Animations.BIPED_SNEAK);
        this.livingMotionMap.put(LivingMotion.SWIMMING, Animations.BIPED_SWIM);
        this.livingMotionMap.put(LivingMotion.FLOATING, Animations.BIPED_FLOAT);
        this.livingMotionMap.put(LivingMotion.KNEELING, Animations.BIPED_KNEEL);
        this.livingMotionMap.put(LivingMotion.FALL, Animations.BIPED_FALL);
        this.livingMotionMap.put(LivingMotion.MOUNT, Animations.BIPED_MOUNT);
        this.livingMotionMap.put(LivingMotion.FLYING, Animations.BIPED_FLYING);
        this.livingMotionMap.put(LivingMotion.DEATH, Animations.BIPED_DEATH);
        for (Map.Entry<LivingMotion, StaticAnimation> entry : this.livingMotionMap.entrySet()) {
            this.defaultLivingAnimations.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void updateMotion() {
    }

    public void onHeldItemChange(CapabilityItem mainHandCap, CapabilityItem offHandCap, ItemStack stack) {
        Map<LivingMotion, StaticAnimation> motionChanger;
        if (mainHandCap != null) {
            mainHandCap.initialSetting(this);
        } else {
            this.getSkill(SkillSlot.WEAPON_GIMMICK).setSkill(null);
        }
        ((ServerPlayerEntity)this.orgEntity).func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f).func_188479_b(WEIGHT_PANELTY_ID);
        float weaponSpeed = (float)((ServerPlayerEntity)this.orgEntity).func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f).func_111125_b();
        for (AttributeModifier attributeModifier : stack.func_111283_C(EquipmentSlotType.MAINHAND).get((Object)SharedMonsterAttributes.field_188790_f.func_111108_a())) {
            weaponSpeed = (float)((double)weaponSpeed + attributeModifier.func_111164_d());
        }
        float panelstyMultiplier = this.getWeightPaneltyMultiplier();
        ((ServerPlayerEntity)this.orgEntity).func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f).func_111121_a(new AttributeModifier(WEIGHT_PANELTY_ID, "weightpanelty modifier", (double)(-panelstyMultiplier) * 0.1 * (double)weaponSpeed, AttributeModifier.Operation.ADDITION));
        if (offHandCap != null) {
            // empty if block
        }
        this.resetModifiedLivingMotions();
        if (mainHandCap != null && (motionChanger = mainHandCap.getLivingMotionChanges(this)) != null) {
            ArrayList motions = Lists.newArrayList();
            ArrayList animations = Lists.newArrayList();
            for (Map.Entry<LivingMotion, StaticAnimation> entry : motionChanger.entrySet()) {
                this.addModifiedLivingMotion(entry.getKey(), entry.getValue());
                motions.add(entry.getKey());
                animations.add(entry.getValue());
            }
            LivingMotion[] motionarr = motions.toArray(new LivingMotion[0]);
            StaticAnimation[] animationarr = animations.toArray(new StaticAnimation[0]);
            STCLivingMotionChange msg = new STCLivingMotionChange(((ServerPlayerEntity)this.orgEntity).func_145782_y(), motionChanger.size());
            msg.setMotions(motionarr);
            msg.setAnimations(animationarr);
            ModNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(msg, (ServerPlayerEntity)this.orgEntity);
            return;
        }
        STCLivingMotionChange msg = new STCLivingMotionChange(((ServerPlayerEntity)this.orgEntity).func_145782_y(), 0);
        ModNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(msg, (ServerPlayerEntity)this.orgEntity);
    }

    public void onArmorSlotChanged(CapabilityItem fromCap, CapabilityItem toCap, EquipmentSlotType slotType) {
        this.getOriginalEntity().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f).func_188479_b(WEIGHT_PANELTY_ID);
        float weaponSpeed = (float)this.getOriginalEntity().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f).func_111125_b();
        for (AttributeModifier attributeModifier : this.getOriginalEntity().func_184614_ca().func_111283_C(EquipmentSlotType.MAINHAND).get((Object)SharedMonsterAttributes.field_188790_f.func_111108_a())) {
            weaponSpeed += (float)attributeModifier.func_111164_d();
        }
        this.getOriginalEntity().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f).func_111121_a(new AttributeModifier(WEIGHT_PANELTY_ID, "weightpanelty modifier", (double)(-this.getWeightPaneltyMultiplier()) * 0.1 * (double)weaponSpeed, AttributeModifier.Operation.ADDITION));
    }

    private void addModifiedLivingMotion(LivingMotion motion, StaticAnimation animation) {
        if (!this.modifiedLivingMotions.contains((Object)motion)) {
            this.modifiedLivingMotions.add(motion);
        }
        this.livingMotionMap.put(motion, animation);
    }

    private void resetModifiedLivingMotions() {
        for (LivingMotion livingMotion : this.modifiedLivingMotions) {
            this.livingMotionMap.put(livingMotion, this.defaultLivingAnimations.get((Object)livingMotion));
        }
        this.modifiedLivingMotions.clear();
    }

    public void modifiLivingMotionToAll(STCLivingMotionChange packet) {
        LivingMotion[] motions = packet.getMotions();
        StaticAnimation[] animations = packet.getAnimations();
        for (int i = 0; i < motions.length; ++i) {
            this.addModifiedLivingMotion(motions[i], animations[i]);
        }
        ModNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(packet, (ServerPlayerEntity)this.orgEntity);
    }

    public Set<Map.Entry<LivingMotion, StaticAnimation>> getLivingMotionEntrySet() {
        return this.livingMotionMap.entrySet();
    }

    @Override
    public void setEntity(ServerPlayerEntity vanillaEntity) {
        this.orgEntity = vanillaEntity;
    }

    @Override
    public void playAnimationSynchronize(int id, float modifyTime) {
        super.playAnimationSynchronize(id, modifyTime);
        ModNetworkManager.sendToPlayer(new STCPlayAnimation(id, ((ServerPlayerEntity)this.orgEntity).func_145782_y(), modifyTime), (ServerPlayerEntity)this.orgEntity);
    }

    @Override
    public void changeYaw(float amount) {
        super.changeYaw(amount);
        ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCNotifyPlayerYawChanged(((ServerPlayerEntity)this.orgEntity).func_145782_y(), this.yaw), this.orgEntity);
        ModNetworkManager.sendToPlayer(new STCNotifyPlayerYawChanged(((ServerPlayerEntity)this.orgEntity).func_145782_y(), this.yaw), (ServerPlayerEntity)this.orgEntity);
    }

    @Override
    public ServerPlayerEntity getOriginalEntity() {
        return (ServerPlayerEntity)this.orgEntity;
    }

    @Override
    public void aboutToDeath() {
    }
}

