/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.item;

import java.util.ArrayList;
import java.util.List;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.item.MaterialItemCapability;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Colliders;
import maninhouse.epicfight.gamedata.Skills;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.skill.Skill;
import maninhouse.epicfight.utils.game.DamageAttributes;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.TieredItem;
import net.minecraft.util.SoundEvent;

public class AxeCapability
extends MaterialItemCapability {
    private static List<StaticAnimation> axeAttackMotions = new ArrayList<StaticAnimation>();
    private Skill specialAttack;

    public AxeCapability(Item item) {
        this(((TieredItem)item).func_200891_e());
    }

    public AxeCapability(IItemTier toolMatarial) {
        super(toolMatarial);
        this.specialAttack = toolMatarial == ItemTier.WOOD ? null : Skills.GUILLOTINE_AXE;
    }

    @Override
    public List<StaticAnimation> getAutoAttckMotion(PlayerData<?> playerdata) {
        return axeAttackMotions;
    }

    @Override
    public boolean hasSpecialAttack() {
        return this.material.func_200925_d() != 0;
    }

    @Override
    public Skill getSpecialAttack(ItemStack offhandItem) {
        return this.specialAttack;
    }

    @Override
    protected void registerAttributeTiered() {
        int i = this.material.func_200925_d();
        if (i != 0) {
            this.oneHandedStyleDamageAttribute.addAttribute(DamageAttributes.DEFENCE_IGNORE, 10.0 * (double)i);
        }
        this.oneHandedStyleDamageAttribute.addAttribute(DamageAttributes.IMPACT, 2.5 + 0.5 * (double)i);
        this.oneHandedStyleDamageAttribute.addAttribute(DamageAttributes.MULTIPLE_HIT, 1.0);
    }

    @Override
    public SoundEvent getHitSound() {
        return Sounds.BLADE_HIT;
    }

    @Override
    public Collider getWeaponCollider() {
        return Colliders.tools;
    }

    static {
        axeAttackMotions = new ArrayList<StaticAnimation>();
        axeAttackMotions.add(Animations.TOOL_AUTO_1);
        axeAttackMotions.add(Animations.TOOL_AUTO_2);
        axeAttackMotions.add(Animations.AXE_DASH);
    }
}

