/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Colliders;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.main.EpicFightMod;
import maninhouse.epicfight.particle.HitParticleType;
import maninhouse.epicfight.particle.Particles;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.skill.Skill;
import maninhouse.epicfight.skill.SkillContainer;
import maninhouse.epicfight.skill.SkillSlot;
import maninhouse.epicfight.utils.game.DamageAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public abstract class CapabilityItem {
    protected static List<StaticAnimation> commonAutoAttackMotion = new ArrayList<StaticAnimation>();
    protected DamageAttributes oneHandedStyleDamageAttribute;
    protected DamageAttributes twoHandedStyleDamageAttribute;

    public static List<StaticAnimation> getBasicAutoAttackMotion() {
        return commonAutoAttackMotion;
    }

    protected void loadClientThings() {
    }

    public CapabilityItem() {
        if (EpicFightMod.isPhysicalClient()) {
            this.loadClientThings();
        }
        this.oneHandedStyleDamageAttribute = new DamageAttributes();
        this.registerAttribute();
    }

    public CapabilityItem(Item originalItem) {
        this.oneHandedStyleDamageAttribute = new DamageAttributes();
    }

    protected void registerAttribute() {
    }

    public void modifyItemTooltip(List<ITextComponent> itemTooltip, boolean isOffhandEmpty) {
        if (this.isTwoHanded()) {
            itemTooltip.add(1, new StringTextComponent("Twohanded").func_211708_a(TextFormatting.DARK_GRAY));
        } else if (!this.canUsedOffhand()) {
            itemTooltip.add(1, new StringTextComponent("Mainhand Only").func_211708_a(TextFormatting.DARK_GRAY));
        }
        DamageAttributes attribute = this.getDamageAttributesInCondition(isOffhandEmpty);
        if (attribute != null) {
            for (IAttributeInstance attr : attribute.getAttributeMap().func_111146_a()) {
                if (attr.func_111126_e() == 0.0) continue;
                itemTooltip.add((ITextComponent)new StringTextComponent(" " + String.format(attr.func_111123_a().func_111108_a(), attr.func_111126_e())));
            }
        }
    }

    public List<StaticAnimation> getAutoAttckMotion(PlayerData<?> playerdata) {
        return CapabilityItem.getBasicAutoAttackMotion();
    }

    public List<StaticAnimation> getMountAttackMotion() {
        return null;
    }

    public boolean hasSpecialAttack() {
        return false;
    }

    public Skill getSpecialAttack(ItemStack offhandItem) {
        return null;
    }

    public Skill getPassiveSkill() {
        return null;
    }

    public void initialSetting(PlayerData<?> player) {
        SkillContainer skillContainer;
        Skill skill;
        if (this.hasSpecialAttack()) {
            skill = this.getSpecialAttack(((PlayerEntity)player.getOriginalEntity()).func_184592_cb());
            skillContainer = player.getSkill(SkillSlot.WEAPON_SPECIAL_ATTACK);
            if (skillContainer.getContaining() != skill) {
                skillContainer.setSkill(skill);
            }
        }
        skill = this.getPassiveSkill();
        skillContainer = player.getSkill(SkillSlot.WEAPON_GIMMICK);
        if (skill == null) {
            skillContainer.setSkill(null);
        } else if (skillContainer.getContaining() != skill) {
            skillContainer.setSkill(skill);
        }
    }

    public SoundEvent getSmashingSound() {
        return Sounds.WHOOSH;
    }

    public SoundEvent getHitSound() {
        return Sounds.BLUNT_HIT;
    }

    public Collider getWeaponCollider() {
        return Colliders.fist;
    }

    public HitParticleType getHitParticle() {
        return (HitParticleType)Particles.HIT_BLUNT.get();
    }

    public DamageAttributes getDamageAttributesInCondition(boolean offhandEmtpy) {
        return this.isTwoHanded() || !this.canUsedOffhand() && offhandEmtpy ? this.twoHandedStyleDamageAttribute : this.oneHandedStyleDamageAttribute;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot) {
        return HashMultimap.create();
    }

    public Map<LivingMotion, StaticAnimation> getLivingMotionChanges(PlayerData<?> player) {
        return null;
    }

    public boolean canUsedOffhand() {
        return !this.isTwoHanded();
    }

    public boolean isTwoHanded() {
        return false;
    }

    public boolean canCompatibleWith(ItemStack item) {
        return !this.isTwoHanded() && item.getCapability(ModCapabilities.CAPABILITY_ITEM).orElse(null) == null;
    }

    public boolean canUseOnMount() {
        return !this.isTwoHanded();
    }

    static {
        commonAutoAttackMotion.add(Animations.FIST_AUTO_1);
        commonAutoAttackMotion.add(Animations.FIST_AUTO_2);
        commonAutoAttackMotion.add(Animations.FIST_AUTO_3);
        commonAutoAttackMotion.add(Animations.FIST_DASH);
    }
}

