/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.particle.HitParticleType;
import maninhouse.epicfight.particle.Particles;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.skill.Skill;
import maninhouse.epicfight.utils.game.DamageAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;

public class ModWeaponCapability
extends CapabilityItem {
    protected final Skill specialAttack;
    protected final Skill weaponGimmick;
    protected final SoundEvent smashingSound;
    protected final SoundEvent hitSound;
    protected final Collider weaponCollider;
    protected final boolean twoHanded;
    protected final boolean mainHandOnly;
    protected List<StaticAnimation> autoAttackMotions;
    protected List<StaticAnimation> autoAttackTwohandMotions;
    protected List<StaticAnimation> mountAttackMotion;
    protected Map<LivingMotion, StaticAnimation> livingMotionChangers;

    public ModWeaponCapability(Skill specialAttack, Skill weaponGimmick, SoundEvent smash, SoundEvent hit, Collider weaponCollider, double armorIgnorance, double impact, int hitEnemiesAtOnce, boolean twoHanded, boolean mainHandOnly) {
        this.specialAttack = specialAttack;
        this.weaponGimmick = weaponGimmick;
        this.smashingSound = smash;
        this.hitSound = hit;
        this.twoHanded = twoHanded;
        this.mainHandOnly = mainHandOnly;
        this.oneHandedStyleDamageAttribute.addAttribute(DamageAttributes.DEFENCE_IGNORE, armorIgnorance);
        this.oneHandedStyleDamageAttribute.addAttribute(DamageAttributes.IMPACT, impact);
        this.oneHandedStyleDamageAttribute.addAttribute(DamageAttributes.MULTIPLE_HIT, hitEnemiesAtOnce);
        this.weaponCollider = weaponCollider;
    }

    public void addLivingMotionChanger(LivingMotion livingMotion, StaticAnimation animation) {
        if (this.livingMotionChangers == null) {
            this.livingMotionChangers = new HashMap<LivingMotion, StaticAnimation>();
        }
        this.livingMotionChangers.put(livingMotion, animation);
    }

    public void addAutoAttackCombos(StaticAnimation animation) {
        if (this.autoAttackMotions == null) {
            this.autoAttackMotions = new ArrayList<StaticAnimation>();
        }
        this.autoAttackMotions.add(animation);
    }

    public void addTwohandAutoAttackCombos(StaticAnimation animation) {
        if (this.autoAttackTwohandMotions == null) {
            this.autoAttackTwohandMotions = new ArrayList<StaticAnimation>();
        }
        this.autoAttackTwohandMotions.add(animation);
    }

    public void addMountAttackCombos(StaticAnimation animation) {
        if (this.mountAttackMotion == null) {
            this.mountAttackMotion = new ArrayList<StaticAnimation>();
        }
        this.mountAttackMotion.add(animation);
    }

    @Override
    public List<StaticAnimation> getAutoAttckMotion(PlayerData<?> playerdata) {
        ItemStack offHandItem = ((PlayerEntity)playerdata.getOriginalEntity()).func_184592_cb();
        return this.autoAttackMotions != null || this.autoAttackTwohandMotions != null ? (this.twoHanded || !this.canUsedOffhand() && offHandItem.func_190926_b() ? this.autoAttackTwohandMotions : this.autoAttackMotions) : super.getAutoAttckMotion(playerdata);
    }

    @Override
    public List<StaticAnimation> getMountAttackMotion() {
        return this.mountAttackMotion;
    }

    @Override
    public boolean hasSpecialAttack() {
        return this.specialAttack != null;
    }

    @Override
    public Skill getSpecialAttack(ItemStack offhandItem) {
        return this.specialAttack;
    }

    @Override
    public Skill getPassiveSkill() {
        return this.weaponGimmick;
    }

    @Override
    public SoundEvent getSmashingSound() {
        return this.smashingSound;
    }

    @Override
    public SoundEvent getHitSound() {
        return this.hitSound;
    }

    @Override
    public HitParticleType getHitParticle() {
        return (HitParticleType)Particles.HIT_CUT.get();
    }

    @Override
    public Collider getWeaponCollider() {
        return this.weaponCollider != null ? this.weaponCollider : super.getWeaponCollider();
    }

    @Override
    public boolean canUsedOffhand() {
        return this.twoHanded ? false : !this.mainHandOnly;
    }

    public void setTwoHandStyleAttribute(double armorIgnorance, double impact, int hitEnemiesAtOnce) {
        this.twoHandedStyleDamageAttribute = new DamageAttributes();
        this.twoHandedStyleDamageAttribute.addAttribute(DamageAttributes.DEFENCE_IGNORE, armorIgnorance);
        this.twoHandedStyleDamageAttribute.addAttribute(DamageAttributes.IMPACT, impact);
        this.twoHandedStyleDamageAttribute.addAttribute(DamageAttributes.MULTIPLE_HIT, hitEnemiesAtOnce);
    }

    @Override
    public boolean isTwoHanded() {
        return this.twoHanded;
    }

    @Override
    public Map<LivingMotion, StaticAnimation> getLivingMotionChanges(PlayerData<?> player) {
        return this.livingMotionChangers;
    }
}

