/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.item;

import java.util.ArrayList;
import java.util.List;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.item.MaterialItemCapability;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Colliders;
import maninhouse.epicfight.gamedata.Skills;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.skill.Skill;
import maninhouse.epicfight.utils.game.DamageAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.SwordItem;
import net.minecraft.item.TieredItem;
import net.minecraft.util.SoundEvent;

public class SwordCapability
extends MaterialItemCapability {
    private static List<StaticAnimation> swordAttackMotion;
    private static List<StaticAnimation> dualSwordAttackMotion;
    private SoundEvent hitSound;

    public SwordCapability(Item orgItem) {
        this(((TieredItem)orgItem).func_200891_e());
    }

    public SwordCapability(IItemTier toolMatarial) {
        super(toolMatarial);
        SoundEvent soundEvent = this.hitSound = toolMatarial == ItemTier.WOOD ? Sounds.BLUNT_HIT : Sounds.BLADE_HIT;
        if (swordAttackMotion == null) {
            swordAttackMotion = new ArrayList<StaticAnimation>();
            swordAttackMotion.add(Animations.SWORD_AUTO_1);
            swordAttackMotion.add(Animations.SWORD_AUTO_2);
            swordAttackMotion.add(Animations.SWORD_AUTO_3);
            swordAttackMotion.add(Animations.SWORD_DASH);
            dualSwordAttackMotion = new ArrayList<StaticAnimation>();
            dualSwordAttackMotion.add(Animations.SWORD_DUAL_AUTO_1);
            dualSwordAttackMotion.add(Animations.SWORD_DUAL_AUTO_2);
            dualSwordAttackMotion.add(Animations.SWORD_DUAL_AUTO_3);
            dualSwordAttackMotion.add(Animations.SWORD_DUAL_DASH);
        }
    }

    @Override
    protected void registerAttributeTiered() {
        this.oneHandedStyleDamageAttribute.addAttribute(DamageAttributes.MULTIPLE_HIT, 2.0);
        this.oneHandedStyleDamageAttribute.addAttribute(DamageAttributes.IMPACT, 1.0 + 0.2 * (double)this.material.func_200925_d());
    }

    @Override
    public boolean hasSpecialAttack() {
        return this.material.func_200925_d() != 0;
    }

    @Override
    public Skill getSpecialAttack(ItemStack offhandItem) {
        if (offhandItem.func_77973_b() instanceof SwordItem) {
            return Skills.DANCING_EDGE;
        }
        return Skills.SWEEPING_EDGE;
    }

    @Override
    public List<StaticAnimation> getAutoAttckMotion(PlayerData<?> playerdata) {
        if (((PlayerEntity)playerdata.getOriginalEntity()).func_184592_cb().func_77973_b() instanceof SwordItem) {
            return dualSwordAttackMotion;
        }
        return swordAttackMotion;
    }

    @Override
    public SoundEvent getHitSound() {
        return this.hitSound;
    }

    @Override
    public Collider getWeaponCollider() {
        return Colliders.sword;
    }

    @Override
    public boolean canCompatibleWith(ItemStack item) {
        return super.canCompatibleWith(item) || item.func_77973_b() instanceof SwordItem;
    }
}

