/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.item;

import java.util.ArrayList;
import java.util.List;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.item.RangedWeaponCapability;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Colliders;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.particle.HitParticleType;
import maninhouse.epicfight.particle.Particles;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.utils.game.DamageAttributes;
import net.minecraft.util.SoundEvent;

public class TridentCapability
extends RangedWeaponCapability {
    private static List<StaticAnimation> attackMotion;

    public TridentCapability() {
        super(null, Animations.BIPED_JAVELIN_AIM, Animations.BIPED_JAVELIN_REBOUND);
        if (attackMotion == null) {
            attackMotion = new ArrayList<StaticAnimation>();
            attackMotion.add(Animations.SPEAR_AUTO_1);
            attackMotion.add(Animations.SPEAR_DASH);
        }
    }

    @Override
    protected void registerAttribute() {
        this.oneHandedStyleDamageAttribute.addAttribute(DamageAttributes.IMPACT, 2.75);
    }

    @Override
    public SoundEvent getHitSound() {
        return Sounds.BLADE_HIT;
    }

    @Override
    public HitParticleType getHitParticle() {
        return (HitParticleType)Particles.HIT_CUT.get();
    }

    @Override
    public Collider getWeaponCollider() {
        return Colliders.spearNarrow;
    }

    @Override
    public List<StaticAnimation> getAutoAttckMotion(PlayerData<?> playerdata) {
        return attackMotion;
    }

    @Override
    public boolean canUsedOffhand() {
        return false;
    }
}

