/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.item;

import com.google.common.collect.Multimap;
import java.util.List;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.item.ArmorCapability;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.model.Model;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class VanillaArmorCapability
extends ArmorCapability {
    private final EquipmentSlotType armorType;
    private final float weight;

    public VanillaArmorCapability(ArmorItem item) {
        super(null, null);
        this.armorType = item.func_185083_B_();
        if (item.func_200880_d() instanceof ArmorMaterial) {
            switch ((ArmorMaterial)item.func_200880_d()) {
                case LEATHER: {
                    this.weight = item.func_200881_e();
                    break;
                }
                case GOLD: {
                    this.weight = (float)item.func_200881_e() * 2.5f;
                    break;
                }
                case CHAIN: {
                    this.weight = (float)item.func_200881_e() * 2.5f;
                    break;
                }
                case IRON: {
                    this.weight = (float)item.func_200881_e() * 3.0f;
                    break;
                }
                case DIAMOND: {
                    this.weight = (float)item.func_200881_e() * 3.0f;
                    break;
                }
                default: {
                    this.weight = 0.0f;
                    break;
                }
            }
        } else {
            this.weight = 0.0f;
        }
    }

    @Override
    public void modifyItemTooltip(List<ITextComponent> itemTooltip, boolean isOffhandEmpty) {
        itemTooltip.add(1, (ITextComponent)new StringTextComponent(TextFormatting.BLUE + " +" + (int)this.weight + " Weight"));
    }

    @Override
    public Model getEquipModel(EquipmentSlotType slot, boolean smallsize) {
        switch (slot) {
            case HEAD: {
                return smallsize ? Models.LOGICAL_CLIENT.ITEM_HELMET_BABYSIZE : Models.LOGICAL_CLIENT.ITEM_HELMET;
            }
            case CHEST: {
                return smallsize ? Models.LOGICAL_CLIENT.ITEM_CHESTPLATE_BABYSIZE : Models.LOGICAL_CLIENT.ITEM_CHESTPLATE;
            }
            case LEGS: {
                return smallsize ? Models.LOGICAL_CLIENT.ITEM_LEGGINS_BABYSIZE : Models.LOGICAL_CLIENT.ITEM_LEGGINS;
            }
            case FEET: {
                return smallsize ? Models.LOGICAL_CLIENT.ITEM_BOOTS_BABYSIZE : Models.LOGICAL_CLIENT.ITEM_BOOTS;
            }
        }
        return null;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot) {
        Multimap<String, AttributeModifier> attributes = super.getAttributeModifiers(equipmentSlot);
        if (equipmentSlot == this.armorType) {
            attributes.put((Object)LivingData.WEIGHT.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Armor modifier", (double)this.weight, AttributeModifier.Operation.ADDITION).func_111168_a(false));
        }
        return attributes;
    }
}

