/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client;

import maninhouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninhouse.epicfight.client.eventengine.ControllEngine;
import maninhouse.epicfight.client.eventengine.RenderEngine;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientEngine {
    public static ClientEngine INSTANCE;
    public ClientPlayerData playerdata;
    public RenderEngine renderEngine;
    public ControllEngine inputController;
    private PlayerActingMode playerActingMode = PlayerActingMode.MINING;
    private int pointOfViewMemory;

    public ClientEngine() {
        INSTANCE = this;
        this.renderEngine = new RenderEngine();
        this.inputController = new ControllEngine();
    }

    public void toggleActingMode() {
        if (this.playerActingMode == PlayerActingMode.MINING) {
            this.switchToBattleMode();
        } else {
            this.switchToMiningMode();
        }
    }

    private void switchToMiningMode() {
        this.playerActingMode = PlayerActingMode.MINING;
        this.renderEngine.guiSkillBar.slideDown();
        if (this.pointOfViewMemory == 0) {
            Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
        }
    }

    private void switchToBattleMode() {
        this.playerActingMode = PlayerActingMode.BATTLE;
        this.renderEngine.guiSkillBar.slideUp();
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            Minecraft.func_71410_x().field_71474_y.field_74320_O = 1;
        }
    }

    public void setLastPointOfView(int pov) {
        this.pointOfViewMemory = pov;
    }

    public PlayerActingMode getPlayerActingMode() {
        return this.playerActingMode;
    }

    public static enum PlayerActingMode {
        MINING,
        BATTLE;

    }
}

