/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.animation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import maninhouse.epicfight.animation.AnimationPlayer;
import maninhouse.epicfight.animation.Animator;
import maninhouse.epicfight.animation.Joint;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.Pose;
import maninhouse.epicfight.animation.types.MirrorAnimation;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.client.ClientEngine;
import maninhouse.epicfight.client.animation.BaseLayer;
import maninhouse.epicfight.client.animation.MixLayer;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.utils.math.Mat4f;

public class AnimatorClient
extends Animator {
    private final Map<LivingMotion, StaticAnimation> livingAnimations = new HashMap<LivingMotion, StaticAnimation>();
    private Map<LivingMotion, StaticAnimation> defaultLivingAnimations;
    private List<LivingMotion> modifiedLivingMotions;
    public final BaseLayer baseLayer;
    public final MixLayer mixLayer;
    private LivingMotion currentMotion;
    private LivingMotion currentMixMotion;
    public boolean reversePlay = false;
    public boolean mixLayerActivated = false;

    public AnimatorClient(LivingData<?> entitydata) {
        this.entitydata = entitydata;
        this.baseLayer = new BaseLayer(Animations.DUMMY_ANIMATION);
        this.mixLayer = new MixLayer(Animations.DUMMY_ANIMATION);
        this.currentMotion = LivingMotion.IDLE;
        this.currentMixMotion = LivingMotion.NONE;
        this.defaultLivingAnimations = new HashMap<LivingMotion, StaticAnimation>();
        this.modifiedLivingMotions = new ArrayList<LivingMotion>();
    }

    @Override
    public void playAnimation(int id, float modifyTime) {
        this.playAnimation(Animations.findAnimationDataById(id), modifyTime);
    }

    @Override
    public void playAnimation(StaticAnimation nextAnimation, float modifyTime) {
        this.baseLayer.pause = false;
        this.mixLayer.pause = false;
        this.reversePlay = false;
        this.baseLayer.playAnimation(nextAnimation, this.entitydata, modifyTime);
    }

    @Override
    public void vacateCurrentPlay() {
        this.baseLayer.animationPlayer.setPlayAnimation(Animations.DUMMY_ANIMATION);
    }

    public void addLivingAnimation(LivingMotion motion, StaticAnimation animation) {
        this.livingAnimations.put(motion, animation);
        if (motion == this.currentMotion && !this.entitydata.isInaction()) {
            this.playAnimation(animation, 0.0f);
        }
    }

    public void addLivingMixAnimation(LivingMotion motion, StaticAnimation animation) {
        this.livingAnimations.put(motion, animation);
        if (motion == this.currentMotion && !this.entitydata.isInaction()) {
            if (animation instanceof MirrorAnimation) {
                this.playMixLayerAnimationUpper(((MirrorAnimation)animation).checkHandAndReturnAnimation(this.entitydata.getOriginalEntity().func_184600_cs()));
            } else {
                this.playMixLayerAnimationUpper(animation);
            }
        }
    }

    public void addModifiedLivingMotion(LivingMotion motion, StaticAnimation animation) {
        if (!this.modifiedLivingMotions.contains((Object)motion)) {
            this.modifiedLivingMotions.add(motion);
        }
        this.addLivingAnimation(motion, animation);
    }

    public void resetModifiedLivingMotions() {
        if (this.modifiedLivingMotions != null) {
            for (LivingMotion livingMotion : this.modifiedLivingMotions) {
                this.addLivingAnimation(livingMotion, this.defaultLivingAnimations.get((Object)livingMotion));
            }
            this.modifiedLivingMotions.clear();
        }
    }

    public void setCurrentLivingMotionsToDefault() {
        this.defaultLivingAnimations.clear();
        this.defaultLivingAnimations.putAll(this.livingAnimations);
    }

    public void playLoopMotion() {
        this.currentMotion = this.entitydata.currentMotion;
        if (this.livingAnimations.containsKey((Object)this.entitydata.currentMotion)) {
            this.baseLayer.playAnimation(this.livingAnimations.get((Object)this.entitydata.currentMotion), this.entitydata, 0.0f);
        }
    }

    public void playMixLoopMotion() {
        if (this.entitydata.currentMixMotion == LivingMotion.NONE) {
            this.offMixLayer(false);
        } else {
            StaticAnimation animation = this.livingAnimations.get((Object)this.entitydata.currentMixMotion);
            if (animation instanceof MirrorAnimation) {
                this.playMixLayerAnimationUpper(((MirrorAnimation)animation).checkHandAndReturnAnimation(this.entitydata.getOriginalEntity().func_184600_cs()));
            } else {
                this.playMixLayerAnimationUpper(animation);
            }
        }
        this.mixLayer.pause = false;
        this.currentMixMotion = this.entitydata.currentMixMotion;
    }

    public void playMixLayerAnimation(int id) {
        this.playMixLayerAnimation(Animations.findAnimationDataById(id));
    }

    public void playMixLayerAnimationUpper(StaticAnimation nextAnimation) {
        this.playMixLayerAnimation(nextAnimation);
    }

    public void playMixLayerAnimation(StaticAnimation nextAnimation) {
        if (!this.mixLayerActivated) {
            this.mixLayerActivated = true;
            this.mixLayer.animationPlayer.synchronize(this.baseLayer.animationPlayer);
        }
        this.mixLayer.linkEndPhase = false;
        this.mixLayer.setPlayAnimationWithJointMask(nextAnimation, this.entitydata, 0.0f);
    }

    public void offMixLayer(boolean offForce) {
        if (this.mixLayerActivated && (offForce || this.mixLayer.animationPlayer.getPlay().getState(this.mixLayer.animationPlayer.getElapsedTime()) != LivingData.EntityState.POST_DELAY)) {
            this.mixLayer.linkEndPhase = true;
            this.mixLayer.setMixLinkAnimation(this.entitydata, 0.0f);
            this.mixLayer.playAnimation(this.mixLayer.mixLinkAnimation, this.entitydata);
            this.mixLayer.nextPlaying = null;
            this.mixLayer.pause = false;
        }
    }

    public void disableMixLayer() {
        this.mixLayerActivated = false;
        if (this.mixLayer.animationPlayer.getPlay() != null) {
            this.mixLayer.animationPlayer.getPlay().onFinish(this.entitydata, true);
            this.mixLayer.animationPlayer.setEmpty();
        }
        this.mixLayer.animationPlayer.resetPlayer();
    }

    public void setPoseToModel() {
        if (this.mixLayerActivated) {
            this.applyPoseToJoint(this.getCurrentPose(this.baseLayer), this.getCurrentPose(this.mixLayer), this.entitydata.getEntityModel().getArmature().getJointHierarcy(), new Mat4f());
        } else {
            this.applyPoseToJoint(this.getCurrentPose(this.baseLayer), this.entitydata.getEntityModel().getArmature().getJointHierarcy(), new Mat4f());
        }
    }

    private void applyPoseToJoint(Pose base, Pose mix, Joint joint, Mat4f parentTransform) {
        if (this.mixLayer.jointMasked(joint.getName())) {
            Mat4f currentLocalTransformBase = base.getTransformByName(joint.getName()).toTransformMatrix();
            Mat4f.mul(joint.getLocalTrasnform(), currentLocalTransformBase, currentLocalTransformBase);
            Mat4f bindTransformBase = Mat4f.mul(parentTransform, currentLocalTransformBase, null);
            Mat4f currentLocalTransformMix = mix.getTransformByName(joint.getName()).toTransformMatrix();
            Mat4f.mul(joint.getLocalTrasnform(), currentLocalTransformMix, currentLocalTransformMix);
            Mat4f bindTransformMix = Mat4f.mul(parentTransform, currentLocalTransformMix, null);
            bindTransformMix.m31 = bindTransformBase.m31;
            joint.setAnimatedTransform(bindTransformMix);
            for (Joint joints : joint.getSubJoints()) {
                if (this.mixLayer.jointMasked(joints.getName()) || this.currentMotion == LivingMotion.IDLE) {
                    this.applyPoseToJoint(mix, joints, bindTransformMix);
                    continue;
                }
                this.applyPoseToJoint(base, joints, bindTransformBase);
            }
        } else {
            Mat4f currentLocalTransform = base.getTransformByName(joint.getName()).toTransformMatrix();
            Mat4f.mul(joint.getLocalTrasnform(), currentLocalTransform, currentLocalTransform);
            Mat4f bindTransform = Mat4f.mul(parentTransform, currentLocalTransform, null);
            joint.setAnimatedTransform(bindTransform);
            for (Joint joints : joint.getSubJoints()) {
                this.applyPoseToJoint(base, mix, joints, bindTransform);
            }
        }
    }

    private void applyPoseToJoint(Pose pose, Joint joint, Mat4f parentTransform) {
        Mat4f currentLocalTransform = pose.getTransformByName(joint.getName()).toTransformMatrix();
        Mat4f.mul(joint.getLocalTrasnform(), currentLocalTransform, currentLocalTransform);
        Mat4f bindTransform = Mat4f.mul(parentTransform, currentLocalTransform, null);
        Mat4f.mul(bindTransform, joint.getAnimatedTransform(), bindTransform);
        joint.setAnimatedTransform(bindTransform);
        for (Joint joints : joint.getSubJoints()) {
            this.applyPoseToJoint(pose, joints, bindTransform);
        }
    }

    @Override
    public void update() {
        if (this.pause) {
            return;
        }
        this.baseLayer.update(this.entitydata, this.reversePlay);
        if (this.baseLayer.animationPlayer.isEnd() && this.baseLayer.nextPlaying == null) {
            this.entitydata.updateMotion();
            this.playLoopMotion();
        }
        if (this.mixLayerActivated) {
            this.mixLayer.update(this.entitydata, false);
            if (this.mixLayer.animationPlayer.isEnd()) {
                if (this.mixLayer.linkEndPhase) {
                    if (!this.pause && this.mixLayer.nextPlaying == null) {
                        this.disableMixLayer();
                        this.mixLayer.linkEndPhase = false;
                    }
                } else {
                    this.mixLayer.animationPlayer.getPlay().onFinish(this.entitydata, this.mixLayer.animationPlayer.isEnd());
                    if (!this.mixLayer.pause) {
                        this.mixLayer.setMixLinkAnimation(this.entitydata, 0.0f);
                        this.mixLayer.playAnimation(this.mixLayer.mixLinkAnimation, this.entitydata);
                        this.mixLayer.linkEndPhase = true;
                    }
                }
            }
        }
    }

    @Override
    public void playDeathAnimation() {
        this.playAnimation(this.livingAnimations.get((Object)LivingMotion.DEATH), 0.0f);
    }

    public StaticAnimation getJumpAnimation() {
        return this.livingAnimations.get((Object)LivingMotion.JUMPING);
    }

    public StaticAnimation getDeathAnimation() {
        return this.livingAnimations.get((Object)LivingMotion.DEATH);
    }

    @Override
    public void onEntityDeath() {
        this.baseLayer.clear(this.entitydata);
        this.mixLayer.clear(this.entitydata);
    }

    public Pose getCurrentPose(BaseLayer layer) {
        return layer.animationPlayer.getCurrentPose(this.entitydata, this.baseLayer.pause ? 1.0f : ClientEngine.INSTANCE.renderEngine.getPartialTicks());
    }

    public boolean compareMotion(LivingMotion motion) {
        return this.currentMotion == motion;
    }

    public boolean compareMixMotion(LivingMotion motion) {
        return this.currentMixMotion == motion;
    }

    public void resetMotion() {
        this.currentMotion = LivingMotion.IDLE;
    }

    public void resetMixMotion() {
        this.currentMixMotion = LivingMotion.NONE;
    }

    public boolean prevAiming() {
        return this.currentMixMotion == LivingMotion.AIM;
    }

    public void playReboundAnimation() {
        this.playMixLayerAnimationUpper(this.livingAnimations.get((Object)LivingMotion.REBOUND));
        this.entitydata.resetLivingMixLoop();
    }

    @Override
    public AnimationPlayer getPlayer() {
        return this.baseLayer.animationPlayer;
    }

    @Override
    public AnimationPlayer getPlayerFor(StaticAnimation animation) {
        AnimationPlayer player = this.baseLayer.animationPlayer;
        if (player.getPlay().equals(animation)) {
            return player;
        }
        player = this.mixLayer.animationPlayer;
        if (player.getPlay().equals(animation)) {
            return player;
        }
        return null;
    }

    public AnimationPlayer getMixLayerPlayer() {
        return this.mixLayer.animationPlayer;
    }
}

