/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.animation;

import maninhouse.epicfight.animation.types.DynamicAnimation;
import maninhouse.epicfight.animation.types.MixLinkAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.client.ClientEngine;
import maninhouse.epicfight.client.animation.BaseLayer;
import maninhouse.epicfight.collada.AnimationDataExtractor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MixLayer
extends BaseLayer {
    protected String[] maskedJointNames = new String[0];
    protected boolean linkEndPhase = false;
    protected MixLinkAnimation mixLinkAnimation;

    public MixLayer(DynamicAnimation animation) {
        super(animation);
    }

    public void setPlayAnimationWithJointMask(DynamicAnimation nextAnimation, LivingData<?> entitydata, float modifyTime) {
        this.animationPlayer.getPlay().onFinish(entitydata, this.animationPlayer.isEnd());
        this.setLinkAnimation(nextAnimation, entitydata, modifyTime);
        nextAnimation.onActivate(entitydata);
        this.linkAnimation.putOnPlayer(this.animationPlayer);
        this.nextPlaying = nextAnimation;
    }

    public void setMixLinkAnimation(LivingData<?> entitydata, float timeModifier) {
        this.mixLinkAnimation = AnimationDataExtractor.getLinkAnimation(timeModifier + entitydata.getClientAnimator().baseLayer.animationPlayer.getPlay().getConvertTime(), this.animationPlayer.getCurrentPose(entitydata, ClientEngine.INSTANCE.renderEngine.getPartialTicks()));
    }

    public void setJointMask(String ... maskedJoint) {
        this.maskedJointNames = maskedJoint;
    }

    public boolean jointMasked(String s) {
        for (String str : this.maskedJointNames) {
            if (!s.equals(str)) continue;
            return true;
        }
        return false;
    }
}

