/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.capabilites.entity;

import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.client.CTSReqPlayerInfo;
import maninhouse.epicfight.utils.math.Mat4f;
import maninhouse.epicfight.utils.math.MathUtils;
import maninhouse.epicfight.utils.math.Vec3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RemoteClientPlayerData<T extends AbstractClientPlayerEntity>
extends PlayerData<T> {
    protected float prevYaw;
    protected float bodyYaw;
    protected float prevBodyYaw;
    private ItemStack prevHeldItem;
    private ItemStack prevHeldItemOffHand;
    private boolean swingArm;

    @Override
    public void init() {
        super.init();
        this.prevHeldItem = ItemStack.field_190927_a;
        this.prevHeldItemOffHand = ItemStack.field_190927_a;
        if (!(this instanceof ClientPlayerData)) {
            ModNetworkManager.sendToServer(new CTSReqPlayerInfo(((AbstractClientPlayerEntity)this.orgEntity).func_145782_y()));
        }
    }

    @Override
    public void updateMotion() {
        if (((AbstractClientPlayerEntity)this.orgEntity).func_184613_cA()) {
            this.currentMotion = LivingMotion.FLYING;
        } else if (((AbstractClientPlayerEntity)this.orgEntity).func_184187_bx() != null) {
            this.currentMotion = LivingMotion.MOUNT;
        } else if (((AbstractClientPlayerEntity)this.orgEntity).func_213283_Z() == Pose.SWIMMING && !((AbstractClientPlayerEntity)this.orgEntity).func_184587_cr()) {
            this.currentMotion = LivingMotion.SWIMMING;
        } else {
            AnimatorClient animator = this.getClientAnimator();
            if (((AbstractClientPlayerEntity)this.orgEntity).func_204231_K() && ((AbstractClientPlayerEntity)this.orgEntity).func_213322_ci().field_72448_b < -0.005) {
                this.currentMotion = LivingMotion.FLOATING;
            } else if (((AbstractClientPlayerEntity)this.orgEntity).func_213322_ci().field_72448_b < (double)-0.55f) {
                this.currentMotion = LivingMotion.FALL;
            } else if (((AbstractClientPlayerEntity)this.orgEntity).field_70721_aZ > 0.01f) {
                this.currentMotion = ((AbstractClientPlayerEntity)this.orgEntity).func_70093_af() ? LivingMotion.SNEAKING : (((AbstractClientPlayerEntity)this.orgEntity).func_70051_ag() ? LivingMotion.RUNNING : LivingMotion.WALKING);
                if (((AbstractClientPlayerEntity)this.orgEntity).field_191988_bg > 0.0f) {
                    animator.reversePlay = false;
                } else if (((AbstractClientPlayerEntity)this.orgEntity).field_191988_bg < 0.0f) {
                    animator.reversePlay = true;
                }
            } else {
                animator.reversePlay = false;
                this.currentMotion = ((AbstractClientPlayerEntity)this.orgEntity).func_70093_af() ? LivingMotion.KNEELING : LivingMotion.IDLE;
            }
        }
        if (((AbstractClientPlayerEntity)this.orgEntity).func_184587_cr() && ((AbstractClientPlayerEntity)this.orgEntity).func_184605_cv() > 0) {
            UseAction useAction = ((AbstractClientPlayerEntity)this.orgEntity).func_184586_b(((AbstractClientPlayerEntity)this.orgEntity).func_184600_cs()).func_77975_n();
            this.currentMixMotion = useAction == UseAction.BLOCK ? LivingMotion.BLOCKING : (useAction == UseAction.BOW ? LivingMotion.AIM : (useAction == UseAction.CROSSBOW ? LivingMotion.CHARGING : (useAction == UseAction.SPEAR ? LivingMotion.AIM : LivingMotion.NONE)));
        } else if (CrossbowItem.func_220012_d((ItemStack)((AbstractClientPlayerEntity)this.orgEntity).func_184614_ca())) {
            this.currentMixMotion = LivingMotion.AIM;
        } else if (this.getClientAnimator().prevAiming()) {
            this.playReboundAnimation();
        } else {
            this.currentMixMotion = LivingMotion.NONE;
        }
    }

    @Override
    protected void updateOnClient() {
        boolean isOffHandChanged;
        this.prevYaw = this.yaw;
        this.prevBodyYaw = this.bodyYaw;
        this.bodyYaw = this.inaction ? ((AbstractClientPlayerEntity)this.orgEntity).field_70177_z : ((AbstractClientPlayerEntity)this.orgEntity).field_70760_ar;
        boolean isMainHandChanged = this.prevHeldItem.func_77973_b() != ((AbstractClientPlayerEntity)this.orgEntity).field_71071_by.func_70448_g().func_77973_b();
        boolean bl = isOffHandChanged = this.prevHeldItemOffHand.func_77973_b() != ((ItemStack)((AbstractClientPlayerEntity)this.orgEntity).field_71071_by.field_184439_c.get(0)).func_77973_b();
        if (isMainHandChanged || isOffHandChanged) {
            this.onHeldItemChange(this.getHeldItemCapability(Hand.MAIN_HAND), this.getHeldItemCapability(Hand.OFF_HAND));
        }
        if (isMainHandChanged) {
            this.prevHeldItem = ((AbstractClientPlayerEntity)this.orgEntity).field_71071_by.func_70448_g();
        }
        if (isOffHandChanged) {
            this.prevHeldItemOffHand = (ItemStack)((AbstractClientPlayerEntity)this.orgEntity).field_71071_by.field_184439_c.get(0);
        }
        super.updateOnClient();
        if (((AbstractClientPlayerEntity)this.orgEntity).field_70725_aQ == 1) {
            this.getClientAnimator().playDeathAnimation();
        }
        if (this.swingArm != ((AbstractClientPlayerEntity)this.orgEntity).field_82175_bq) {
            if (!this.swingArm) {
                this.getClientAnimator().playMixLayerAnimationUpper(Animations.BIPED_DIG);
            } else {
                this.getClientAnimator().offMixLayer(false);
            }
            this.swingArm = ((AbstractClientPlayerEntity)this.orgEntity).field_82175_bq;
        }
    }

    public void onHeldItemChange(CapabilityItem mainHandCap, CapabilityItem offHandCap) {
        this.getClientAnimator().resetMixMotion();
        this.getClientAnimator().offMixLayer(false);
        this.cancelUsingItem();
    }

    protected void playReboundAnimation() {
        this.getClientAnimator().playReboundAnimation();
    }

    @Override
    public void playAnimationSynchronize(int id, float modifyTime) {
    }

    @Override
    public Model getEntityModel() {
        Models modeldata = this.isRemote() ? Models.LOGICAL_CLIENT : Models.LOGICAL_SERVER;
        return ((AbstractClientPlayerEntity)this.orgEntity).func_175154_l().equals("slim") ? modeldata.ENTITY_SLIM_PLAYER : modeldata.ENTITY_PLAYER;
    }

    @Override
    public Mat4f getHeadMatrix(float partialTick) {
        float yaw;
        AbstractClientPlayerEntity entity = (AbstractClientPlayerEntity)this.getOriginalEntity();
        float pitch = 0.0f;
        float prvePitch = 0.0f;
        if (this.inaction || entity.func_184187_bx() != null) {
            yaw = 0.0f;
        } else {
            float f = MathUtils.interpolateRotation(this.prevBodyYaw, this.bodyYaw, partialTick);
            float f1 = MathUtils.interpolateRotation(entity.field_70758_at, entity.field_70759_as, partialTick);
            yaw = f1 - f;
        }
        if (!((AbstractClientPlayerEntity)this.orgEntity).func_184613_cA()) {
            prvePitch = entity.field_70127_C;
            pitch = entity.field_70125_A;
        }
        return MathUtils.getModelMatrixIntegrated(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, prvePitch, pitch, yaw, yaw, partialTick);
    }

    @Override
    public Mat4f getModelMatrix(float partialTick) {
        float rotyaw;
        float prevRotYaw;
        Object entity = this.getOriginalEntity();
        if (((AbstractClientPlayerEntity)this.orgEntity).func_204805_cN()) {
            Mat4f mat = MathUtils.getModelMatrixIntegrated((float)((LivingEntity)entity).field_70142_S, (float)((LivingEntity)entity).field_70165_t, (float)((LivingEntity)entity).field_70137_T, (float)((LivingEntity)entity).field_70163_u, (float)((LivingEntity)entity).field_70136_U, (float)((LivingEntity)entity).field_70161_v, 0.0f, 0.0f, 0.0f, 0.0f, partialTick);
            float yawDegree = MathUtils.interpolateRotation(((AbstractClientPlayerEntity)this.orgEntity).field_70126_B, ((AbstractClientPlayerEntity)this.orgEntity).field_70177_z, partialTick);
            float pitchDegree = MathUtils.interpolateRotation(((AbstractClientPlayerEntity)this.orgEntity).field_70127_C, ((AbstractClientPlayerEntity)this.orgEntity).field_70125_A, partialTick) + 90.0f;
            Mat4f.rotate((float)(-Math.toRadians(yawDegree)), new Vec3f(0.0f, 1.0f, 0.0f), mat, mat);
            Mat4f.rotate((float)(-Math.toRadians(pitchDegree)), new Vec3f(1.0f, 0.0f, 0.0f), mat, mat);
            Mat4f.rotate((float)Math.toRadians((double)((float)((AbstractClientPlayerEntity)this.orgEntity).field_70173_aa + partialTick) * -55.0), new Vec3f(0.0f, 1.0f, 0.0f), mat, mat);
            return mat;
        }
        if (((AbstractClientPlayerEntity)this.orgEntity).func_184613_cA()) {
            Mat4f mat = MathUtils.getModelMatrixIntegrated((float)((LivingEntity)entity).field_70142_S, (float)((LivingEntity)entity).field_70165_t, (float)((LivingEntity)entity).field_70137_T, (float)((LivingEntity)entity).field_70163_u, (float)((LivingEntity)entity).field_70136_U, (float)((LivingEntity)entity).field_70161_v, 0.0f, 0.0f, 0.0f, 0.0f, partialTick);
            Mat4f.rotate((float)(-Math.toRadians(((LivingEntity)entity).field_70761_aq)), new Vec3f(0.0f, 1.0f, 0.0f), mat, mat);
            float f = (float)((AbstractClientPlayerEntity)this.orgEntity).func_184599_cB() + Minecraft.func_71410_x().func_184121_ak();
            float f1 = MathHelper.func_76131_a((float)(f * f / 100.0f), (float)0.0f, (float)1.0f);
            Mat4f.rotate((float)Math.toRadians(f1 * (-90.0f - ((AbstractClientPlayerEntity)this.orgEntity).field_70125_A)), new Vec3f(1.0f, 0.0f, 0.0f), mat, mat);
            Vec3d vec3d = ((AbstractClientPlayerEntity)this.orgEntity).func_70676_i(Minecraft.func_71410_x().func_184121_ak());
            Vec3d vec3d1 = ((AbstractClientPlayerEntity)this.orgEntity).func_213322_ci();
            double d0 = vec3d1.field_72450_a * vec3d1.field_72450_a + vec3d1.field_72449_c * vec3d1.field_72449_c;
            double d1 = vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c;
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec3d1.field_72450_a * vec3d.field_72450_a + vec3d1.field_72449_c * vec3d.field_72449_c) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = vec3d1.field_72450_a * vec3d.field_72449_c - vec3d1.field_72449_c * vec3d.field_72450_a;
                Mat4f.rotate((float)Math.toRadians((float)(Math.signum(d3) * Math.acos(d2)) * 180.0f / (float)Math.PI), new Vec3f(0.0f, 1.0f, 0.0f), mat, mat);
            }
            return mat;
        }
        float prevPitch = 0.0f;
        float pitch = 0.0f;
        if (((AbstractClientPlayerEntity)this.orgEntity).func_184187_bx() instanceof LivingEntity) {
            LivingEntity ridingEntity = (LivingEntity)((AbstractClientPlayerEntity)this.orgEntity).func_184187_bx();
            prevRotYaw = ridingEntity.field_70760_ar;
            rotyaw = ridingEntity.field_70761_aq;
        } else {
            float yaw = this.inaction ? MathUtils.interpolateRotation(this.prevYaw, this.yaw, partialTick) : 0.0f;
            prevRotYaw = this.prevBodyYaw + yaw;
            rotyaw = this.bodyYaw + yaw;
        }
        if (!this.isInaction() && ((AbstractClientPlayerEntity)this.orgEntity).func_213283_Z() == Pose.SWIMMING) {
            float f4;
            float f = ((AbstractClientPlayerEntity)this.orgEntity).func_205015_b(partialTick);
            float f3 = ((AbstractClientPlayerEntity)this.orgEntity).func_70090_H() ? ((AbstractClientPlayerEntity)this.orgEntity).field_70125_A : 0.0f;
            prevPitch = f4 = MathHelper.func_219799_g((float)f, (float)0.0f, (float)f3);
            pitch = f4;
        }
        return MathUtils.getModelMatrixIntegrated((float)((LivingEntity)entity).field_70142_S, (float)((LivingEntity)entity).field_70165_t, (float)((LivingEntity)entity).field_70137_T, (float)((LivingEntity)entity).field_70163_u, (float)((LivingEntity)entity).field_70136_U, (float)((LivingEntity)entity).field_70161_v, prevPitch, pitch, prevRotYaw, rotyaw, partialTick);
    }
}

