/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.eventengine;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntConsumer;
import maninhouse.epicfight.animation.Animator;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.client.ClientEngine;
import maninhouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninhouse.epicfight.client.input.KeyBindings;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.client.CTSPlayAnimation;
import maninhouse.epicfight.skill.SkillContainer;
import maninhouse.epicfight.skill.SkillSlot;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.settings.KeyBindingMap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;

@OnlyIn(value=Dist.CLIENT)
public class ControllEngine {
    private Map<KeyBinding, IntConsumer> keyFunctions;
    private GLFWCursorPosCallbackI callback = (handle, x, y) -> {
        this.tracingMouseX = x;
        this.tracingMouseY = y;
    };
    private Field dx = ObfuscationReflectionHelper.findField(MouseHelper.class, (String)"field_198040_e");
    private Field dy = ObfuscationReflectionHelper.findField(MouseHelper.class, (String)"field_198041_f");
    private Field sprintTimer = ObfuscationReflectionHelper.findField(ClientPlayerEntity.class, (String)"field_71156_d");
    private KeyBindingMap keyHash;
    private ClientPlayerEntity player;
    private ClientPlayerData playerdata;
    private double tracingMouseX;
    private double tracingMouseY;
    private int comboHoldCounter;
    private int comboCounter;
    private int mouseLeftPressCounter = 0;
    private int sneakPressCounter = 0;
    private int reservedSkill;
    private int skillReserveCounter;
    private boolean sneakPressToggle = false;
    private boolean mouseLeftPressToggle = false;
    private boolean lightPress;
    public GameSettings gameSettings;

    public ControllEngine() {
        Events.controllEngine = this;
        this.dx.setAccessible(true);
        this.dy.setAccessible(true);
        this.gameSettings = Minecraft.func_71410_x().field_71474_y;
        this.keyFunctions = new HashMap<KeyBinding, IntConsumer>();
        this.keyFunctions.put(this.gameSettings.field_74312_F, this::attackKeyPressed);
        this.keyFunctions.put(this.gameSettings.field_74311_E, this::sneakKeyPressed);
        this.keyFunctions.put(this.gameSettings.field_186718_X, this::swapHandKeyPressed);
        this.keyFunctions.put(this.gameSettings.field_151457_aa, this::perspectiveToggleKeyPressed);
        this.keyFunctions.put(KeyBindings.SWITCH_MODE, this::switchModeKeyPressed);
        try {
            this.keyHash = (KeyBindingMap)ObfuscationReflectionHelper.findField(KeyBinding.class, (String)"field_74514_b").get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public void setGamePlayer(ClientPlayerData playerdata) {
        this.comboCounter = 0;
        this.mouseLeftPressCounter = 0;
        this.mouseLeftPressToggle = false;
        this.sneakPressCounter = 0;
        this.sneakPressToggle = false;
        this.lightPress = false;
        this.player = (ClientPlayerEntity)playerdata.getOriginalEntity();
        this.playerdata = playerdata;
    }

    public boolean playerCanMove(LivingData.EntityState playerState) {
        return playerState == LivingData.EntityState.FREE || playerState == LivingData.EntityState.FREE_INPUT || this.player.func_110317_t();
    }

    public boolean playerCanRotate(LivingData.EntityState playerState) {
        return playerState == LivingData.EntityState.FREE_CAMERA || playerState == LivingData.EntityState.FREE || this.player.func_110317_t();
    }

    public boolean playerCanAct(LivingData.EntityState playerState) {
        return !this.player.func_184613_cA() && this.playerdata.currentMotion != LivingMotion.FALL && (playerState == LivingData.EntityState.FREE || playerState == LivingData.EntityState.FREE_INPUT);
    }

    public boolean playerCanDodging(LivingData.EntityState playerState) {
        return !this.player.func_184613_cA() && this.playerdata.currentMotion != LivingMotion.FALL && (playerState == LivingData.EntityState.FREE || playerState == LivingData.EntityState.FREE_INPUT || playerState == LivingData.EntityState.POST_DELAY);
    }

    public boolean playerCanExecuteSkill(LivingData.EntityState playerState) {
        return !this.player.func_184613_cA() && this.playerdata.currentMotion != LivingMotion.FALL && (playerState == LivingData.EntityState.FREE || playerState == LivingData.EntityState.FREE_INPUT || playerState == LivingData.EntityState.POST_DELAY);
    }

    private void attackKeyPressed(int action) {
        if (action == 1 && ClientEngine.INSTANCE.getPlayerActingMode() == ClientEngine.PlayerActingMode.BATTLE) {
            this.setKeyBind(this.gameSettings.field_74312_F, false);
            this.gameSettings.field_74312_F.func_151468_f();
            if (this.player.func_184605_cv() == 0 && !this.mouseLeftPressToggle) {
                this.mouseLeftPressToggle = true;
            }
        }
        if (this.player.func_184825_o(0.0f) < 0.9f) {
            this.gameSettings.field_74312_F.func_151468_f();
        }
    }

    private void sneakKeyPressed(int action) {
        if (action == 1 && this.player.func_184187_bx() == null && ClientEngine.INSTANCE.getPlayerActingMode() == ClientEngine.PlayerActingMode.BATTLE && !this.sneakPressToggle) {
            this.sneakPressToggle = true;
        }
    }

    private void swapHandKeyPressed(int action) {
        CapabilityItem cap = this.playerdata.getHeldItemCapability(Hand.MAIN_HAND);
        if (this.playerdata.isInaction() || cap != null && !cap.canUsedOffhand()) {
            while (this.gameSettings.field_186718_X.func_151468_f()) {
            }
            this.setKeyBind(this.gameSettings.field_186718_X, false);
        }
    }

    private void switchModeKeyPressed(int action) {
        if (action == 1) {
            ClientEngine.INSTANCE.toggleActingMode();
        }
    }

    private void perspectiveToggleKeyPressed(int action) {
        if (action == 1 || action == 2) {
            if (ClientEngine.INSTANCE.getPlayerActingMode() == ClientEngine.PlayerActingMode.BATTLE) {
                if (action == 2) {
                    while (this.gameSettings.field_151457_aa.func_151468_f()) {
                    }
                } else if (this.gameSettings.field_74320_O == 2) {
                    this.gameSettings.field_74320_O = 0;
                }
            }
            ClientEngine.INSTANCE.setLastPointOfView((this.gameSettings.field_74320_O + 1) % 3);
        }
    }

    public void tick() {
        SkillContainer skill;
        LivingData.EntityState playerState = this.playerdata.getEntityState();
        if (this.mouseLeftPressToggle) {
            if (!this.isKeyDown(this.gameSettings.field_74312_F)) {
                this.lightPress = true;
                this.mouseLeftPressToggle = false;
                this.mouseLeftPressCounter = 0;
            } else if (this.mouseLeftPressCounter > 2) {
                if (this.playerCanExecuteSkill(playerState)) {
                    CapabilityItem itemCap = this.playerdata.getHeldItemCapability(Hand.MAIN_HAND);
                    if (itemCap != null) {
                        this.playerdata.getSkill(SkillSlot.WEAPON_SPECIAL_ATTACK).execute(this.playerdata);
                    }
                } else {
                    this.reserveSkill(SkillSlot.WEAPON_SPECIAL_ATTACK);
                }
                this.mouseLeftPressToggle = false;
                this.mouseLeftPressCounter = 0;
                this.resetAttackCounter();
            } else {
                this.setKeyBind(this.gameSettings.field_74312_F, false);
                ++this.mouseLeftPressCounter;
            }
        }
        if (this.lightPress) {
            if (this.playerCanAct(playerState)) {
                this.playAttackMotion(this.player.func_184614_ca(), this.player.func_70051_ag());
                this.player.func_184821_cY();
                this.lightPress = false;
            } else if (playerState == LivingData.EntityState.FREE_CAMERA || playerState == LivingData.EntityState.PRE_DELAY) {
                this.lightPress = false;
            }
            this.mouseLeftPressToggle = false;
            this.mouseLeftPressCounter = 0;
        }
        if (this.sneakPressToggle) {
            if (!this.isKeyDown(this.gameSettings.field_74311_E)) {
                skill = this.playerdata.getSkill(SkillSlot.DODGE);
                if (skill.canExecute(this.playerdata) && skill.getContaining().isExecutableState(this.playerdata)) {
                    skill.execute(this.playerdata);
                }
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else if (this.sneakPressCounter > 2) {
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else {
                ++this.sneakPressCounter;
            }
        }
        if (this.reservedSkill >= 0) {
            if (this.skillReserveCounter > 0) {
                skill = this.playerdata.getSkill(this.reservedSkill);
                --this.skillReserveCounter;
                if (skill.getContaining() != null && skill.canExecute(this.playerdata) && skill.getContaining().isExecutableState(this.playerdata)) {
                    skill.execute(this.playerdata);
                    this.reservedSkill = -1;
                    this.skillReserveCounter = -1;
                }
            } else {
                this.reservedSkill = -1;
                this.skillReserveCounter = -1;
            }
        }
        if (this.comboHoldCounter > 0) {
            float f = this.player.func_184825_o(0.0f);
            if (playerState == LivingData.EntityState.FREE && f >= 1.0f) {
                --this.comboHoldCounter;
                if (this.comboHoldCounter == 0) {
                    this.resetAttackCounter();
                }
            }
        }
        for (int i = 0; i < 9; ++i) {
            if (!this.isKeyDown(this.gameSettings.field_151456_ac[i]) || !this.playerdata.isInaction()) continue;
            this.gameSettings.field_151456_ac[i].func_151468_f();
        }
        if (Minecraft.func_71410_x().func_147113_T()) {
            Minecraft.func_71410_x().field_71417_B.func_198029_a(Minecraft.func_71410_x().field_195558_d.func_198092_i());
        }
    }

    private void playAttackMotion(ItemStack holdItem, boolean dashAttack) {
        CapabilityItem cap = (CapabilityItem)holdItem.getCapability(ModCapabilities.CAPABILITY_ITEM, null).orElse(null);
        StaticAnimation attackMotion = null;
        if (this.player.func_184187_bx() != null) {
            if (this.player.func_110317_t() && cap != null && cap.canUseOnMount()) {
                attackMotion = cap.getMountAttackMotion().get(this.comboCounter);
                ++this.comboCounter;
                this.comboCounter %= cap.getMountAttackMotion().size();
            }
        } else {
            List<StaticAnimation> combo = null;
            if (combo == null) {
                combo = cap != null ? (combo = cap.getAutoAttckMotion(this.playerdata)) : CapabilityItem.getBasicAutoAttackMotion();
            }
            int comboSize = combo.size();
            if (dashAttack) {
                this.comboCounter = comboSize - 1;
            }
            attackMotion = combo.get(this.comboCounter);
            this.comboCounter = dashAttack ? 0 : this.comboCounter + 1;
            this.comboCounter %= comboSize - 1;
        }
        this.comboHoldCounter = 10;
        if (attackMotion != null) {
            ((Animator)this.playerdata.getAnimator()).playAnimation(attackMotion, 0.0f);
            ModNetworkManager.sendToServer(new CTSPlayAnimation(attackMotion, 0.0f, false, false));
        }
    }

    private void reserveSkill(SkillSlot slot) {
        this.reservedSkill = slot.getIndex();
        this.skillReserveCounter = 8;
    }

    public boolean isKeyDown(KeyBinding key) {
        if (key.getKey().func_197938_b() == InputMappings.Type.KEYSYM) {
            return GLFW.glfwGetKey((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)key.getKey().func_197937_c()) > 0;
        }
        if (key.getKey().func_197938_b() == InputMappings.Type.MOUSE) {
            return GLFW.glfwGetMouseButton((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)key.getKey().func_197937_c()) > 0;
        }
        return false;
    }

    public void setKeyBind(KeyBinding key, boolean setter) {
        KeyBinding.func_197980_a((InputMappings.Input)key.getKey(), (boolean)setter);
    }

    public void resetAttackCounter() {
        this.comboCounter = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
    public static class Events {
        static ControllEngine controllEngine;

        @SubscribeEvent
        public static void mouseEvent(InputEvent.MouseInputEvent event) {
            if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71462_r == null) {
                InputMappings.Input input = InputMappings.Type.MOUSE.func_197944_a(event.getButton());
                for (KeyBinding keybinding : controllEngine.keyHash.lookupAll(input)) {
                    if (!controllEngine.keyFunctions.containsKey(keybinding)) continue;
                    ((IntConsumer)controllEngine.keyFunctions.get(keybinding)).accept(event.getAction());
                }
            }
        }

        @SubscribeEvent
        public static void mouseScrollEvent(InputEvent.MouseScrollEvent event) {
            if (Minecraft.func_71410_x().field_71439_g != null && controllEngine.playerdata.isInaction() && Minecraft.func_71410_x().field_71462_r == null) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void keyboardEvent(InputEvent.KeyInputEvent event) {
            if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71462_r == null) {
                InputMappings.Input input = InputMappings.Type.KEYSYM.func_197944_a(event.getKey());
                for (KeyBinding keybinding : controllEngine.keyHash.lookupAll(input)) {
                    if (!controllEngine.keyFunctions.containsKey(keybinding)) continue;
                    ((IntConsumer)controllEngine.keyFunctions.get(keybinding)).accept(event.getAction());
                }
            }
        }

        @SubscribeEvent
        public static void moveInputEvent(InputUpdateEvent event) {
            Minecraft game = Minecraft.func_71410_x();
            LivingData.EntityState playerState = controllEngine.playerdata.getEntityState();
            if (!controllEngine.playerCanRotate(playerState)) {
                GLFW.glfwSetCursorPosCallback((long)game.field_195558_d.func_198092_i(), (GLFWCursorPosCallbackI)controllEngine.callback);
                try {
                    controllEngine.dx.setDouble(game.field_71417_B, controllEngine.tracingMouseX);
                    controllEngine.dy.setDouble(game.field_71417_B, controllEngine.tracingMouseY);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    controllEngine.tracingMouseX = controllEngine.dx.getDouble(game.field_71417_B);
                    controllEngine.tracingMouseY = controllEngine.dy.getDouble(game.field_71417_B);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
                game.field_71417_B.func_198029_a(Minecraft.func_71410_x().field_195558_d.func_198092_i());
            }
            if (!controllEngine.playerCanMove(playerState)) {
                event.getMovementInput().field_192832_b = 0.0f;
                event.getMovementInput().field_78902_a = 0.0f;
                event.getMovementInput().field_187255_c = false;
                event.getMovementInput().field_187256_d = false;
                event.getMovementInput().field_187257_e = false;
                event.getMovementInput().field_187258_f = false;
                event.getMovementInput().field_78901_c = false;
                event.getMovementInput().field_78899_d = false;
                try {
                    controllEngine.sprintTimer.setInt(event.getPlayer(), -1);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }

        @SubscribeEvent
        public static void preProcessKeyBindings(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.START && Minecraft.func_71410_x().field_71439_g != null) {
                controllEngine.tick();
            }
        }
    }
}

