/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.eventengine;

import com.mojang.blaze3d.platform.GlStateManager;
import java.lang.reflect.Field;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.client.ClientEngine;
import maninhouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninhouse.epicfight.client.gui.HealthBarIndicator;
import maninhouse.epicfight.client.gui.SkillBarGui;
import maninhouse.epicfight.client.input.KeyBindings;
import maninhouse.epicfight.client.renderer.ShaderRenderer;
import maninhouse.epicfight.client.renderer.debug.RenderAimHelper;
import maninhouse.epicfight.client.renderer.debug.RenderLine;
import maninhouse.epicfight.client.renderer.debug.RenderOBB;
import maninhouse.epicfight.client.renderer.entity.RenderArmatureEntity;
import maninhouse.epicfight.client.renderer.entity.RenderCaveSpiderMod;
import maninhouse.epicfight.client.renderer.entity.RenderCreeperMod;
import maninhouse.epicfight.client.renderer.entity.RenderDrownedMod;
import maninhouse.epicfight.client.renderer.entity.RenderEndermanMod;
import maninhouse.epicfight.client.renderer.entity.RenderEvokerMod;
import maninhouse.epicfight.client.renderer.entity.RenderHuskMod;
import maninhouse.epicfight.client.renderer.entity.RenderIronGolemMod;
import maninhouse.epicfight.client.renderer.entity.RenderPigZombieMod;
import maninhouse.epicfight.client.renderer.entity.RenderPillagerMod;
import maninhouse.epicfight.client.renderer.entity.RenderPlayerMod;
import maninhouse.epicfight.client.renderer.entity.RenderRavagerMod;
import maninhouse.epicfight.client.renderer.entity.RenderSkeletonMod;
import maninhouse.epicfight.client.renderer.entity.RenderSpiderMod;
import maninhouse.epicfight.client.renderer.entity.RenderStrayMod;
import maninhouse.epicfight.client.renderer.entity.RenderVexMod;
import maninhouse.epicfight.client.renderer.entity.RenderVindicatorMod;
import maninhouse.epicfight.client.renderer.entity.RenderWitchMod;
import maninhouse.epicfight.client.renderer.entity.RenderWitherSkeletonMod;
import maninhouse.epicfight.client.renderer.entity.RenderZombieMod;
import maninhouse.epicfight.client.renderer.entity.RenderZombieVillagerMod;
import maninhouse.epicfight.client.renderer.item.RenderBow;
import maninhouse.epicfight.client.renderer.item.RenderCrossBow;
import maninhouse.epicfight.client.renderer.item.RenderElytra;
import maninhouse.epicfight.client.renderer.item.RenderHeadDeco;
import maninhouse.epicfight.client.renderer.item.RenderItemBase;
import maninhouse.epicfight.client.renderer.item.RenderKatana;
import maninhouse.epicfight.client.renderer.item.RenderShield;
import maninhouse.epicfight.client.renderer.item.RenderTrident;
import maninhouse.epicfight.client.renderer.layer.LayerRenderer;
import maninhouse.epicfight.item.ItemKatana;
import maninhouse.epicfight.item.ModItems;
import maninhouse.epicfight.utils.math.Mat4f;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.Vec4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.StrayEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.TridentItem;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class RenderEngine {
    private static final Vec3f AIMING_CORRECTION = new Vec3f(-1.5f, 0.0f, 1.25f);
    public static final ResourceLocation NULL_TEXTURE = new ResourceLocation("epicfight", "textures/gui/null.png");
    public RenderLine linerender;
    public RenderOBB obb;
    public RenderAimHelper aimHelper;
    public SkillBarGui guiSkillBar = new SkillBarGui();
    public HealthBarIndicator entityHealthbarRenderer = new HealthBarIndicator();
    public LayerRenderer layerRenderer;
    private Minecraft minecraft;
    private FloatBuffer projMatHolder;
    private FloatBuffer viewMatHolder;
    private Mat4f projectionMatrix;
    private Mat4f viewMatrix;
    private Map<Class<? extends Entity>, RenderArmatureEntity> entityRendererMap;
    private Map<Item, RenderItemBase> itemRendererMapByInstance;
    private Map<Class<? extends Item>, RenderItemBase> itemRendererMapByClass;
    private Field lightTextureFinder = ObfuscationReflectionHelper.findField(GameRenderer.class, (String)"field_78513_d");
    private Field nativeImageFInder = ObfuscationReflectionHelper.findField(LightTexture.class, (String)"field_205111_b");
    private LightTexture lightTex;
    private NativeImage nativeImg;
    private boolean aiming;
    private int zoomOutTimer = 0;
    private int zoomCount;
    private int zoomMaxCount = 20;
    private float renderPartialTick;

    public RenderEngine() {
        Events.renderEngine = this;
        RenderItemBase.renderEngine = this;
        ShaderRenderer.renderEngine = this;
        this.minecraft = Minecraft.func_71410_x();
        this.entityRendererMap = new HashMap<Class<? extends Entity>, RenderArmatureEntity>();
        this.itemRendererMapByInstance = new HashMap<Item, RenderItemBase>();
        this.itemRendererMapByClass = new HashMap<Class<? extends Item>, RenderItemBase>();
        this.projMatHolder = GLAllocation.func_74529_h((int)16);
        this.viewMatHolder = GLAllocation.func_74529_h((int)16);
        this.projectionMatrix = new Mat4f();
        this.viewMatrix = new Mat4f();
        try {
            this.lightTex = (LightTexture)this.lightTextureFinder.get(Minecraft.func_71410_x().field_71460_t);
            this.nativeImg = (NativeImage)this.nativeImageFInder.get(this.lightTex);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public void buildRenderer() {
        IResourceManager rm = this.minecraft.func_195551_G();
        this.entityRendererMap.put(CreeperEntity.class, new RenderCreeperMod(rm));
        this.entityRendererMap.put(EndermanEntity.class, new RenderEndermanMod(rm));
        this.entityRendererMap.put(ZombieEntity.class, new RenderZombieMod(rm));
        this.entityRendererMap.put(ZombieVillagerEntity.class, new RenderZombieVillagerMod(rm));
        this.entityRendererMap.put(ZombiePigmanEntity.class, new RenderPigZombieMod(rm));
        this.entityRendererMap.put(HuskEntity.class, new RenderHuskMod(rm));
        this.entityRendererMap.put(SkeletonEntity.class, new RenderSkeletonMod(rm));
        this.entityRendererMap.put(WitherSkeletonEntity.class, new RenderWitherSkeletonMod(rm));
        this.entityRendererMap.put(StrayEntity.class, new RenderStrayMod(rm));
        this.entityRendererMap.put(RemoteClientPlayerEntity.class, new RenderPlayerMod(rm));
        this.entityRendererMap.put(ClientPlayerEntity.class, new RenderPlayerMod(rm));
        this.entityRendererMap.put(SpiderEntity.class, new RenderSpiderMod(rm));
        this.entityRendererMap.put(CaveSpiderEntity.class, new RenderCaveSpiderMod(rm));
        this.entityRendererMap.put(IronGolemEntity.class, new RenderIronGolemMod(rm));
        this.entityRendererMap.put(VindicatorEntity.class, new RenderVindicatorMod(rm));
        this.entityRendererMap.put(EvokerEntity.class, new RenderEvokerMod(rm));
        this.entityRendererMap.put(WitchEntity.class, new RenderWitchMod(rm));
        this.entityRendererMap.put(DrownedEntity.class, new RenderDrownedMod(rm));
        this.entityRendererMap.put(PillagerEntity.class, new RenderPillagerMod(rm));
        this.entityRendererMap.put(RavagerEntity.class, new RenderRavagerMod(rm));
        this.entityRendererMap.put(VexEntity.class, new RenderVexMod(rm));
        RenderBow bowRenderer = new RenderBow();
        RenderCrossBow crossbowRenderer = new RenderCrossBow();
        RenderElytra elytraRenderer = new RenderElytra();
        RenderHeadDeco hatRenderer = new RenderHeadDeco();
        RenderKatana katanaRenderer = new RenderKatana();
        RenderShield shieldRenderer = new RenderShield();
        RenderTrident tridentRenderer = new RenderTrident();
        this.itemRendererMapByInstance.put(Items.field_190931_a, new RenderItemBase());
        this.itemRendererMapByInstance.put(Items.field_151031_f, bowRenderer);
        this.itemRendererMapByInstance.put(Items.field_185159_cQ, shieldRenderer);
        this.itemRendererMapByInstance.put(Items.field_185160_cR, elytraRenderer);
        this.itemRendererMapByInstance.put(Items.field_196185_dy, hatRenderer);
        this.itemRendererMapByInstance.put(Items.field_196151_dA, hatRenderer);
        this.itemRendererMapByInstance.put(Items.field_196184_dx, hatRenderer);
        this.itemRendererMapByInstance.put(Items.field_196186_dz, hatRenderer);
        this.itemRendererMapByInstance.put(Items.field_196182_dv, hatRenderer);
        this.itemRendererMapByInstance.put(Items.field_196183_dw, hatRenderer);
        this.itemRendererMapByInstance.put(Items.field_221689_cG, hatRenderer);
        this.itemRendererMapByInstance.put(Items.field_222114_py, crossbowRenderer);
        this.itemRendererMapByInstance.put(Items.field_203184_eO, tridentRenderer);
        this.itemRendererMapByInstance.put(ModItems.KATANA, katanaRenderer);
        this.itemRendererMapByClass.put(BlockItem.class, hatRenderer);
        this.itemRendererMapByClass.put(BowItem.class, bowRenderer);
        this.itemRendererMapByClass.put(CrossbowItem.class, crossbowRenderer);
        this.itemRendererMapByClass.put(ElytraItem.class, elytraRenderer);
        this.itemRendererMapByClass.put(ShieldItem.class, shieldRenderer);
        this.itemRendererMapByClass.put(TridentItem.class, tridentRenderer);
        this.itemRendererMapByClass.put(ItemKatana.class, katanaRenderer);
        this.linerender = new RenderLine(rm);
        this.obb = new RenderOBB(rm);
        this.aimHelper = new RenderAimHelper(rm);
        this.layerRenderer = new LayerRenderer();
    }

    public RenderItemBase getItemRenderer(Item item) {
        RenderItemBase renderItem = this.itemRendererMapByInstance.get(item);
        if (renderItem == null) {
            renderItem = this.findMatchingRendererByClass(item.getClass());
            if (renderItem == null) {
                renderItem = this.itemRendererMapByInstance.get(Items.field_190931_a);
            }
            this.itemRendererMapByInstance.put(item, renderItem);
        }
        return renderItem;
    }

    private RenderItemBase findMatchingRendererByClass(Class<?> clazz) {
        RenderItemBase renderer = null;
        while (clazz != null && renderer == null) {
            renderer = this.itemRendererMapByClass.getOrDefault(clazz, null);
            clazz = clazz.getSuperclass();
        }
        return renderer;
    }

    public void clearRenderers() {
        for (ShaderRenderer shaderRenderer : this.entityRendererMap.values()) {
            shaderRenderer.clearRenderer();
        }
    }

    public void renderEntityArmatureModel(LivingData<?> modEntity) {
        RenderArmatureEntity render;
        if (modEntity != null && (render = this.entityRendererMap.get(modEntity.getOriginalEntity().getClass())) != null) {
            render.doRender(modEntity);
        }
    }

    public boolean isEntityContained(Entity entity) {
        return this.entityRendererMap.containsKey(entity.getClass());
    }

    public void zoomIn() {
        this.aiming = true;
        this.zoomCount = this.zoomCount == 0 ? 1 : this.zoomCount;
        this.zoomOutTimer = 0;
    }

    public void zoomOut(int timer) {
        this.aiming = false;
        this.zoomOutTimer = timer;
    }

    public float getPartialTicks() {
        return this.renderPartialTick;
    }

    private void updateCameraInfo(ActiveRenderInfo info, int viewMode, float partialTicks) {
        double d3;
        Entity entity = this.minecraft.func_175606_aa();
        double posX = info.func_216785_c().field_72450_a;
        double posY = info.func_216785_c().field_72448_b;
        double posZ = info.func_216785_c().field_72449_c;
        double entityPosX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double entityPosY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks + (double)entity.func_70047_e();
        double entityPosZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        float intpol = viewMode == 1 ? (float)this.zoomCount / (float)this.zoomMaxCount : 0.0f;
        Vec3f interpolatedCorrection = new Vec3f(RenderEngine.AIMING_CORRECTION.x * intpol, RenderEngine.AIMING_CORRECTION.y * intpol, RenderEngine.AIMING_CORRECTION.z * intpol);
        Mat4f rotationMatrix = ClientEngine.INSTANCE.playerdata.getMatrix(this.getPartialTicks());
        if (viewMode == 2) {
            Mat4f.rotate((float)Math.toRadians(180.0), new Vec3f(0.0f, 1.0f, 0.0f), rotationMatrix, rotationMatrix);
        }
        Vec4f rotateVec = Mat4f.transform(rotationMatrix, new Vec4f(interpolatedCorrection.x, interpolatedCorrection.y, interpolatedCorrection.z, 1.0f), null);
        double smallest = d3 = Math.sqrt(rotateVec.x * rotateVec.x + rotateVec.y * rotateVec.y + rotateVec.z * rotateVec.z);
        double d00 = posX + (double)rotateVec.x;
        double d11 = posY - (double)rotateVec.y;
        double d22 = posZ + (double)rotateVec.z;
        for (int i = 0; i < 8; ++i) {
            double d7;
            BlockRayTraceResult raytraceresult;
            float f = (i & 1) * 2 - 1;
            float f1 = (i >> 1 & 1) * 2 - 1;
            float f2 = (i >> 2 & 1) * 2 - 1;
            if ((raytraceresult = this.minecraft.field_71441_e.func_217299_a(new RayTraceContext(new Vec3d(entityPosX + (double)(f *= 0.1f), entityPosY + (double)(f1 *= 0.1f), entityPosZ + (double)(f2 *= 0.1f)), new Vec3d(d00 + (double)f + (double)f2, d11 + (double)f1, d22 + (double)f2), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity))) == null || !((d7 = raytraceresult.func_216347_e().func_72438_d(new Vec3d(entityPosX, entityPosY, entityPosZ))) < smallest)) continue;
            smallest = d7;
        }
        float dist = d3 == 0.0 ? 0.0f : (float)(smallest / d3);
        GlStateManager.translatef((float)(interpolatedCorrection.x * dist), (float)(-interpolatedCorrection.y * dist), (float)(interpolatedCorrection.z * dist));
        this.viewMatrix.setIdentity();
        GL11.glGetFloatv((int)2982, (FloatBuffer)this.viewMatHolder);
        this.viewMatrix.load(this.viewMatHolder.asReadOnlyBuffer());
        if (viewMode == 2) {
            this.viewMatrix.rotate((float)Math.toRadians(180.0), new Vec3f(0.0f, 1.0f, 0.0f));
        }
        this.viewMatrix.rotate((float)Math.toRadians(entity.func_195050_f(partialTicks)), new Vec3f(1.0f, 0.0f, 0.0f));
        this.viewMatrix.rotate((float)Math.toRadians(entity.func_195046_g(partialTicks)), new Vec3f(0.0f, 1.0f, 0.0f));
        this.viewMatrix.translate(new Vec3f((float)posX, (float)(-posY), (float)posZ));
        GL11.glGetFloatv((int)2983, (FloatBuffer)this.projMatHolder);
        this.projectionMatrix.load(this.projMatHolder.asReadOnlyBuffer());
    }

    public Mat4f getViewMatrix() {
        return this.viewMatrix;
    }

    public Mat4f getCurrentProjectionMatrix() {
        return this.projectionMatrix;
    }

    public Vec3f getTotalLight(int sky, int block) {
        int color = this.nativeImg.func_195709_a(sky, block);
        Vec4f color4f = this.convertColorToVector(color, false);
        return new Vec3f(color4f.x, color4f.y, color4f.z);
    }

    public Vec4f convertColorToVector(int color, boolean reverse) {
        float r = (float)(color & 0xFF) / 255.0f;
        float g = (float)((color >>= 8) & 0xFF) / 255.0f;
        float b = (float)((color >>= 8) & 0xFF) / 255.0f;
        if (reverse) {
            return new Vec4f(b, g, r, 1.0f);
        }
        return new Vec4f(r, g, b, 1.0f);
    }

    @Mod.EventBusSubscriber(modid="epicfight", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Events {
        static RenderEngine renderEngine;

        @SubscribeEvent
        public static void renderLivingEvent(RenderLivingEvent.Pre event) {
            if (renderEngine.isEntityContained((Entity)event.getEntity())) {
                if (!renderEngine.minecraft.func_175598_ae().func_178627_a()) {
                    return;
                }
                LivingData entitydata = (LivingData)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
                if (entitydata != null && entitydata.getOriginalEntity() != null) {
                    event.setCanceled(true);
                    renderEngine.renderEntityArmatureModel(entitydata);
                }
            }
            if (!Minecraft.func_71410_x().field_71474_y.field_74319_N) {
                Events.renderEngine.entityHealthbarRenderer.renderMobHealthBar(event.getEntity());
            }
        }

        @SubscribeEvent
        public static void itemTooltip(ItemTooltipEvent event) {
            block3: {
                CapabilityItem cap;
                block4: {
                    if (event.getEntityPlayer() == null || (cap = (CapabilityItem)event.getItemStack().getCapability(ModCapabilities.CAPABILITY_ITEM, null).orElse(null)) == null) break block3;
                    if (!ClientEngine.INSTANCE.inputController.isKeyDown(KeyBindings.SPECIAL_ATTACK_TOOLTIP)) break block4;
                    if (cap.getSpecialAttack(ItemStack.field_190927_a) == null) break block3;
                    event.getToolTip().clear();
                    for (ITextComponent s : cap.getSpecialAttack(Minecraft.func_71410_x().field_71439_g.func_184592_cb()).getTooltip()) {
                        event.getToolTip().add(s);
                    }
                    break block3;
                }
                List tooltip = event.getToolTip();
                cap.modifyItemTooltip(event.getToolTip(), event.getEntityPlayer().func_184592_cb().func_190926_b());
                for (int i = 0; i < tooltip.size(); ++i) {
                    if (!((ITextComponent)tooltip.get(i)).getString().contains("Attack Speed")) continue;
                    ClientPlayerData entityCap = (ClientPlayerData)event.getPlayer().getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
                    float weaponSpeed = (float)((ClientPlayerEntity)entityCap.getOriginalEntity()).func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f).func_111125_b();
                    for (AttributeModifier modifier : event.getItemStack().func_111283_C(EquipmentSlotType.MAINHAND).get((Object)SharedMonsterAttributes.field_188790_f.func_111108_a())) {
                        weaponSpeed += (float)modifier.func_111164_d();
                    }
                    float attackSpeedPanelty = weaponSpeed * entityCap.getWeightPaneltyMultiplier() * 0.1f;
                    tooltip.remove(i);
                    tooltip.add(i, new StringTextComponent(String.format(" %.1f Attack Speed", Float.valueOf(weaponSpeed -= attackSpeedPanelty))));
                }
            }
        }

        @SubscribeEvent
        public static void cameraSetupEvent(EntityViewRenderEvent.CameraSetup event) {
            renderEngine.renderPartialTick = (float)event.getRenderPartialTicks();
            Events.renderEngine.updateCameraInfo(event.getInfo(), Minecraft.func_71410_x().field_71474_y.field_74320_O, renderEngine.renderPartialTick);
            if (renderEngine.zoomCount > 0) {
                if (renderEngine.zoomOutTimer > 0) {
                    renderEngine.zoomOutTimer--;
                } else {
                    renderEngine.zoomCount = renderEngine.aiming ? renderEngine.zoomCount + 1 : renderEngine.zoomCount - 1;
                }
                renderEngine.zoomCount = Math.min(renderEngine.zoomMaxCount, renderEngine.zoomCount);
            }
        }

        @SubscribeEvent
        public static void drawAimHelper(RenderWorldLastEvent event) {
            if (renderEngine.zoomCount > 0 && ((RenderEngine)Events.renderEngine).minecraft.field_71474_y.field_74320_O == 1) {
                Events.renderEngine.aimHelper.doRender();
            }
        }

        @SubscribeEvent
        public static void fogEvent(EntityViewRenderEvent.RenderFogEvent event) {
        }

        @SubscribeEvent
        public static void renderGameOverlay(RenderGameOverlayEvent event) {
            ClientPlayerData playerdata;
            if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR && (playerdata = ClientEngine.INSTANCE.playerdata) != null && Minecraft.func_71382_s()) {
                Events.renderEngine.guiSkillBar.renderGui(playerdata);
            }
        }

        @SubscribeEvent
        public static void renderWorldLast(RenderWorldLastEvent event) {
        }
    }
}

