/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import maninhouse.epicfight.client.gui.EntityIndicator;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BrawlerIndicator
extends EntityIndicator {
    private static final ResourceLocation TARGET_INDICATOR = new ResourceLocation("epicfight", "textures/gui/indicator/brawler_indicator1.png");
    private static final ResourceLocation SKILL2_PASSIVE_INDICATOR = new ResourceLocation("epicfight", "textures/gui/indicator/brawler_indicator2.png");
    private static final ResourceLocation TEXTURE1 = new ResourceLocation("epicfight", "textures/gui/indicator/begin_a_game.png");
    private static final ResourceLocation TEXTURE2 = new ResourceLocation("epicfight", "textures/gui/skills/begin_a_game.png");
    private boolean hasEffect = false;
    private Vec3d pos;
    private int level = 0;
    private float scaler = 0.75f;
    private float t = 0.0f;

    public void render(LivingEntity currentStackEntity, LivingEntity target, float partialTicks) {
        if (target != null) {
            GlStateManager.pushMatrix();
            GlStateManager.loadIdentity();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TARGET_INDICATOR);
            this.setupMatrix(target, 0.0f, 0.02f, 0.0f, false, false);
            this.drawTexturedModalRect3DPlane(-0.5, 0.0, -0.5, 0.5, 0.0, 0.5, 0.0, 0.0, 228.0, 228.0);
            this.setupMatrix(target, 0.0f, target.func_213302_cg() + 0.5f, 0.0f, true, false);
            this.drawTexturedModalRect3DPlane(-0.15, -0.1, 0.0, 0.15, 0.1, 0.0, 2.0, 230.0, 26.0, 250.0);
            GlStateManager.popMatrix();
        }
        if (currentStackEntity != null) {
            GlStateManager.pushMatrix();
            GlStateManager.loadIdentity();
            GlStateManager.disableDepthTest();
            if (this.level == 1) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE1);
            } else if (this.level == 2) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE2);
            }
            this.setupMatrix(currentStackEntity, 0.0f, currentStackEntity.func_213302_cg() * 0.5f, 0.0f, true, false);
            GlStateManager.scalef((float)this.scaler, (float)this.scaler, (float)this.scaler);
            this.drawTexturedModalRect3DPlane(-0.35, -0.35, 0.0, 0.35, 0.35, 0.0, 0.0, 0.0, 228.0, 228.0);
            GlStateManager.popMatrix();
            if (this.t < 3.0f) {
                this.updateTimer(partialTicks);
            }
        }
        if (this.hasEffect) {
            GlStateManager.pushMatrix();
            GlStateManager.loadIdentity();
            GlStateManager.disableDepthTest();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(SKILL2_PASSIVE_INDICATOR);
            GlStateManager.scalef((float)this.scaler, (float)this.scaler, (float)this.scaler);
            int index = (int)(this.t * 2.0f);
            index = Math.min(index, 3);
            int width = index % 2;
            int height = index / 2;
            this.setupMatrix((float)this.pos.func_82615_a(), (float)this.pos.func_82617_b(), (float)this.pos.func_82616_c(), true, false);
            GlStateManager.scalef((float)this.scaler, (float)this.scaler, (float)this.scaler);
            this.drawTexturedModalRect2DPlane(-0.35, -0.35, 0.35, 0.35, (float)width * 128.0f, (float)height * 128.0f, (float)(width + 1) * 128.0f, (float)(height + 1) * 128.0f);
            if (this.t < 2.0f) {
                this.updateTimer(partialTicks);
            } else {
                this.hasEffect = false;
                this.pos = null;
            }
            GlStateManager.popMatrix();
        }
    }

    public void stackup(int stack, LivingEntity target) {
        this.level = stack;
        this.t = 0.0f;
        if (stack == 1) {
            this.scaler = 0.75f;
        } else if (stack == 0) {
            this.hasEffect = true;
            this.pos = target.func_213303_ch().func_72441_c(0.0, (double)(target.func_213302_cg() * 0.5f), 0.0);
        }
    }

    private void updateTimer(float partialTicks) {
        this.t += 0.1f;
        this.scaler += -0.025f * this.t + 0.05f;
    }
}

