/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.FloatBuffer;
import maninhouse.epicfight.client.ClientEngine;
import maninhouse.epicfight.client.gui.ModIngameGui;
import maninhouse.epicfight.utils.math.Mat4f;
import maninhouse.epicfight.utils.math.Vec3f;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.BufferUtils;

@OnlyIn(value=Dist.CLIENT)
public class EntityIndicator
extends ModIngameGui {
    protected final FloatBuffer MATRIXBUFFER = BufferUtils.createFloatBuffer((int)16);

    public void setupMatrix(LivingEntity entityIn, float correctionX, float correctionY, float correctionZ, boolean lockRotation, boolean setupProjection) {
        float partialTicks = ClientEngine.INSTANCE.renderEngine.getPartialTicks();
        float posX = (float)(entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks) + correctionX;
        float posY = (float)(entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks) + correctionY;
        float posZ = (float)(entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks) + correctionZ;
        this.setupMatrix(posX, posY, posZ, lockRotation, setupProjection);
    }

    public void setupMatrix(float posX, float posY, float posZ, boolean lockRotation, boolean setupProjection) {
        Mat4f viewMatrix = ClientEngine.INSTANCE.renderEngine.getViewMatrix();
        Mat4f finalMatrix = new Mat4f();
        finalMatrix.translate(new Vec3f(-posX, posY, -posZ));
        if (lockRotation) {
            finalMatrix.m00 = viewMatrix.m00;
            finalMatrix.m01 = viewMatrix.m10;
            finalMatrix.m02 = viewMatrix.m20;
            finalMatrix.m10 = viewMatrix.m01;
            finalMatrix.m11 = viewMatrix.m11;
            finalMatrix.m12 = viewMatrix.m21;
            finalMatrix.m20 = viewMatrix.m02;
            finalMatrix.m21 = viewMatrix.m12;
            finalMatrix.m22 = viewMatrix.m22;
        }
        Mat4f.mul(viewMatrix, finalMatrix, finalMatrix);
        if (setupProjection) {
            Mat4f.mul(ClientEngine.INSTANCE.renderEngine.getCurrentProjectionMatrix(), finalMatrix, finalMatrix);
        }
        finalMatrix.store(this.MATRIXBUFFER);
        this.MATRIXBUFFER.flip();
        GlStateManager.loadIdentity();
        GlStateManager.multMatrix((FloatBuffer)this.MATRIXBUFFER);
    }
}

