/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collection;
import java.util.Iterator;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.CapabilityEntity;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.client.gui.EntityIndicator;
import maninhouse.epicfight.effects.ModEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HealthBarIndicator
extends EntityIndicator {
    public void renderMobHealthBar(LivingEntity entityIn) {
        boolean hasActivePotion;
        if (!entityIn.func_184222_aU() || entityIn.func_82150_aj() || entityIn == Minecraft.func_71410_x().field_71439_g.func_184187_bx()) {
            return;
        }
        if (entityIn.func_70068_e(Minecraft.func_71410_x().func_175606_aa()) >= 400.0) {
            return;
        }
        if (entityIn instanceof PlayerEntity) {
            PlayerEntity playerIn = (PlayerEntity)entityIn;
            if (playerIn == Minecraft.func_71410_x().field_71439_g) {
                return;
            }
            if (playerIn.func_184812_l_() || playerIn.func_175149_v()) {
                return;
            }
        }
        float ratio = entityIn.func_110143_aJ() / entityIn.func_110138_aP();
        boolean bl = hasActivePotion = !entityIn.func_70651_bq().isEmpty();
        if (!hasActivePotion && ratio >= 1.0f || entityIn.field_70725_aQ >= 19) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.disableLighting();
        super.setupMatrix(entityIn, 0.0f, entityIn.func_213302_cg() + 0.25f, 0.0f, true, false);
        if (hasActivePotion) {
            Collection activeEffects = entityIn.func_70651_bq();
            Iterator iter = activeEffects.iterator();
            int acives = activeEffects.size();
            int row = acives > 1 ? 1 : 0;
            int column = (acives - 1) / 2;
            double startX = -0.8 + -0.3 * (double)row;
            double startY = -0.15 + 0.15 * (double)column;
            block0: for (int i = 0; i <= column; ++i) {
                for (int j = 0; j <= row; ++j) {
                    Effect effect = ((EffectInstance)iter.next()).func_188419_a();
                    ResourceLocation rl = effect instanceof ModEffect ? ((ModEffect)effect).getIcon() : new ResourceLocation("textures/mob_effect/" + Registry.field_212631_t.func_177774_c((Object)effect).func_110623_a() + ".png");
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(rl);
                    double x = startX + 0.3 * (double)j;
                    double y = startY + -0.3 * (double)i;
                    this.drawTexturedModalRect2DPlane(x, y, x + 0.3, y + 0.3, 0.0, 0.0, 256.0, 256.0);
                    if (!iter.hasNext()) continue block0;
                }
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BATTLE_ICON);
        float healthRatio = -0.5f + ratio;
        int textureRatio = (int)(62.0f * ratio);
        this.drawTexturedModalRect2DPlane(-0.5, -0.05, healthRatio, 0.05, 1.0, 15.0, textureRatio, 20.0);
        this.drawTexturedModalRect2DPlane(healthRatio, -0.05, 0.5, 0.05, textureRatio, 10.0, 62.0, 15.0);
        CapabilityEntity entitycap = (CapabilityEntity)entityIn.getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (entitycap != null && entitycap instanceof LivingData) {
            this.renderStunArmor((LivingData)entitycap);
        }
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
    }

    public void renderStunArmor(LivingData<?> entitydataFighter) {
        if (entitydataFighter.getStunResistance() == 0.0f) {
            return;
        }
        float ratio = entitydataFighter.getStunResistance() / entitydataFighter.getMaxStunResistance();
        float barRatio = -0.5f + ratio;
        int textureRatio = (int)(62.0f * ratio);
        this.drawTexturedModalRect2DPlane(-0.5, -0.1, barRatio, -0.05, 1.0, 5.0, textureRatio, 10.0);
        this.drawTexturedModalRect2DPlane(barRatio, -0.1, 0.5, -0.05, textureRatio, 0.0, 63.0, 5.0);
    }
}

