/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.Map;
import maninhouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninhouse.epicfight.client.gui.ModIngameGui;
import maninhouse.epicfight.skill.SkillContainer;
import maninhouse.epicfight.skill.SkillSlot;
import maninhouse.epicfight.utils.math.Vec2f;
import maninhouse.epicfight.utils.math.Vec3f;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkillBarGui
extends ModIngameGui {
    private final Map<SkillSlot, Vec3f> screenPositionMap = new HashMap<SkillSlot, Vec3f>();
    private int guiSlider = 29;
    private boolean guiSliderToggle = false;
    protected FontRenderer font;
    private static final Vec2f[] vectorz = new Vec2f[]{new Vec2f(0.5f, 0.5f), new Vec2f(0.5f, 0.0f), new Vec2f(0.0f, 0.0f), new Vec2f(0.0f, 1.0f), new Vec2f(1.0f, 1.0f), new Vec2f(1.0f, 0.0f)};

    public SkillBarGui() {
        this.screenPositionMap.put(SkillSlot.DODGE, new Vec3f(74.0f, 36.0f, 0.078f));
        this.screenPositionMap.put(SkillSlot.WEAPON_SPECIAL_ATTACK, new Vec3f(42.0f, 48.0f, 0.117f));
        this.font = Minecraft.func_71410_x().field_71466_p;
    }

    public void renderGui(ClientPlayerData playerdata) {
        if (((ClientPlayerEntity)playerdata.getOriginalEntity()).func_184187_bx() != null) {
            return;
        }
        if (this.guiSlider > 28) {
            return;
        }
        if (this.guiSlider > 0) {
            this.guiSlider = this.guiSliderToggle ? --this.guiSlider : ++this.guiSlider;
        }
        MainWindow sr = Minecraft.func_71410_x().field_195558_d;
        int width = sr.func_198107_o();
        int height = sr.func_198087_p();
        GlStateManager.enableBlend();
        for (int i = 0; i < SkillSlot.values().length; ++i) {
            SkillContainer container = playerdata.getSkill(i);
            if (container == null || container.isEmpty() || !this.screenPositionMap.containsKey((Object)container.getContaining().getSlot())) continue;
            SkillSlot slot = container.getContaining().getSlot();
            boolean creative = ((ClientPlayerEntity)playerdata.getOriginalEntity()).func_184812_l_();
            float cooldownRatio = creative ? 1.0f : container.getCooldownRatio();
            float durationRatio = container.getDurationRatio();
            boolean isReady = container.getStack() > 0 || durationRatio > 0.0f || creative;
            boolean fullstack = container.getStack() >= container.getContaining().getMaxStack();
            int x = (int)this.screenPositionMap.get((Object)((Object)slot)).x;
            int y = (int)this.screenPositionMap.get((Object)((Object)slot)).y;
            float scale = this.screenPositionMap.get((Object)((Object)slot)).z;
            float multiplyScale = 1.0f / scale;
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)scale, (float)scale, (float)1.0f);
            GlStateManager.translatef((float)0.0f, (float)((float)this.guiSlider * multiplyScale), (float)0.0f);
            if (!isReady) {
                GlStateManager.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)0.8f);
            } else {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (slot != SkillSlot.WEAPON_SPECIAL_ATTACK) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(container.getContaining().getTextureLocation());
                this.drawTexturedModalRectFixCoord((float)(width - x) * multiplyScale, (float)(height - y) * multiplyScale, 0, 0, 255, 255);
                if (!fullstack && !creative) {
                    GlStateManager.scalef((float)multiplyScale, (float)multiplyScale, (float)1.0f);
                    this.font.func_175063_a(String.valueOf((int)(1.0f + container.getCooldownSec() * Math.max(1.0f / container.getContaining().getRegenTimePerTick(playerdata), 1.0f))), (float)width - (float)x + 8.0f, (float)height - (float)y + 8.0f, 0xFFFFFF);
                }
            } else {
                int j;
                int vertexNum = 0;
                float iconSize = 32.0f;
                float iconSizeDiv = iconSize * 0.5f;
                float top = y;
                float bottom = (float)y - iconSize;
                float left = x;
                float right = (float)x - iconSize;
                float middle = (float)x - iconSizeDiv;
                float lastVertexX = 0.0f;
                float lastVertexY = 0.0f;
                float lastTexX = 0.0f;
                float lastTexY = 0.0f;
                if (cooldownRatio < 0.125f) {
                    vertexNum = 6;
                    lastTexX = cooldownRatio / 0.25f;
                    lastTexY = 0.0f;
                    lastVertexX = middle - iconSize * lastTexX;
                    lastVertexY = top;
                    lastTexX += 0.5f;
                } else if (cooldownRatio < 0.375f) {
                    vertexNum = 5;
                    lastTexX = 1.0f;
                    lastTexY = (cooldownRatio - 0.125f) / 0.25f;
                    lastVertexX = right;
                    lastVertexY = top - iconSize * lastTexY;
                } else if (cooldownRatio < 0.625f) {
                    vertexNum = 4;
                    lastTexX = (cooldownRatio - 0.375f) / 0.25f;
                    lastTexY = 1.0f;
                    lastVertexX = right + iconSize * lastTexX;
                    lastVertexY = bottom;
                    lastTexX = 1.0f - lastTexX;
                } else if (cooldownRatio < 0.875f) {
                    vertexNum = 3;
                    lastTexX = 0.0f;
                    lastTexY = (cooldownRatio - 0.625f) / 0.25f;
                    lastVertexX = left;
                    lastVertexY = bottom + iconSize * lastTexY;
                    lastTexY = 1.0f - lastTexY;
                } else {
                    vertexNum = 2;
                    lastTexX = (cooldownRatio - 0.875f) / 0.25f;
                    lastTexY = 0.0f;
                    lastVertexX = left - iconSize * lastTexX;
                    lastVertexY = top;
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(container.getContaining().getTextureLocation());
                GlStateManager.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)0.6f);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(9, DefaultVertexFormats.field_181707_g);
                for (j = 0; j < vertexNum; ++j) {
                    bufferbuilder.func_181662_b((double)(((float)width - (left - iconSize * SkillBarGui.vectorz[j].x)) * multiplyScale), (double)(((float)height - (top - iconSize * SkillBarGui.vectorz[j].y)) * multiplyScale), 0.0).func_187315_a((double)SkillBarGui.vectorz[j].x, (double)SkillBarGui.vectorz[j].y).func_181675_d();
                }
                bufferbuilder.func_181662_b((double)(((float)width - lastVertexX) * multiplyScale), (double)(((float)height - lastVertexY) * multiplyScale), 0.0).func_187315_a((double)lastTexX, (double)lastTexY).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.disableCull();
                bufferbuilder.func_181668_a(9, DefaultVertexFormats.field_181707_g);
                for (j = 0; j < 2; ++j) {
                    bufferbuilder.func_181662_b((double)(((float)width - (left - iconSize * SkillBarGui.vectorz[j].x)) * multiplyScale), (double)(((float)height - (top - iconSize * SkillBarGui.vectorz[j].y)) * multiplyScale), 0.0).func_187315_a((double)SkillBarGui.vectorz[j].x, (double)SkillBarGui.vectorz[j].y).func_181675_d();
                }
                for (j = vectorz.length - 1; j >= vertexNum; --j) {
                    bufferbuilder.func_181662_b((double)(((float)width - (left - iconSize * SkillBarGui.vectorz[j].x)) * multiplyScale), (double)(((float)height - (top - iconSize * SkillBarGui.vectorz[j].y)) * multiplyScale), 0.0).func_187315_a((double)SkillBarGui.vectorz[j].x, (double)SkillBarGui.vectorz[j].y).func_181675_d();
                }
                bufferbuilder.func_181662_b((double)(((float)width - lastVertexX) * multiplyScale), (double)(((float)height - lastVertexY) * multiplyScale), 0.0).func_187315_a((double)lastTexX, (double)lastTexY).func_181675_d();
                tessellator.func_78381_a();
                if (!isReady) {
                    GlStateManager.scalef((float)multiplyScale, (float)multiplyScale, (float)1.0f);
                    String s = String.valueOf((int)(cooldownRatio * 100.0f));
                    int stringWidth = (this.font.func_78256_a(s) - 6) / 3;
                    this.font.func_175063_a(s, (float)width - (float)x + 13.0f - (float)stringWidth, (float)height - (float)y + 13.0f, 0xFFFFFF);
                }
            }
            GlStateManager.popMatrix();
        }
    }

    public void slideUp() {
        this.guiSlider = 28;
        this.guiSliderToggle = true;
    }

    public void slideDown() {
        this.guiSlider = 1;
        this.guiSliderToggle = false;
    }
}

