/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.particle;

import java.util.List;
import java.util.Random;
import maninhouse.epicfight.client.ClientEngine;
import maninhouse.epicfight.client.particle.HitParticle;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public abstract class AnimatedMeshParticle
extends Particle {
    protected IBakedModel mesh;
    protected float rotationX;
    protected float rotationY;
    protected float rotationZ;
    protected float prevScale;
    protected float scale;

    protected AnimatedMeshParticle(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, IBakedModel mesh) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
        this.field_70547_e = 60;
        this.mesh = mesh;
        this.prevScale = 1.0f;
        this.scale = 1.0f;
    }

    public void func_180434_a(BufferBuilder buffer, ActiveRenderInfo entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        List quads = this.mesh.getQuads(null, null, new Random(), (IModelData)EmptyModelData.INSTANCE);
        float f5 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - field_70556_an);
        float f6 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g) - field_70554_ao);
        float f7 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - field_70555_ap);
        float sin = (float)Math.sin((double)(-this.rotationY) * Math.PI / 180.0);
        float cos = (float)Math.cos((double)(-this.rotationY) * Math.PI / 180.0);
        int i = this.func_189214_a(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        int jj = quads.size();
        for (int ii = 0; ii < jj; ++ii) {
            BakedQuad bakedquad = (BakedQuad)quads.get(ii);
            int[] vertexData = bakedquad.func_178209_a();
            for (int a = 0; a < 4; ++a) {
                float x = Float.intBitsToFloat(vertexData[0 + 7 * a]);
                float y = Float.intBitsToFloat(vertexData[1 + 7 * a]);
                float z = Float.intBitsToFloat(vertexData[2 + 7 * a]);
                float u = Float.intBitsToFloat(vertexData[3 + 7 * a]);
                float v = Float.intBitsToFloat(vertexData[4 + 7 * a]);
                float scale = this.prevScale + (this.scale - this.prevScale) * ClientEngine.INSTANCE.renderEngine.getPartialTicks();
                buffer.func_181662_b((double)(f5 + (x * cos + z * sin) * scale), (double)(f6 + y * scale), (double)(f7 + (-x * sin + z * cos) * scale)).func_187315_a((double)u, (double)v).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
            }
        }
    }

    public IParticleRenderType func_217558_b() {
        return HitParticle.HIT_PARTICLE_TYPE;
    }
}

