/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.particle;

import maninhouse.epicfight.animation.Joint;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.client.ClientEngine;
import maninhouse.epicfight.client.particle.HitParticle;
import maninhouse.epicfight.utils.math.Mat4f;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HierarchicalParticle
extends SpriteTexturedParticle {
    private LivingData<?> entitydata;
    private int jointKey;

    protected HierarchicalParticle(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.0, 0.0, 0.0);
        Entity e = worldIn.func_73045_a((int)Double.doubleToLongBits(xSpeedIn));
        this.entitydata = (LivingData)e.getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        this.jointKey = (int)Double.doubleToLongBits(ySpeedIn);
        this.entitydata.hierarchicalParticles.add(this);
    }

    public void func_189213_a() {
        if (this.field_187133_m) {
            this.entitydata.hierarchicalParticles.remove((Object)this);
            this.entitydata = null;
        }
    }

    public void func_180434_a(BufferBuilder buffer, ActiveRenderInfo entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        this.entitydata.getClientAnimator().setPoseToModel();
        Joint joint = this.entitydata.getEntityModel().getArmature().findJointById(this.jointKey);
        Mat4f jointTransform = Mat4f.mul(joint.getAnimatedTransform(), this.entitydata.getModelMatrix(ClientEngine.INSTANCE.renderEngine.getPartialTicks()), null);
        this.field_187126_f = jointTransform.m30;
        this.field_187127_g = jointTransform.m31;
        this.field_187128_h = jointTransform.m32;
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        super.func_180434_a(buffer, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
    }

    public IParticleRenderType func_217558_b() {
        return HitParticle.HIT_PARTICLE_TYPE;
    }
}

