/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.renderer.debug;

import maninhouse.epicfight.client.opengl.VertexArrayObject;
import maninhouse.epicfight.client.renderer.ShaderRenderer;
import maninhouse.epicfight.client.shader.FigureShader;
import maninhouse.epicfight.client.shader.Shaders;
import maninhouse.epicfight.physics.ColliderLine;
import maninhouse.epicfight.utils.math.Vec4f;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class RenderLine
extends ShaderRenderer<FigureShader> {
    protected static final int[] CUBE_VERTEX_INDEX = new int[]{0, 1};
    protected final VertexArrayObject vao;

    public RenderLine(IResourceManager resourceManager) {
        super(null);
        this.shader = Shaders.FIGURE_SHADER;
        this.vao = new VertexArrayObject();
        this.vao.bufferDataFloat(0, 3, BufferUtils.createFloatBuffer((int)0));
        this.vao.bufferDataElement(CUBE_VERTEX_INDEX);
    }

    public void doRender(ColliderLine obb) {
        this.vao.modifyBufferData(0, 3, obb.getVertexBuffer());
        ((FigureShader)this.shader).start();
        ((FigureShader)this.shader).loadUniforms(renderEngine.getViewMatrix(), renderEngine.getCurrentProjectionMatrix(), new Vec4f(1.0f, 1.0f, 1.0f, 1.0f));
        this.vao.bindVao();
        GL11.glDrawElements((int)1, (int)CUBE_VERTEX_INDEX.length, (int)5125, (long)0L);
        this.vao.unbindVao();
        ((FigureShader)this.shader).stop();
    }
}

