/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.renderer.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.FloatBuffer;
import maninhouse.epicfight.animation.AnimationPlayer;
import maninhouse.epicfight.animation.Joint;
import maninhouse.epicfight.animation.types.attack.AttackAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.client.model.Mesh;
import maninhouse.epicfight.client.renderer.ShaderRenderer;
import maninhouse.epicfight.client.shader.ArmatureShader;
import maninhouse.epicfight.model.Armature;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.physics.ColliderOBB;
import maninhouse.epicfight.utils.math.Mat4f;
import maninhouse.epicfight.utils.math.Vec2i;
import maninhouse.epicfight.utils.math.Vec3f;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public abstract class RenderArmatureEntity<T extends LivingData<?>>
extends ShaderRenderer<ArmatureShader> {
    public RenderArmatureEntity(IResourceManager resourceManager, ResourceLocation textureLocation) {
        super(textureLocation);
    }

    public void doRender(T entitydata) {
        this.renderModel(entitydata);
    }

    public void renderModel(T entitydata) {
        AnimatorClient animator;
        AnimationPlayer player;
        Object entity = ((LivingData)entitydata).getOriginalEntity();
        Model entityModel = ((LivingData)entitydata).getEntityModel();
        Armature armature = entityModel.getArmature();
        armature.initializeTransform();
        this.transformJoints(entitydata, armature);
        ((LivingData)entitydata).getClientAnimator().setPoseToModel();
        Mat4f modelMatrix = this.getModelMatrix(entitydata);
        FloatBuffer fogColor = BufferUtils.createFloatBuffer((int)16);
        int fogMode = this.getFogFactor(fogColor);
        Vec2i light = this.getLightColor((Entity)entity);
        Object[] uniforms = new Object[]{modelMatrix, renderEngine.getViewMatrix(), renderEngine.getCurrentProjectionMatrix(), renderEngine.getTotalLight(light.x, light.y), armature.getJointTransforms(), new Vec3f(fogColor.get(0), fogColor.get(1), fogColor.get(2)), Float.valueOf(GL11.glGetFloat((int)2915)), Float.valueOf(GL11.glGetFloat((int)2916)), Float.valueOf(GL11.glGetFloat((int)2914)), fogMode};
        if (!((LivingData)entitydata).getOriginalEntity().func_82150_aj()) {
            this.draw(entitydata, uniforms);
        }
        this.renderLayer(entitydata, uniforms);
        this.renderItemCurrentSlot(entitydata, modelMatrix);
        if (Minecraft.func_71410_x().func_175598_ae().func_178634_b() && (player = (animator = ((LivingData)entitydata).getClientAnimator()).getPlayer()).getPlay() instanceof AttackAnimation) {
            AttackAnimation attackAnimation = (AttackAnimation)player.getPlay();
            Mat4f mat = new Mat4f();
            if (((LivingData)entitydata).getEntityState() == LivingData.EntityState.CONTACT) {
                float elapsedTime = player.getElapsedTime();
                int index = attackAnimation.getIndexer(elapsedTime);
                Collider collider = attackAnimation.getCollider((LivingData<?>)entitydata, elapsedTime);
                if (index > 0) {
                    Joint joint = armature.getJointHierarcy();
                    while (index >> 5 != 0) {
                        joint = joint.getSubJoints().get(((index >>= 5) & 0x1F) - 1);
                    }
                    mat = joint.getAnimatedTransform();
                }
                collider.transform(Mat4f.mul(modelMatrix, mat, null));
                RenderArmatureEntity.renderEngine.obb.doRender((ColliderOBB)collider);
            }
        }
        GlStateManager.enableCull();
    }

    protected int getFogFactor(FloatBuffer colorBuffer) {
        GL11.glGetFloatv((int)2918, (FloatBuffer)colorBuffer);
        int fogMode = GL11.glGetInteger((int)2917) - 2047;
        if (fogMode > 1000) {
            fogMode = 0;
        }
        return fogMode;
    }

    protected Vec2i getLightColor(Entity entity) {
        int i = entity.func_70027_ad() ? 0xF000F0 : entity.func_70070_b();
        return new Vec2i(i % 65536 / 16, i / 0x100000);
    }

    protected void draw(T entitydata, Object[] shaderUniforms) {
        Mesh mesh = ((LivingData)entitydata).getEntityModel().getMesh();
        ((ArmatureShader)this.shader).start();
        ((ArmatureShader)this.shader).loadUniforms(shaderUniforms);
        GlStateManager.disableCull();
        RenderArmatureEntity.bindTexture(this.getEntityTexture(entitydata));
        mesh.getVao().bindVao();
        GL11.glDrawElements((int)4, (int)mesh.getVertexNumber(), (int)5125, (long)0L);
        mesh.getVao().unbindVao();
        ((ArmatureShader)this.shader).stop();
    }

    protected Mat4f getModelMatrix(T entitydata) {
        return ((LivingData)entitydata).getModelMatrix(renderEngine.getPartialTicks());
    }

    protected void transformJoint(int jointId, Armature modelArmature, Mat4f mat) {
        Joint joint = modelArmature.findJointById(jointId);
        Mat4f.mul(joint.getAnimatedTransform(), mat, joint.getAnimatedTransform());
    }

    protected void renderItemCurrentSlot(T entitydata, Mat4f modelMatrix) {
    }

    protected ResourceLocation getEntityTexture(T entitydata) {
        return super.getTexture();
    }

    protected abstract void transformJoints(T var1, Armature var2);

    protected abstract void renderLayer(T var1, Object[] var2);

    @Override
    public void clearRenderer() {
        ((ArmatureShader)this.shader).clearShader();
    }
}

