/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.renderer.entity;

import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.client.renderer.entity.RenderArmatureEntity;
import maninhouse.epicfight.client.shader.Shaders;
import maninhouse.epicfight.model.Armature;
import maninhouse.epicfight.utils.math.Mat4f;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderBiped<T extends LivingData<?>>
extends RenderArmatureEntity<T> {
    public RenderBiped(IResourceManager resourceManager, ResourceLocation textureLocation) {
        super(resourceManager, textureLocation);
        this.shader = Shaders.BASIC_ARMATURE_SHADER;
    }

    @Override
    protected void renderItemCurrentSlot(T entitydata, Mat4f modelMat) {
        ItemStack offHandStack;
        ItemStack mainHandStack = ((LivingData)entitydata).getOriginalEntity().func_184614_ca();
        if (mainHandStack.func_77973_b() != Items.field_190931_a) {
            CapabilityItem itemCap;
            if (((LivingData)entitydata).getOriginalEntity().func_184187_bx() != null && (itemCap = ((LivingData)entitydata).getHeldItemCapability(Hand.MAIN_HAND)) != null && !itemCap.canUseOnMount()) {
                renderEngine.getItemRenderer(mainHandStack.func_77973_b()).renderItemBack(mainHandStack, modelMat, (LivingData<?>)entitydata);
                return;
            }
            renderEngine.getItemRenderer(mainHandStack.func_77973_b()).renderItemInHand(mainHandStack, modelMat, (LivingData<?>)entitydata, Hand.MAIN_HAND);
        }
        if ((offHandStack = ((LivingData)entitydata).getOriginalEntity().func_184592_cb()).func_77973_b() != Items.field_190931_a) {
            CapabilityItem cap = ((LivingData)entitydata).getHeldItemCapability(Hand.MAIN_HAND);
            if (cap != null) {
                if (cap.canCompatibleWith(offHandStack)) {
                    renderEngine.getItemRenderer(offHandStack.func_77973_b()).renderItemInHand(offHandStack, modelMat, (LivingData<?>)entitydata, Hand.OFF_HAND);
                }
            } else {
                renderEngine.getItemRenderer(offHandStack.func_77973_b()).renderItemInHand(offHandStack, modelMat, (LivingData<?>)entitydata, Hand.OFF_HAND);
            }
        }
    }

    @Override
    protected void transformJoints(T entitydata, Armature modelArmature) {
        this.transformJoint(7, modelArmature, ((LivingData)entitydata).getHeadMatrix(renderEngine.getPartialTicks()));
    }

    @Override
    public void renderLayer(T entitydata, Object[] uniforms) {
        Object entity = ((LivingData)entitydata).getOriginalEntity();
        RenderBiped.renderEngine.layerRenderer.renderArmor((LivingData<?>)entitydata, entity.func_184582_a(EquipmentSlotType.HEAD), uniforms);
        RenderBiped.renderEngine.layerRenderer.renderArmor((LivingData<?>)entitydata, entity.func_184582_a(EquipmentSlotType.CHEST), uniforms);
        RenderBiped.renderEngine.layerRenderer.renderArmor((LivingData<?>)entitydata, entity.func_184582_a(EquipmentSlotType.LEGS), uniforms);
        RenderBiped.renderEngine.layerRenderer.renderArmor((LivingData<?>)entitydata, entity.func_184582_a(EquipmentSlotType.FEET), uniforms);
    }
}

