/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.renderer.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Random;
import maninhouse.epicfight.capabilities.entity.mob.EndermanData;
import maninhouse.epicfight.client.eventengine.RenderEngine;
import maninhouse.epicfight.client.model.Mesh;
import maninhouse.epicfight.client.renderer.entity.RenderBiped;
import maninhouse.epicfight.client.shader.ArmatureShader;
import maninhouse.epicfight.client.shader.Shaders;
import maninhouse.epicfight.model.Armature;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.utils.math.Mat4f;
import maninhouse.epicfight.utils.math.Vec3f;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderEndermanMod
extends RenderBiped<EndermanData> {
    private static final ResourceLocation eyetexture = new ResourceLocation("textures/entity/enderman/enderman_eyes.png");

    public RenderEndermanMod(IResourceManager resourceManager) {
        super(resourceManager, new ResourceLocation("textures/entity/enderman/enderman.png"));
        this.shader = Shaders.SHINING_EYE_SHADER;
    }

    @Override
    public void renderModel(EndermanData entitydata) {
        GlStateManager.activeTexture((int)33991);
        RenderBiped.bindTexture(eyetexture);
        GlStateManager.activeTexture((int)33984);
        super.renderModel(entitydata);
    }

    @Override
    public void renderLayer(EndermanData entitydata, Object[] uniforms) {
        if (((EndermanEntity)entitydata.getOriginalEntity()).func_82150_aj()) {
            GlStateManager.enableBlend();
            Model entityModel = entitydata.getEntityModel();
            Mesh mesh = entityModel.getMesh();
            RenderEndermanMod.bindTexture(RenderEngine.NULL_TEXTURE);
            ((ArmatureShader)this.shader).start();
            ((ArmatureShader)this.shader).loadUniforms(uniforms);
            GlStateManager.disableCull();
            mesh.getVao().bindVao();
            GL11.glDrawElements((int)4, (int)mesh.getVertexNumber(), (int)5125, (long)0L);
            mesh.getVao().unbindVao();
            ((ArmatureShader)this.shader).stop();
            GlStateManager.disableBlend();
        }
    }

    @Override
    protected void transformJoints(EndermanData entitydata, Armature modelArmature) {
        this.transformJoint(15, modelArmature, entitydata.getHeadMatrix(renderEngine.getPartialTicks()));
        if (entitydata.isRaging()) {
            Mat4f head = new Mat4f();
            Mat4f shaking = new Mat4f();
            Random rand = ((EndermanEntity)entitydata.getOriginalEntity()).func_70681_au();
            Mat4f.translate(new Vec3f(0.0f, 0.5f, 0.0f), head, head);
            Mat4f.translate(new Vec3f((float)rand.nextGaussian() * 0.02f, 0.0f, (float)rand.nextGaussian() * 0.02f), shaking, shaking);
            if (((EndermanEntity)entitydata.getOriginalEntity()).func_110143_aJ() <= 0.0f) {
                this.transformJoint(0, modelArmature, shaking);
                this.transformJoint(16, modelArmature, head);
            } else {
                Mat4f.add(shaking, head, head);
                this.transformJoint(16, modelArmature, head);
            }
        }
    }
}

