/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.renderer.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import maninhouse.epicfight.capabilities.entity.mob.SpiderData;
import maninhouse.epicfight.client.eventengine.RenderEngine;
import maninhouse.epicfight.client.model.Mesh;
import maninhouse.epicfight.client.renderer.entity.RenderArmatureEntity;
import maninhouse.epicfight.client.shader.ArmatureShader;
import maninhouse.epicfight.client.shader.Shaders;
import maninhouse.epicfight.model.Armature;
import maninhouse.epicfight.model.Model;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class RenderSpiderMod
extends RenderArmatureEntity<SpiderData> {
    private static final ResourceLocation eyetexture = new ResourceLocation("textures/entity/spider_eyes.png");

    public RenderSpiderMod(IResourceManager resourceManager) {
        super(resourceManager, new ResourceLocation("textures/entity/spider/spider.png"));
        this.shader = Shaders.SHINING_EYE_SHADER;
    }

    @Override
    public void renderModel(SpiderData entitydata) {
        GlStateManager.activeTexture((int)33991);
        RenderArmatureEntity.bindTexture(eyetexture);
        GlStateManager.activeTexture((int)33984);
        super.renderModel(entitydata);
    }

    @Override
    public void renderLayer(SpiderData entitydata, Object[] uniforms) {
        if (((SpiderEntity)entitydata.getOriginalEntity()).func_82150_aj()) {
            GlStateManager.enableBlend();
            Model entityModel = entitydata.getEntityModel();
            Mesh mesh = entityModel.getMesh();
            RenderSpiderMod.bindTexture(RenderEngine.NULL_TEXTURE);
            ((ArmatureShader)this.shader).start();
            ((ArmatureShader)this.shader).loadUniforms(uniforms);
            GlStateManager.disableCull();
            mesh.getVao().bindVao();
            GL11.glDrawElements((int)4, (int)mesh.getVertexNumber(), (int)5125, (long)0L);
            mesh.getVao().unbindVao();
            ((ArmatureShader)this.shader).stop();
            GlStateManager.disableBlend();
        }
    }

    @Override
    protected void transformJoints(SpiderData entitydata, Armature modelArmature) {
        this.transformJoint(1, modelArmature, entitydata.getHeadMatrix(renderEngine.getPartialTicks()));
    }
}

