/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.renderer.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import maninhouse.epicfight.capabilities.entity.mob.ZombieVillagerData;
import maninhouse.epicfight.client.model.Mesh;
import maninhouse.epicfight.client.renderer.entity.RenderBiped;
import maninhouse.epicfight.client.shader.ArmatureShader;
import maninhouse.epicfight.gamedata.Models;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.data.VillagerMetadataSection;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class RenderZombieVillagerMod
extends RenderBiped<ZombieVillagerData> {
    private final Object2ObjectMap<IVillagerType, VillagerMetadataSection.HatType> byType = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<VillagerProfession, VillagerMetadataSection.HatType> byProfession = new Object2ObjectOpenHashMap();
    private final IReloadableResourceManager rm = (IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G();

    public RenderZombieVillagerMod(IResourceManager resourceManager) {
        super(resourceManager, new ResourceLocation("textures/entity/zombie_villager/zombie_villager.png"));
    }

    @Override
    protected void draw(ZombieVillagerData entitydata, Object[] shaderUniforms) {
        Mesh mesh1 = entitydata.getEntityModel().getMesh();
        Mesh mesh2 = ((ZombieVillagerEntity)entitydata.getOriginalEntity()).func_70631_g_() ? Models.LOGICAL_CLIENT.ENTITY_BABY_VILLAGER_HEADLESS.getMesh() : Models.LOGICAL_CLIENT.ENTITY_VILLAGER_ZOMBIE_HEADLESS.getMesh();
        Mesh drawingMesh = mesh1;
        VillagerData villagerdata = ((IVillagerDataHolder)entitydata.getOriginalEntity()).func_213700_eh();
        ((ArmatureShader)this.shader).start();
        ((ArmatureShader)this.shader).loadUniforms(shaderUniforms);
        GlStateManager.disableCull();
        RenderZombieVillagerMod.bindTexture(this.getEntityTexture(entitydata));
        drawingMesh.getVao().bindVao();
        GL11.glDrawElements((int)4, (int)drawingMesh.getVertexNumber(), (int)5125, (long)0L);
        drawingMesh.getVao().unbindVao();
        VillagerMetadataSection.HatType typeHat = this.func_215350_a(this.byType, "type", Registry.field_218369_K, villagerdata.func_221129_a());
        VillagerMetadataSection.HatType professionHat = this.func_215350_a(this.byProfession, "profession", Registry.field_218370_L, villagerdata.func_221130_b());
        drawingMesh = professionHat == VillagerMetadataSection.HatType.NONE || professionHat == VillagerMetadataSection.HatType.PARTIAL && typeHat != VillagerMetadataSection.HatType.FULL ? mesh1 : mesh2;
        RenderZombieVillagerMod.bindTexture(this.getOutlayerTexture("type", Registry.field_218369_K.func_177774_c((Object)villagerdata.func_221129_a())));
        drawingMesh.getVao().bindVao();
        GL11.glDrawElements((int)4, (int)drawingMesh.getVertexNumber(), (int)5125, (long)0L);
        drawingMesh.getVao().unbindVao();
        Mesh mesh = drawingMesh = ((ZombieVillagerEntity)entitydata.getOriginalEntity()).func_184582_a(EquipmentSlotType.HEAD).func_190926_b() ? mesh1 : mesh2;
        if (villagerdata.func_221130_b() != VillagerProfession.field_221151_a) {
            RenderZombieVillagerMod.bindTexture(this.getOutlayerTexture("profession", Registry.field_218370_L.func_177774_c((Object)villagerdata.func_221130_b())));
            drawingMesh.getVao().bindVao();
            GL11.glDrawElements((int)4, (int)drawingMesh.getVertexNumber(), (int)5125, (long)0L);
            drawingMesh.getVao().unbindVao();
        }
        ((ArmatureShader)this.shader).stop();
    }

    protected <K> VillagerMetadataSection.HatType func_215350_a(Object2ObjectMap<K, VillagerMetadataSection.HatType> map, String p_215350_2_, DefaultedRegistry<K> p_215350_3_, K p_215350_4_) {
        return (VillagerMetadataSection.HatType)map.computeIfAbsent(p_215350_4_, p_215349_4_ -> {
            try (IResource iresource = this.rm.func_199002_a(this.getOutlayerTexture(p_215350_2_, p_215350_3_.func_177774_c(p_215350_4_)));){
                VillagerMetadataSection.HatType villagermetadatasection$hattype;
                VillagerMetadataSection villagermetadatasection = (VillagerMetadataSection)iresource.func_199028_a((IMetadataSectionSerializer)VillagerMetadataSection.field_217827_a);
                if (villagermetadatasection == null) return VillagerMetadataSection.HatType.NONE;
                VillagerMetadataSection.HatType hatType = villagermetadatasection$hattype = villagermetadatasection.func_217826_a();
                return hatType;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return VillagerMetadataSection.HatType.NONE;
        });
    }

    protected ResourceLocation getOutlayerTexture(String path, ResourceLocation rl) {
        return new ResourceLocation("textures/entity/zombie_villager/" + path + "/" + rl.func_110623_a() + ".png");
    }
}

