/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.renderer.item;

import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.FloatBuffer;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.client.eventengine.RenderEngine;
import maninhouse.epicfight.utils.math.Mat4f;
import maninhouse.epicfight.utils.math.Vec3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class RenderItemBase {
    protected Mat4f correctionMatrix = new Mat4f();
    protected static final Mat4f BACK_COORECTION = new Mat4f();
    public static RenderEngine renderEngine;

    public RenderItemBase() {
        Mat4f.rotate((float)Math.toRadians(-80.0), new Vec3f(1.0f, 0.0f, 0.0f), this.correctionMatrix, this.correctionMatrix);
        Mat4f.translate(new Vec3f(0.0f, 0.1f, 0.0f), this.correctionMatrix, this.correctionMatrix);
    }

    public void renderItemInHand(ItemStack stack, Mat4f holderModelMatrix, LivingData<?> itemHolder, Hand hand) {
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        Mat4f modelMatrix = this.getCorrectionMatrix(stack, itemHolder, hand);
        String heldingHand = hand == Hand.MAIN_HAND ? "Tool_R" : "Tool_L";
        Mat4f.mul(itemHolder.getEntityModel().getArmature().findJointByName(heldingHand).getAnimatedTransform(), modelMatrix, modelMatrix);
        Mat4f.mul(holderModelMatrix, modelMatrix, modelMatrix);
        Mat4f modelViewMatrix = Mat4f.mul(renderEngine.getViewMatrix(), modelMatrix, null);
        modelViewMatrix.store(buf);
        buf.flip();
        GL11.glLoadMatrixf((FloatBuffer)buf);
        Minecraft.func_71410_x().func_175599_af().func_184392_a(stack, itemHolder.getOriginalEntity(), ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, false);
        GlStateManager.popMatrix();
    }

    public void renderItemBack(ItemStack stack, Mat4f holderModelMatrix, LivingData<?> itemHolder) {
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        Mat4f modelMatrix = new Mat4f(BACK_COORECTION);
        Mat4f.mul(itemHolder.getEntityModel().getArmature().findJointById(0).getAnimatedTransform(), modelMatrix, modelMatrix);
        Mat4f.mul(holderModelMatrix, modelMatrix, modelMatrix);
        Mat4f modelViewMatrix = Mat4f.mul(renderEngine.getViewMatrix(), modelMatrix, null);
        modelViewMatrix.store(buf);
        buf.flip();
        GL11.glLoadMatrixf((FloatBuffer)buf);
        Minecraft.func_71410_x().func_175599_af().func_184392_a(stack, itemHolder.getOriginalEntity(), ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, false);
        GlStateManager.popMatrix();
    }

    public void renderItemOnHead(ItemStack stack, LivingData<?> itemHolder) {
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        Mat4f modelMatrix = new Mat4f();
        Mat4f.translate(new Vec3f(0.0f, 0.2f, 0.0f), modelMatrix, modelMatrix);
        Mat4f.mul(itemHolder.getEntityModel().getArmature().findJointById(7).getAnimatedTransform(), modelMatrix, modelMatrix);
        Mat4f.mul(itemHolder.getModelMatrix(renderEngine.getPartialTicks()), modelMatrix, modelMatrix);
        Mat4f.scale(new Vec3f(0.6f, 0.6f, 0.6f), modelMatrix, modelMatrix);
        Mat4f modelViewMatrix = Mat4f.mul(renderEngine.getViewMatrix(), modelMatrix, null);
        modelViewMatrix.store(buf);
        buf.flip();
        GL11.glLoadMatrixf((FloatBuffer)buf);
        Minecraft.func_71410_x().func_175597_ag().func_178099_a(itemHolder.getOriginalEntity(), stack, ItemCameraTransforms.TransformType.HEAD);
        GlStateManager.popMatrix();
    }

    public Mat4f getCorrectionMatrix(ItemStack stack, LivingData<?> itemHolder, Hand hand) {
        return new Mat4f(this.correctionMatrix);
    }

    static {
        Mat4f.translate(new Vec3f(0.5f, 1.0f, 0.1f), BACK_COORECTION, BACK_COORECTION);
        Mat4f.rotate((float)Math.toRadians(130.0), new Vec3f(0.0f, 0.0f, 1.0f), BACK_COORECTION, BACK_COORECTION);
        Mat4f.rotate((float)Math.toRadians(100.0), new Vec3f(0.0f, 1.0f, 0.0f), BACK_COORECTION, BACK_COORECTION);
    }
}

