/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.renderer.item;

import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.FloatBuffer;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.client.renderer.item.RenderItemBase;
import maninhouse.epicfight.utils.math.Mat4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public abstract class RenderItemMirror
extends RenderItemBase {
    protected Mat4f leftHandCorrectionMatrix;

    @Override
    public void renderItemInHand(ItemStack stack, Mat4f holderModelMatrix, LivingData<?> itemHolder, Hand hand) {
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        Mat4f modelMatrix = new Mat4f(hand == Hand.OFF_HAND ? this.leftHandCorrectionMatrix : this.correctionMatrix);
        String heldingHand = hand == Hand.MAIN_HAND ? "Tool_R" : "Tool_L";
        Mat4f.mul(itemHolder.getEntityModel().getArmature().findJointByName(heldingHand).getAnimatedTransform(), modelMatrix, modelMatrix);
        Mat4f.mul(holderModelMatrix, modelMatrix, modelMatrix);
        Mat4f modelViewMatrix = Mat4f.mul(renderEngine.getViewMatrix(), modelMatrix, null);
        modelViewMatrix.store(buf);
        buf.flip();
        GL11.glLoadMatrixf((FloatBuffer)buf);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        GlStateManager.popMatrix();
    }
}

