/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.renderer.layer;

import com.mojang.blaze3d.platform.GlStateManager;
import java.lang.reflect.Field;
import java.util.Map;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.entity.mob.ZombieVillagerData;
import maninhouse.epicfight.capabilities.item.ArmorCapability;
import maninhouse.epicfight.capabilities.item.VanillaArmorCapability;
import maninhouse.epicfight.client.ClientEngine;
import maninhouse.epicfight.client.model.Mesh;
import maninhouse.epicfight.client.renderer.ShaderRenderer;
import maninhouse.epicfight.client.shader.ArmorShader;
import maninhouse.epicfight.client.shader.Shaders;
import maninhouse.epicfight.item.ItemArmorExtend;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.utils.math.Mat4f;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.Vec4f;
import net.minecraft.client.renderer.entity.layers.ArmorLayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class LayerRenderer
extends ShaderRenderer<ArmorShader> {
    private static final Vec4f enchantmentAuraColor = new Vec4f(0.38f, 0.19f, 0.608f, 1.0f);
    private static Map<String, ResourceLocation> ARMOR_MAP;
    private static final ResourceLocation GLINT;

    public LayerRenderer() {
        super(null);
        this.shader = Shaders.BIPED_ARMOR_SHADER;
    }

    public void renderLayer(LivingData<?> entitydata, Model layerModel, ResourceLocation rl, Object[] uniforms) {
        MultiTexBinder[] binders = new MultiTexBinder[]{};
        this.renderLayer(entitydata, layerModel, 0, 0, rl, binders, uniforms);
    }

    public void renderLayer(LivingData<?> entitydata, Model layerModel, int overlay, int glint, ResourceLocation rl, MultiTexBinder[] binders, Object[] uniforms) {
        LayerRenderer.bindTexture(rl);
        for (MultiTexBinder binder : binders) {
            if (binder == null) continue;
            binder.doWork();
        }
        ((ArmorShader)this.shader).start();
        ((ArmorShader)this.shader).loadUniforms(overlay, glint, uniforms);
        Mesh mesh = layerModel.getMesh();
        mesh.getVao().bindVao();
        GL11.glDrawElements((int)4, (int)mesh.getVertexNumber(), (int)5125, (long)0L);
        mesh.getVao().unbindVao();
        ((ArmorShader)this.shader).stop();
        for (MultiTexBinder binder : binders) {
            if (binder == null) continue;
            binder.recover();
        }
    }

    public void renderArmor(LivingData<?> entitydata, ItemStack stack, Object[] uniforms) {
        Item item = stack.func_77973_b();
        if (item instanceof ArmorItem) {
            Object entityIn = entitydata.getOriginalEntity();
            ArmorItem armor = (ArmorItem)stack.func_77973_b();
            VanillaArmorCapability cap = (VanillaArmorCapability)stack.getCapability(ModCapabilities.CAPABILITY_ITEM, null).orElse(null);
            Model model = cap == null ? ArmorCapability.getBipedArmorModel(armor.func_185083_B_(), entityIn.func_70631_g_()) : cap.getEquipModel(armor.func_185083_B_(), entityIn.func_70631_g_());
            ResourceLocation textureLocation = this.getArmorTexture(stack, (Entity)entityIn, armor.func_185083_B_(), null);
            if (entitydata instanceof ZombieVillagerData) {
                Mat4f[] jointTransforms = (Mat4f[])uniforms[4];
                Mat4f headMatrix = new Mat4f();
                float y = entityIn.func_70631_g_() ? 0.08f : 0.11f;
                headMatrix.translate(new Vec3f(0.0f, y, 0.0f));
                Mat4f.mul(jointTransforms[7], headMatrix, jointTransforms[7]);
            }
            Object[] overlayUniforms = new Object[1];
            Object[] glintUniforms = new Object[3];
            MultiTexBinder texBinder1 = null;
            MultiTexBinder texBinder2 = null;
            int overlay = 0;
            int glint = 0;
            if (armor instanceof IDyeableArmorItem && !(item instanceof ItemArmorExtend)) {
                ResourceLocation overlayTexture = this.getArmorTexture(stack, (Entity)entityIn, armor.func_185083_B_(), "overlay");
                texBinder1 = new MultiTexBinder(33990, overlayTexture);
                overlayUniforms[0] = ClientEngine.INSTANCE.renderEngine.convertColorToVector(((IDyeableArmorItem)armor).func_200886_f(stack), true);
                overlay = 1;
            }
            if (stack.func_77962_s()) {
                texBinder2 = new MultiTexBinder(33991, GLINT);
                Mat4f texTransform1 = new Mat4f();
                Mat4f texTransform2 = new Mat4f();
                Mat4f.scale(new Vec3f(0.33333334f, 0.33333334f, 0.33333334f), texTransform1, texTransform1);
                Mat4f.rotate((float)Math.toRadians(30.0), new Vec3f(0.0f, 0.0f, 1.0f), texTransform1, texTransform1);
                Mat4f.translate(new Vec3f(0.0f, (float)((LivingEntity)entityIn).field_70173_aa * 0.001f * 20.0f, 0.0f), texTransform1, texTransform1);
                Mat4f.scale(new Vec3f(0.33333334f, 0.33333334f, 0.33333334f), texTransform2, texTransform2);
                Mat4f.rotate((float)Math.toRadians(-30.0), new Vec3f(0.0f, 0.0f, 1.0f), texTransform2, texTransform2);
                Mat4f.translate(new Vec3f(0.0f, (float)((LivingEntity)entityIn).field_70173_aa * 0.004f * 20.0f, 0.0f), texTransform2, texTransform2);
                glintUniforms[0] = enchantmentAuraColor;
                glintUniforms[1] = texTransform1;
                glintUniforms[2] = texTransform2;
                glint = 1;
            }
            Object[] uniformTotal = new Object[14];
            System.arraycopy(uniforms, 0, uniformTotal, 0, uniforms.length);
            if (overlay > 0) {
                System.arraycopy(overlayUniforms, 0, uniformTotal, uniforms.length, overlayUniforms.length);
            }
            if (glint > 0) {
                System.arraycopy(glintUniforms, 0, uniformTotal, uniforms.length + overlay, glintUniforms.length);
            }
            MultiTexBinder[] binders = new MultiTexBinder[]{texBinder1, texBinder2};
            this.renderLayer(entitydata, model, overlay, glint, textureLocation, binders, uniformTotal);
            GlStateManager.activeTexture((int)33984);
        } else if (item != Items.field_190931_a) {
            ClientEngine.INSTANCE.renderEngine.getItemRenderer(stack.func_77973_b()).renderItemOnHead(stack, entitydata);
        }
    }

    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        ArmorItem item = (ArmorItem)stack.func_77973_b();
        String texture = item.func_200880_d().func_200897_d();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, slot == EquipmentSlotType.LEGS ? 2 : 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = ARMOR_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlotType)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    static {
        GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
        Field fld = ObfuscationReflectionHelper.findField(ArmorLayer.class, (String)"field_177191_j");
        fld.setAccessible(true);
        try {
            ARMOR_MAP = (Map)fld.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private static class MultiTexBinder {
        private int target;
        private ResourceLocation rl;

        private MultiTexBinder(int target, ResourceLocation rl) {
            this.target = target;
            this.rl = rl;
        }

        public void doWork() {
            GlStateManager.activeTexture((int)this.target);
            LayerRenderer.bindTexture(this.rl);
        }

        public void recover() {
            GlStateManager.activeTexture((int)this.target);
            GlStateManager.bindTexture((int)0);
        }
    }
}

