/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.shader;

import maninhouse.epicfight.client.shader.ShaderProgram;
import maninhouse.epicfight.client.shader.uniforms.UniformFloat;
import maninhouse.epicfight.client.shader.uniforms.UniformInt;
import maninhouse.epicfight.client.shader.uniforms.UniformMatrix;
import maninhouse.epicfight.client.shader.uniforms.UniformMatrixArray;
import maninhouse.epicfight.client.shader.uniforms.UniformVector3f;
import maninhouse.epicfight.utils.math.Mat4f;
import maninhouse.epicfight.utils.math.Vec3f;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmatureShader
extends ShaderProgram {
    private final UniformMatrix modelMatrix;
    private final UniformMatrix viewMatrix;
    private final UniformMatrix projectionMatrix;
    private final UniformVector3f lightColor;
    private final UniformMatrixArray jointTransforms;
    private final UniformVector3f fogColor;
    private final UniformFloat fogMin;
    private final UniformFloat fogMax;
    private final UniformFloat fogDensity;
    private final UniformInt fogOper;

    public ArmatureShader(int vertexId, int fragementId, int jointNumber) {
        super(vertexId, fragementId);
        super.bindShader();
        this.modelMatrix = new UniformMatrix(this.programID, "modelMatrix");
        this.viewMatrix = new UniformMatrix(this.programID, "viewMatrix");
        this.projectionMatrix = new UniformMatrix(this.programID, "projectionMatrix");
        this.lightColor = new UniformVector3f(this.programID, "lightColor");
        this.jointTransforms = new UniformMatrixArray(this.programID, "jointTransforms", jointNumber);
        this.fogColor = new UniformVector3f(this.programID, "fogColor");
        this.fogMin = new UniformFloat(this.programID, "fogMin");
        this.fogMax = new UniformFloat(this.programID, "fogMax");
        this.fogDensity = new UniformFloat(this.programID, "fogDensity");
        this.fogOper = new UniformInt(this.programID, "fogOperation");
    }

    public ArmatureShader(IResourceManager resourceManager, int jointNumber) {
        super(resourceManager, new ResourceLocation("epicfight", "shaders/armaturev.glsl"), new ResourceLocation("epicfight", "shaders/armaturef.glsl"));
        super.bindShader();
        this.modelMatrix = new UniformMatrix(this.programID, "modelMatrix");
        this.viewMatrix = new UniformMatrix(this.programID, "viewMatrix");
        this.projectionMatrix = new UniformMatrix(this.programID, "projectionMatrix");
        this.lightColor = new UniformVector3f(this.programID, "lightColor");
        this.jointTransforms = new UniformMatrixArray(this.programID, "jointTransforms", jointNumber);
        this.fogColor = new UniformVector3f(this.programID, "fogColor");
        this.fogMin = new UniformFloat(this.programID, "fogMin");
        this.fogMax = new UniformFloat(this.programID, "fogMax");
        this.fogDensity = new UniformFloat(this.programID, "fogDensity");
        this.fogOper = new UniformInt(this.programID, "fogOperation");
    }

    @Override
    public void bindAttributes() {
        super.bindAttribute("in_position");
        super.bindAttribute("in_normal");
        super.bindAttribute("in_textureCoord");
        super.bindAttribute("in_jointIndices");
        super.bindAttribute("in_weights");
    }

    @Override
    public void loadUniforms(Object ... objects) {
        this.modelMatrix.loadUniformVariable((Mat4f)objects[0]);
        this.viewMatrix.loadUniformVariable((Mat4f)objects[1]);
        this.projectionMatrix.loadUniformVariable((Mat4f)objects[2]);
        this.lightColor.loadUniformVariable((Vec3f)objects[3]);
        this.jointTransforms.loadUniformVariable((Mat4f[])objects[4]);
        this.fogColor.loadUniformVariable((Vec3f)objects[5]);
        this.fogMin.loadUniformVariable((Float)objects[6]);
        this.fogMax.loadUniformVariable((Float)objects[7]);
        this.fogDensity.loadUniformVariable((Float)objects[8]);
        this.fogOper.loadUniformVariable((Integer)objects[9]);
    }
}

