/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.shader;

import maninhouse.epicfight.client.shader.ShaderProgram;
import maninhouse.epicfight.client.shader.uniforms.UniformMatrix;
import maninhouse.epicfight.utils.math.Mat4f;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BasicShader
extends ShaderProgram {
    private final UniformMatrix modelMatrix;
    private final UniformMatrix viewMatrix;
    private final UniformMatrix projectionMatrix;

    public BasicShader(IResourceManager resourceManager) {
        super(resourceManager, new ResourceLocation("epicfight", "shaders/basicv.glsl"), new ResourceLocation("epicfight", "shaders/basicf.glsl"));
        super.bindShader();
        this.modelMatrix = new UniformMatrix(this.programID, "modelMatrix");
        this.viewMatrix = new UniformMatrix(this.programID, "viewMatrix");
        this.projectionMatrix = new UniformMatrix(this.programID, "projectionMatrix");
    }

    @Override
    public void bindAttributes() {
        super.bindAttribute("in_position");
        super.bindAttribute("in_normal");
        super.bindAttribute("in_textureCoord");
    }

    @Override
    public void loadUniforms(Object ... objects) {
        this.modelMatrix.loadUniformVariable((Mat4f)objects[0]);
        this.viewMatrix.loadUniformVariable((Mat4f)objects[1]);
        this.projectionMatrix.loadUniformVariable((Mat4f)objects[2]);
    }
}

