/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.collada;

import java.util.List;
import maninhouse.epicfight.client.model.Mesh;
import maninhouse.epicfight.client.opengl.VertexArrayObject;
import maninhouse.epicfight.utils.math.Vec2f;
import maninhouse.epicfight.utils.math.Vec3f;

public class VertexData {
    private Vec3f position;
    private Vec3f normal;
    private Vec2f textureCoordinate;
    private Vec3f effectiveJointIDs;
    private Vec3f effectiveJointWeights;

    public VertexData() {
        this.position = null;
        this.normal = null;
        this.textureCoordinate = null;
    }

    public VertexData(VertexData vertex) {
        this.position = vertex.position;
        this.effectiveJointIDs = vertex.effectiveJointIDs;
        this.effectiveJointWeights = vertex.effectiveJointWeights;
    }

    public void setPosition(Vec3f position) {
        this.position = position;
    }

    public void setNormal(Vec3f vector) {
        this.normal = vector;
    }

    public void setTextureCoordinate(Vec2f vector) {
        this.textureCoordinate = vector;
    }

    public void setEffectiveJointIDs(Vec3f effectiveJointIDs) {
        this.effectiveJointIDs = effectiveJointIDs;
    }

    public void setEffectiveJointWeights(Vec3f effectiveJointWeights) {
        this.effectiveJointWeights = effectiveJointWeights;
    }

    public State compareTextureCoordinateAndNormal(Vec3f normal, Vec2f textureCoord) {
        if (this.textureCoordinate == null) {
            return State.EMPTY;
        }
        if (this.textureCoordinate.equals(textureCoord) && this.normal.equals(normal)) {
            return State.EQUAL;
        }
        return State.DIFFERENT;
    }

    public static void loadVertexInformation(List<VertexData> vertices, int[] indices, Mesh meshdata, boolean isAnimation) {
        float[] position_array = new float[vertices.size() * 3];
        float[] noraml_array = new float[vertices.size() * 3];
        float[] textureCoord_array = new float[vertices.size() * 2];
        int[] jointIndex_array = new int[vertices.size() * 3];
        float[] jointWeight_array = new float[vertices.size() * 3];
        for (int i = 0; i < vertices.size(); ++i) {
            VertexData vertex = vertices.get(i);
            Vec3f position = vertex.position;
            Vec3f normal = vertex.normal;
            Vec2f texCoord = vertex.textureCoordinate;
            position_array[i * 3] = position.x;
            position_array[i * 3 + 1] = position.y;
            position_array[i * 3 + 2] = position.z;
            noraml_array[i * 3] = normal.x;
            noraml_array[i * 3 + 1] = normal.y;
            noraml_array[i * 3 + 2] = normal.z;
            textureCoord_array[i * 2] = texCoord.x;
            textureCoord_array[i * 2 + 1] = texCoord.y;
            if (!isAnimation) continue;
            Vec3f effectIDs = vertex.effectiveJointIDs;
            Vec3f weights = vertex.effectiveJointWeights;
            jointIndex_array[i * 3] = (int)effectIDs.x;
            jointIndex_array[i * 3 + 1] = (int)effectIDs.y;
            jointIndex_array[i * 3 + 2] = (int)effectIDs.z;
            jointWeight_array[i * 3] = weights.x;
            jointWeight_array[i * 3 + 1] = weights.y;
            jointWeight_array[i * 3 + 2] = weights.z;
        }
        VertexArrayObject vao = meshdata.getVao();
        vao.bufferDataFloat(0, 3, position_array);
        vao.bufferDataFloat(1, 3, noraml_array);
        vao.bufferDataFloat(2, 2, textureCoord_array);
        if (isAnimation) {
            vao.bufferDataInt(3, 3, jointIndex_array);
            vao.bufferDataFloat(4, 3, jointWeight_array);
        }
        vao.bufferDataElement(indices);
    }

    public static enum State {
        EMPTY,
        EQUAL,
        DIFFERENT;

    }
}

