/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.entity.ai;

import java.util.EnumSet;
import maninhouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCPlayAnimation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;

public class ArcherGoal<T extends MobEntity>
extends Goal {
    private final T entity;
    private final BipedMobData<?> entitydata;
    private LivingEntity chasingTarget;
    private final double moveSpeedAmp;
    private int attackCooldown;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public ArcherGoal(BipedMobData<?> entitydata, T p_i47515_1_, double p_i47515_2_, int p_i47515_4_, float p_i47515_5_) {
        this.entity = p_i47515_1_;
        this.entitydata = entitydata;
        this.moveSpeedAmp = p_i47515_2_;
        this.attackCooldown = p_i47515_4_;
        this.maxAttackDistance = p_i47515_5_ * p_i47515_5_;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void setAttackCooldown(int p_189428_1_) {
        this.attackCooldown = p_189428_1_;
    }

    public boolean func_75250_a() {
        return this.entity.func_70638_az() == null && this.chasingTarget == null ? false : this.isBowInMainhand() && !this.entitydata.isInaction();
    }

    protected boolean isBowInMainhand() {
        ItemStack main = this.entity.func_184614_ca();
        ItemStack off = this.entity.func_184592_cb();
        return main.func_77973_b() instanceof BowItem || off.func_77973_b() instanceof BowItem;
    }

    public boolean func_75253_b() {
        return (this.func_75250_a() || !this.entity.func_70661_as().func_75500_f()) && this.isBowInMainhand() && !this.entitydata.isInaction();
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.entity.func_213395_q(true);
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.seeTime = 0;
        this.attackTime = -1;
        this.entity.func_184602_cy();
        this.entity.func_70605_aq().func_188488_a(0.0f, 0.0f);
        this.entity.func_70661_as().func_75499_g();
        this.entity.func_213395_q(false);
        if (!this.entitydata.isInaction()) {
            ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimation(-1, this.entity.func_145782_y(), 0.0f), this.entity);
        }
    }

    public void func_75246_d() {
        LivingEntity LivingEntity2 = this.entity.func_70638_az();
        if (LivingEntity2 != null) {
            double d0 = this.entity.func_70092_e(LivingEntity2.field_70165_t, LivingEntity2.func_174813_aQ().field_72338_b, LivingEntity2.field_70161_v);
            boolean flag = this.entity.func_70635_at().func_75522_a((Entity)LivingEntity2);
            boolean flag1 = this.seeTime > 0;
            this.chasingTarget = LivingEntity2;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            if (d0 <= (double)this.maxAttackDistance * 1.5 && this.seeTime >= 20) {
                this.entity.func_70661_as().func_75499_g();
                ++this.strafingTime;
            } else {
                this.entity.func_70661_as().func_75497_a((Entity)LivingEntity2, this.moveSpeedAmp);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                    boolean bl = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                    this.strafingBackwards = true;
                }
                if (this.entity.func_184605_cv() < 10) {
                    this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                } else {
                    this.entity.func_70605_aq().func_188488_a(0.0f, 0.0f);
                }
                this.entity.func_70671_ap().func_75651_a((Entity)LivingEntity2, (float)this.entity.func_184649_cE(), (float)this.entity.func_70646_bf());
                this.entity.func_70625_a((Entity)LivingEntity2, 30.0f, 30.0f);
            } else {
                this.entity.func_70671_ap().func_75651_a((Entity)LivingEntity2, 30.0f, 30.0f);
            }
            if (this.entity.func_184587_cr()) {
                int i;
                if (!flag && this.seeTime < -60) {
                    this.entity.func_184602_cy();
                } else if (flag && (i = this.entity.func_184612_cw()) >= 20) {
                    this.entity.func_184602_cy();
                    ((IRangedAttackMob)this.entity).func_82196_d(LivingEntity2, BowItem.func_185059_b((int)i));
                    ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimation(Animations.BIPED_BOW_REBOUND.getId(), this.entity.func_145782_y(), 0.0f, true), this.entity);
                    this.attackTime = this.attackCooldown;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimation(Animations.BIPED_BOW_AIM.getId(), this.entity.func_145782_y(), 0.0f, true), this.entity);
                this.entity.func_184598_c(ProjectileHelper.func_221274_a(this.entity, (Item)Items.field_151031_f));
            }
        } else {
            double d0;
            if (this.chasingTarget != null && (d0 = this.entity.func_70092_e(this.chasingTarget.field_70165_t, this.chasingTarget.func_174813_aQ().field_72338_b, this.chasingTarget.field_70161_v)) <= (double)this.maxAttackDistance * 2.0 && this.seeTime >= 20) {
                if (d0 <= (double)this.maxAttackDistance) {
                    this.chasingTarget = null;
                } else {
                    this.entity.func_184602_cy();
                    this.entity.func_70661_as().func_75497_a((Entity)this.chasingTarget, this.moveSpeedAmp);
                }
                return;
            }
            this.chasingTarget = null;
        }
    }
}

