/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.entity.ai;

import java.util.EnumSet;
import java.util.List;
import maninhouse.epicfight.animation.types.attack.AttackAnimation;
import maninhouse.epicfight.capabilities.entity.MobData;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCPlayAnimationTarget;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;

public class AttackPatternGoal
extends Goal {
    protected final MobEntity attacker;
    protected final MobData<?> mobdata;
    protected final double minDist;
    protected final double maxDist;
    protected final List<AttackAnimation> pattern;
    protected final boolean affectHorizon;
    protected int patternIndex;

    public AttackPatternGoal(MobData<?> mobdata, MobEntity attacker, double minDist, double maxDIst, boolean affectHorizon, List<AttackAnimation> pattern) {
        this.attacker = attacker;
        this.mobdata = mobdata;
        this.minDist = minDist * minDist;
        this.maxDist = maxDIst * maxDIst;
        this.pattern = pattern;
        this.patternIndex = 0;
        this.affectHorizon = affectHorizon;
        this.func_220684_a(EnumSet.noneOf(Goal.Flag.class));
    }

    public boolean func_75250_a() {
        LivingEntity LivingEntity2 = this.attacker.func_70638_az();
        return this.isValidTarget(LivingEntity2) && this.isTargetInRange(LivingEntity2);
    }

    public boolean func_75253_b() {
        LivingEntity LivingEntity2 = this.attacker.func_70638_az();
        return this.pattern.size() <= this.patternIndex && this.isValidTarget(LivingEntity2) && this.isTargetInRange(LivingEntity2);
    }

    public void func_75249_e() {
    }

    public void func_75251_c() {
        this.patternIndex %= this.pattern.size();
    }

    protected boolean canExecuteAttack() {
        return !this.mobdata.isInaction();
    }

    public void func_75246_d() {
        if (this.canExecuteAttack()) {
            AttackAnimation att = this.pattern.get(this.patternIndex++);
            this.patternIndex %= this.pattern.size();
            this.mobdata.getServerAnimator().playAnimation(att, 0.0f);
            this.mobdata.updateInactionState();
            ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimationTarget(att.getId(), this.attacker.func_145782_y(), 0.0f, this.attacker.func_70638_az().func_145782_y()), (Entity)this.attacker);
        }
    }

    protected boolean isTargetInRange(LivingEntity attackTarget) {
        double targetRange = this.attacker.func_70092_e(attackTarget.field_70165_t, attackTarget.func_174813_aQ().field_72338_b, attackTarget.field_70161_v);
        return targetRange <= this.maxDist && targetRange >= this.minDist && this.isInSameHorizontalPosition(attackTarget);
    }

    protected boolean isValidTarget(LivingEntity attackTarget) {
        return attackTarget != null && attackTarget.func_70089_S() && (!(attackTarget instanceof PlayerEntity) || !((PlayerEntity)attackTarget).func_175149_v() && !((PlayerEntity)attackTarget).func_184812_l_());
    }

    protected boolean isInSameHorizontalPosition(LivingEntity attackTarget) {
        if (this.affectHorizon) {
            return Math.abs(this.attacker.field_70163_u - attackTarget.field_70163_u) <= (double)this.attacker.func_70047_e();
        }
        return true;
    }
}

