/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.entity.ai;

import java.util.EnumSet;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.MobData;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCLivingMotionChange;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.BlockPos;

public class ChasingGoal
extends Goal {
    protected MobData<?> mobdata;
    protected final MobEntity attacker;
    private final double speedTowardsTarget;
    private final boolean longMemory;
    private Path path;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    protected final int attackInterval = 20;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;
    protected final StaticAnimation chasingAnimation;
    protected final StaticAnimation walkingAnimation;
    protected final boolean changeMotion;

    public ChasingGoal(MobData<?> mobdata, MobEntity host, double speedIn, boolean useLongMemory, StaticAnimation chasingId, StaticAnimation walkId, boolean changeMotion) {
        this.mobdata = mobdata;
        this.attacker = host;
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.chasingAnimation = chasingId;
        this.walkingAnimation = walkId;
        this.changeMotion = changeMotion;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public ChasingGoal(MobData<?> mobdata, MobEntity host, double speedIn, boolean useLongMemory) {
        this(mobdata, host, speedIn, useLongMemory, null, null, false);
    }

    public ChasingGoal(MobData<?> mobdata, MobEntity host, double speedIn, boolean useLongMemory, StaticAnimation chasing, StaticAnimation walk) {
        this(mobdata, host, speedIn, useLongMemory, chasing, walk, true);
    }

    public boolean func_75250_a() {
        LivingEntity livingentity = this.attacker.func_70638_az();
        if (livingentity == null || !livingentity.func_70089_S()) {
            return false;
        }
        if (this.mobdata.isInaction()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.delayCounter <= 0) {
                this.path = this.attacker.func_70661_as().func_75494_a((Entity)livingentity, 0);
                this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.attacker.func_70661_as().func_75494_a((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.attacker.func_70092_e(livingentity.field_70165_t, livingentity.func_174813_aQ().field_72338_b, livingentity.field_70161_v);
    }

    public boolean func_75253_b() {
        LivingEntity livingentity = this.attacker.func_70638_az();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.func_70089_S()) {
            return false;
        }
        if (!this.attacker.func_213389_a(new BlockPos((Entity)livingentity))) {
            return false;
        }
        return !(livingentity instanceof PlayerEntity) || !livingentity.func_175149_v() && !((PlayerEntity)livingentity).func_184812_l_();
    }

    public void func_75249_e() {
        this.attacker.func_70661_as().func_75484_a(this.path, this.speedTowardsTarget);
        this.attacker.func_213395_q(true);
        this.delayCounter = -1;
        if (this.changeMotion) {
            STCLivingMotionChange msg = new STCLivingMotionChange(this.attacker.func_145782_y(), 1);
            msg.setMotions(LivingMotion.WALKING);
            msg.setAnimations(this.chasingAnimation);
            ModNetworkManager.sendToAllPlayerTrackingThisEntity(msg, (Entity)this.attacker);
        }
    }

    public void func_75251_c() {
        LivingEntity livingentity = this.attacker.func_70638_az();
        if (!EntityPredicates.field_188444_d.test(livingentity)) {
            this.attacker.func_70624_b((LivingEntity)null);
        }
        this.attacker.func_213395_q(false);
        this.attacker.func_70661_as().func_75499_g();
        if (this.changeMotion) {
            STCLivingMotionChange msg = new STCLivingMotionChange(this.attacker.func_145782_y(), 1);
            msg.setMotions(LivingMotion.WALKING);
            msg.setAnimations(this.walkingAnimation);
            ModNetworkManager.sendToAllPlayerTrackingThisEntity(msg, (Entity)this.attacker);
        }
    }

    public void func_75246_d() {
        if (this.mobdata.isInaction()) {
            this.attacker.func_70661_as().func_75499_g();
            this.delayCounter = -1;
            return;
        }
        LivingEntity livingentity = this.attacker.func_70638_az();
        this.attacker.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
        double d0 = this.attacker.func_70092_e(livingentity.field_70165_t, livingentity.func_174813_aQ().field_72338_b, livingentity.field_70161_v);
        if (this.longMemory || this.attacker.func_70635_at().func_75522_a((Entity)livingentity) && --this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingentity.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.func_70681_au().nextFloat() < 0.05f)) {
            this.targetX = livingentity.field_70165_t;
            this.targetY = livingentity.func_174813_aQ().field_72338_b;
            this.targetZ = livingentity.field_70161_v;
            this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
            if (this.canPenalize) {
                PathPoint finalPathPoint;
                this.delayCounter += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.attacker.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.attacker.func_70661_as().func_75505_d().func_75870_c()) != null && livingentity.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (d0 > 1024.0) {
                this.delayCounter += 10;
            } else if (d0 > 256.0) {
                this.delayCounter += 5;
            }
            if (!this.attacker.func_70661_as().func_75497_a((Entity)livingentity, this.speedTowardsTarget)) {
                this.delayCounter += 2;
            }
        }
    }

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return this.attacker.func_213311_cf() * 2.0f * this.attacker.func_213311_cf() * 2.0f + attackTarget.func_213311_cf();
    }
}

