/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.entity.ai;

import java.util.EnumSet;
import maninhouse.epicfight.animation.Animator;
import maninhouse.epicfight.animation.types.DynamicAnimation;
import maninhouse.epicfight.animation.types.LinkAnimation;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCPlayAnimationTarget;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.MathHelper;

public class RangeAttackMobGoal
extends Goal {
    protected final MobEntity entityHost;
    protected final BipedMobData<?> entitydata;
    protected final StaticAnimation shotAnimation;
    protected final IRangedAttackMob rangedAttackEntityHost;
    protected LivingEntity attackTarget;
    protected int rangedAttackTime = -1;
    protected final double entityMoveSpeed;
    protected int seeTime;
    protected final int attackIntervalMin;
    protected final int maxRangedAttackTime;
    protected final float attackRadius;
    protected final float maxAttackDistance;
    protected final int animationFrame;

    public RangeAttackMobGoal(IRangedAttackMob attacker, BipedMobData<?> entitydata, StaticAnimation shotanimation, double movespeed, int maxAttackTime, float maxAttackDistanceIn, int animationFrame) {
        this(attacker, entitydata, shotanimation, movespeed, maxAttackTime, maxAttackTime, maxAttackDistanceIn, animationFrame);
    }

    public RangeAttackMobGoal(IRangedAttackMob attacker, BipedMobData<?> entitydata, StaticAnimation shotanimation, double movespeed, int p_i1650_4_, int maxAttackTime, float maxAttackDistanceIn, int animationFrame) {
        if (!(attacker instanceof LivingEntity)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.entitydata = entitydata;
        this.shotAnimation = shotanimation;
        this.rangedAttackEntityHost = attacker;
        this.entityHost = (MobEntity)attacker;
        this.entityMoveSpeed = movespeed;
        this.attackIntervalMin = p_i1650_4_;
        this.maxRangedAttackTime = maxAttackTime;
        this.attackRadius = maxAttackDistanceIn;
        this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
        this.animationFrame = animationFrame;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity LivingEntity2 = this.entityHost.func_70638_az();
        if (LivingEntity2 == null) {
            return false;
        }
        this.attackTarget = LivingEntity2;
        return true;
    }

    public boolean func_75253_b() {
        DynamicAnimation animation;
        if (this.entitydata.isInaction() && (animation = ((Animator)this.entitydata.getAnimator()).getPlayer().getPlay()) != this.shotAnimation && animation instanceof LinkAnimation && ((LinkAnimation)animation).getNextAnimation() != this.shotAnimation) {
            return false;
        }
        return this.func_75250_a() || !this.entityHost.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.seeTime = 0;
        this.rangedAttackTime = -1;
    }

    public void func_75246_d() {
        double d0 = this.entityHost.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
        boolean flag = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
        this.seeTime = flag ? ++this.seeTime : 0;
        if (d0 <= (double)this.maxAttackDistance && this.seeTime >= 20) {
            this.entityHost.func_70661_as().func_75499_g();
        } else {
            this.entityHost.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
        }
        this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        if (--this.rangedAttackTime == this.animationFrame && !this.entitydata.isInaction() && flag) {
            this.entitydata.getServerAnimator().playAnimation(this.shotAnimation, 0.0f);
            ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimationTarget(this.shotAnimation.getId(), this.entityHost.func_145782_y(), 0.0f, this.attackTarget.func_145782_y()), (Entity)this.entityHost);
        } else if (this.rangedAttackTime == 0) {
            if (!flag) {
                return;
            }
            float f = MathHelper.func_76133_a((double)d0) / this.attackRadius;
            float lvt_5_1_ = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
            this.rangedAttackEntityHost.func_82196_d(this.attackTarget, lvt_5_1_);
            this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.rangedAttackTime < 0) {
            float f2 = MathHelper.func_76133_a((double)d0) / this.attackRadius;
            this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        }
    }
}

