/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.events;

import com.google.common.collect.Lists;
import java.util.List;
import maninhouse.epicfight.animation.Animator;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.CapabilityEntity;
import maninhouse.epicfight.capabilities.entity.IRangedAttackMobCapability;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninhouse.epicfight.capabilities.entity.mob.EndermanData;
import maninhouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.effects.ModEffects;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.client.CTSPlayAnimation;
import maninhouse.epicfight.network.server.STCPlayAnimation;
import maninhouse.epicfight.network.server.STCPotion;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import maninhouse.epicfight.utils.game.IndirectDamageSourceExtended;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Items;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="epicfight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EntityEvents {
    private static List<CapabilityEntity<?>> unInitializedEntitiesClient = Lists.newArrayList();
    private static List<CapabilityEntity<?>> unInitializedEntitiesServer = Lists.newArrayList();

    @SubscribeEvent
    public static void spawnEvent(EntityJoinWorldEvent event) {
        CapabilityEntity entitydata = (CapabilityEntity)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (entitydata != null && event.getEntity().field_70173_aa == 0) {
            entitydata.setEntity(event.getEntity());
            entitydata.init();
            if (entitydata.isRemote()) {
                unInitializedEntitiesClient.add(entitydata);
            } else {
                unInitializedEntitiesServer.add(entitydata);
            }
        }
    }

    @SubscribeEvent
    public static void updateEvent(LivingEvent.LivingUpdateEvent event) {
        LivingData entitydata = (LivingData)event.getEntityLiving().getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (entitydata != null && entitydata.getOriginalEntity() != null) {
            entitydata.update();
        }
    }

    @SubscribeEvent
    public static void knockBackEvent(LivingKnockBackEvent event) {
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void hurtEvent(LivingHurtEvent event) {
        CapabilityEntity attackerdata;
        IExtendedDamageSource extSource = null;
        Entity trueSource = event.getSource().func_76346_g();
        if (event.getSource() instanceof IExtendedDamageSource) {
            extSource = (IExtendedDamageSource)event.getSource();
        } else if (event.getSource() instanceof IndirectEntityDamageSource && (attackerdata = (CapabilityEntity)trueSource.getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null) {
            if (attackerdata instanceof IRangedAttackMobCapability) {
                extSource = ((IRangedAttackMobCapability)((Object)attackerdata)).getRangedDamageSource(event.getSource().func_76364_f());
            } else if (event.getSource().field_76373_n == "arrow") {
                extSource = new IndirectDamageSourceExtended("arrow", trueSource, event.getSource().func_76364_f(), IExtendedDamageSource.StunType.SHORT);
            }
        }
        if (extSource != null) {
            LivingData hurtEntityCap;
            int k;
            int i;
            int j;
            float f;
            float f1;
            float f2;
            float ignoreDamage;
            float totalDamage = event.getAmount();
            float calculatedDamage = ignoreDamage = event.getAmount() * extSource.getArmorIgnoreRatio();
            LivingEntity hurtEntity = event.getEntityLiving();
            if (hurtEntity.func_70644_a(Effects.field_76429_m) && (f2 = (f1 = calculatedDamage) - (calculatedDamage = Math.max((f = calculatedDamage * (float)(j = 25 - (i = (hurtEntity.func_70660_b(Effects.field_76429_m).func_76458_c() + 1) * 5))) / 25.0f, 0.0f))) > 0.0f && f2 < 3.4028235E37f) {
                if (hurtEntity instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)hurtEntity).func_195067_a(Stats.field_212739_K, Math.round(f2 * 10.0f));
                } else if (event.getSource().func_76346_g() instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)event.getSource().func_76346_g()).func_195067_a(Stats.field_212736_G, Math.round(f2 * 10.0f));
                }
            }
            if (calculatedDamage > 0.0f && (k = EnchantmentHelper.func_77508_a((Iterable)hurtEntity.func_184193_aE(), (DamageSource)event.getSource())) > 0) {
                calculatedDamage = CombatRules.func_188401_b((float)calculatedDamage, (float)k);
            }
            float absorpAmount = hurtEntity.func_110139_bj() - calculatedDamage;
            hurtEntity.func_110149_m(Math.max(absorpAmount, 0.0f));
            float realHealthDamage = Math.max(-absorpAmount, 0.0f);
            if (realHealthDamage > 0.0f && realHealthDamage < 3.4028235E37f && event.getSource().func_76346_g() instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)event.getSource().func_76346_g()).func_195067_a(Stats.field_212735_F, Math.round(realHealthDamage * 10.0f));
            }
            if (absorpAmount < 0.0f) {
                hurtEntity.func_70606_j(hurtEntity.func_110143_aJ() + absorpAmount);
                LivingData attacker = (LivingData)trueSource.getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
                if (attacker != null) {
                    attacker.gatherDamageDealt((IExtendedDamageSource)event.getSource(), calculatedDamage);
                }
            }
            event.setAmount(totalDamage - ignoreDamage);
            if (event.getAmount() > 0.0f && (hurtEntityCap = (LivingData)hurtEntity.getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null) {
                StaticAnimation hitAnimation = null;
                float extendStunTime = 0.0f;
                float knockBackAmount = 0.0f;
                float weightReduction = 40.0f / (float)hurtEntityCap.getWeight();
                switch (extSource.getStunType()) {
                    case SHORT: {
                        if (hurtEntity.func_70644_a(ModEffects.STUN_IMMUNITY) || hurtEntityCap.getStunResistance() != 0.0f && !extSource.isSureStrike()) break;
                        int i2 = EnchantmentHelper.func_77501_a((LivingEntity)((LivingEntity)trueSource));
                        float totalStunTime = (0.25f + extSource.getImpact() * 0.1f + 0.1f * (float)i2) * weightReduction;
                        if (!extSource.isSureStrike()) {
                            totalStunTime *= 1.0f - hurtEntityCap.getStunTimeTimeReduction();
                        }
                        if (!(totalStunTime >= 0.2f)) break;
                        extendStunTime = totalStunTime - 0.1f;
                        boolean flag = totalStunTime >= 0.83f;
                        IExtendedDamageSource.StunType stunType = flag ? IExtendedDamageSource.StunType.LONG : IExtendedDamageSource.StunType.SHORT;
                        extendStunTime = flag ? 0.0f : extendStunTime;
                        hitAnimation = hurtEntityCap.getHitAnimation(stunType);
                        knockBackAmount = totalStunTime;
                        break;
                    }
                    case LONG: {
                        hitAnimation = hurtEntity.func_70644_a(ModEffects.STUN_IMMUNITY) ? null : hurtEntityCap.getHitAnimation(IExtendedDamageSource.StunType.LONG);
                        knockBackAmount = extSource.getImpact() * 0.25f * weightReduction;
                        break;
                    }
                    case HOLD: {
                        hitAnimation = hurtEntityCap.getHitAnimation(IExtendedDamageSource.StunType.SHORT);
                        extendStunTime = extSource.getImpact() * 0.5f;
                    }
                }
                if (hitAnimation != null) {
                    if (!extSource.isSureStrike()) {
                        hurtEntityCap.setStunTimeReduction();
                    }
                    ((Animator)hurtEntityCap.getAnimator()).playAnimation(hitAnimation, extendStunTime);
                    ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimation(hitAnimation.getId(), hurtEntity.func_145782_y(), extendStunTime), (Entity)hurtEntity);
                    if (hurtEntity instanceof ServerPlayerEntity) {
                        ModNetworkManager.sendToPlayer(new STCPlayAnimation(hitAnimation.getId(), hurtEntity.func_145782_y(), extendStunTime), (ServerPlayerEntity)hurtEntity);
                    }
                }
                hurtEntityCap.knockBackEntity(trueSource, knockBackAmount);
            }
        }
        if (event.getEntityLiving().func_184587_cr() && event.getEntityLiving().func_184607_cu().func_77973_b() == Items.field_185159_cQ && event.getEntityLiving() instanceof PlayerEntity) {
            event.getEntityLiving().field_70170_p.func_184133_a((PlayerEntity)event.getEntityLiving(), event.getEntityLiving().func_180425_c(), SoundEvents.field_187767_eL, event.getEntityLiving().func_184176_by(), 1.0f, 0.8f + event.getEntityLiving().func_70681_au().nextFloat() * 0.4f);
        }
    }

    @SubscribeEvent
    public static void damageEvent(LivingDamageEvent event) {
        LivingData attacker;
        Entity trueSource = event.getSource().func_76346_g();
        if (event.getSource() instanceof IExtendedDamageSource && trueSource != null && (attacker = (LivingData)trueSource.getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null) {
            attacker.gatherDamageDealt((IExtendedDamageSource)event.getSource(), event.getAmount());
        }
    }

    @SubscribeEvent
    public static void attackEvent(LivingAttackEvent event) {
        LivingData entitydata = (LivingData)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (entitydata != null && !event.getEntity().field_70170_p.field_72995_K && event.getEntityLiving().func_110143_aJ() > 0.0f && !entitydata.attackEntityFrom(event.getSource(), event.getAmount())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void deathEvent(LivingDeathEvent event) {
        LivingData entitydata = (LivingData)event.getEntityLiving().getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (entitydata != null) {
            ((Animator)entitydata.getAnimator()).playDeathAnimation();
        }
    }

    @SubscribeEvent
    public static void arrowHitEvent(ProjectileImpactEvent.Arrow event) {
        EntityRayTraceResult rayresult;
        if (event.getRayTraceResult() instanceof EntityRayTraceResult && (rayresult = (EntityRayTraceResult)event.getRayTraceResult()).func_216348_a() != null && event.getArrow().func_212360_k() != null && rayresult.func_216348_a().equals((Object)event.getArrow().func_212360_k().func_184187_bx())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void equipChangeEvent(LivingEquipmentChangeEvent event) {
        if (event.getFrom().func_77973_b() == event.getTo().func_77973_b()) {
            return;
        }
        if (event.getSlot() == EquipmentSlotType.MAINHAND) {
            LivingData entitycap = (LivingData)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
            if (entitycap != null) {
                entitycap.cancelUsingItem();
                if (entitycap instanceof ServerPlayerData) {
                    CapabilityItem toCap = (CapabilityItem)event.getTo().getCapability(ModCapabilities.CAPABILITY_ITEM, null).orElse(null);
                    ServerPlayerData playercap = (ServerPlayerData)entitycap;
                    playercap.onHeldItemChange(toCap, null, event.getTo());
                }
            }
        } else if (event.getSlot() == EquipmentSlotType.OFFHAND) {
            LivingData entitycap = (LivingData)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
            if (entitycap != null) {
                entitycap.cancelUsingItem();
                if (entitycap instanceof ServerPlayerData) {
                    ServerPlayerData playercap = (ServerPlayerData)entitycap;
                    CapabilityItem toCap = entitycap.getHeldItemCapability(Hand.MAIN_HAND);
                    playercap.onHeldItemChange(entitycap.getHeldItemCapability(Hand.MAIN_HAND), toCap, event.getTo());
                }
            }
        } else if (event.getSlot().func_188453_a() == EquipmentSlotType.Group.ARMOR) {
            CapabilityItem fromCap = (CapabilityItem)event.getFrom().getCapability(ModCapabilities.CAPABILITY_ITEM, null).orElse(null);
            CapabilityItem toCap = (CapabilityItem)event.getTo().getCapability(ModCapabilities.CAPABILITY_ITEM, null).orElse(null);
            if (fromCap != null) {
                event.getEntityLiving().func_110140_aT().func_111148_a(fromCap.getAttributeModifiers(event.getSlot()));
            }
            if (toCap != null) {
                event.getEntityLiving().func_110140_aT().func_111147_b(toCap.getAttributeModifiers(event.getSlot()));
            }
            if (event.getEntityLiving() instanceof ServerPlayerEntity) {
                ServerPlayerData playercap = (ServerPlayerData)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
                playercap.onArmorSlotChanged(fromCap, toCap, event.getSlot());
            }
        }
    }

    @SubscribeEvent
    public static void effectAddEvent(PotionEvent.PotionAddedEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            ModNetworkManager.sendToAll(new STCPotion(event.getPotionEffect().func_188419_a(), STCPotion.Action.Active, event.getEntity().func_145782_y()));
        }
    }

    @SubscribeEvent
    public static void effectRemoveEvent(PotionEvent.PotionRemoveEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            ModNetworkManager.sendToAll(new STCPotion(event.getPotionEffect().func_188419_a(), STCPotion.Action.Remove, event.getEntity().func_145782_y()));
        }
    }

    @SubscribeEvent
    public static void effectExpiryEvent(PotionEvent.PotionExpiryEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            ModNetworkManager.sendToAll(new STCPotion(event.getPotionEffect().func_188419_a(), STCPotion.Action.Remove, event.getEntity().func_145782_y()));
        }
    }

    @SubscribeEvent
    public static void mountEvent(EntityMountEvent event) {
        CapabilityEntity mountEntity = (CapabilityEntity)event.getEntityMounting().getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (!event.getWorldObj().field_72995_K && mountEntity instanceof BipedMobData && mountEntity.getOriginalEntity() != null && event.getEntityBeingMounted() instanceof MobEntity) {
            ((BipedMobData)mountEntity).onMount(event.isMounting(), event.getEntityBeingMounted());
        }
    }

    @SubscribeEvent
    public static void targetEvent(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving().equals((Object)event.getTarget())) {
            event.getEntityLiving().func_70604_c(null);
            if (event.getEntityLiving() instanceof MobEntity) {
                ((MobEntity)event.getEntityLiving()).func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public static void tpEvent(EnderTeleportEvent event) {
        EndermanEntity enderman;
        EndermanData endermandata;
        LivingEntity entity = event.getEntityLiving();
        if (event.getEntityLiving() instanceof EndermanEntity && (endermandata = (EndermanData)(enderman = (EndermanEntity)entity).getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null) {
            if (endermandata.isInaction()) {
                for (Entity collideEntity : enderman.field_70170_p.func_217357_a(Entity.class, enderman.func_174813_aQ().func_72314_b(0.2, 0.2, 0.2))) {
                    if (!(collideEntity instanceof IProjectile)) continue;
                    return;
                }
                event.setCanceled(true);
            } else if (endermandata.isRaging()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void jumpEvent(LivingEvent.LivingJumpEvent event) {
        LivingData entitydata = (LivingData)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (entitydata != null && entitydata.isRemote() && !entitydata.isInaction() && !event.getEntity().func_70090_H()) {
            StaticAnimation jumpAnimation = entitydata.getClientAnimator().getJumpAnimation();
            ((Animator)entitydata.getAnimator()).playAnimation(jumpAnimation, 0.0f);
            ModNetworkManager.sendToServer(new CTSPlayAnimation(jumpAnimation.getId(), 0.0f, true, false));
        }
    }

    @SubscribeEvent
    public static void fallEvent(LivingFallEvent event) {
        float distance;
        LivingData entitydata = (LivingData)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (entitydata != null && !entitydata.isInaction() && (distance = event.getDistance()) > 5.0f) {
            ((Animator)entitydata.getAnimator()).playAnimation(Animations.BIPED_LAND_DAMAGE, 0.0f);
        }
    }

    @SubscribeEvent
    public static void tickClientEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (CapabilityEntity<?> cap : unInitializedEntitiesClient) {
                cap.postInit();
            }
            unInitializedEntitiesClient.clear();
        }
    }

    @SubscribeEvent
    public static void tickServerEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (CapabilityEntity<?> cap : unInitializedEntitiesServer) {
                cap.postInit();
            }
            unInitializedEntitiesServer.clear();
        }
    }
}

