/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.events;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import maninhouse.epicfight.client.particle.BlastParticle;
import maninhouse.epicfight.client.particle.BlastPunchHugeParticle;
import maninhouse.epicfight.client.particle.BlastPunchParticle;
import maninhouse.epicfight.client.particle.BloodParticle;
import maninhouse.epicfight.client.particle.CutParticle;
import maninhouse.epicfight.client.particle.DustParticle;
import maninhouse.epicfight.client.particle.HitBluntParticle;
import maninhouse.epicfight.client.particle.HitCutParticle;
import maninhouse.epicfight.client.particle.ParryParticle;
import maninhouse.epicfight.client.particle.PortalStraightParticle;
import maninhouse.epicfight.effects.ModEffects;
import maninhouse.epicfight.effects.SuperarmorEffect;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.item.ItemArmorExtend;
import maninhouse.epicfight.item.ItemGreatsword;
import maninhouse.epicfight.item.ItemKatana;
import maninhouse.epicfight.item.ItemSpear;
import maninhouse.epicfight.item.ModArmorMaterials;
import maninhouse.epicfight.item.ModItems;
import maninhouse.epicfight.particle.Particles;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Rarity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.BasicState;
import net.minecraftforge.client.model.ForgeBlockStateV1;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="epicfight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryEvents {
    @SubscribeEvent
    public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
    }

    @SubscribeEvent
    public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
        Models modelDB = FMLEnvironment.dist == Dist.DEDICATED_SERVER ? Models.LOGICAL_SERVER : Models.LOGICAL_CLIENT;
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{ModItems.KATANA = (Item)new ItemKatana(new Item.Properties().func_200916_a(ItemGroup.field_78037_j).func_208103_a(Rarity.RARE).func_200915_b(650)).setRegistryName("katana"), ((ItemKatana)ModItems.KATANA).getShealth().func_77973_b(), ModItems.GREATSWORD = (Item)new ItemGreatsword(new Item.Properties().func_200916_a(ItemGroup.field_78037_j).func_200915_b(1561)).setRegistryName("greatsword"), ModItems.STONE_SPEAR = (Item)new ItemSpear(new Item.Properties().func_200916_a(ItemGroup.field_78037_j), ItemTier.STONE).setRegistryName("stone_spear"), ModItems.GOLDEN_SPEAR = (Item)new ItemSpear(new Item.Properties().func_200916_a(ItemGroup.field_78037_j), ItemTier.GOLD).setRegistryName("golden_spear"), ModItems.IRON_SPEAR = (Item)new ItemSpear(new Item.Properties().func_200916_a(ItemGroup.field_78037_j), ItemTier.IRON).setRegistryName("iron_spear"), ModItems.DIAMOND_SPEAR = (Item)new ItemSpear(new Item.Properties().func_200916_a(ItemGroup.field_78037_j), ItemTier.DIAMOND).setRegistryName("diamond_spear"), ModItems.STRAY_HAT = (Item)new ItemArmorExtend(new Item.Properties().func_200916_a(ItemGroup.field_78037_j), ModArmorMaterials.STRAY_CLOTH, EquipmentSlotType.HEAD, modelDB.ITEM_HELMET).setRegistryName("stray_hat"), ModItems.STRAY_PANTS = (Item)new ItemArmorExtend(new Item.Properties().func_200916_a(ItemGroup.field_78037_j), ModArmorMaterials.STRAY_CLOTH, EquipmentSlotType.LEGS, modelDB.ITEM_LEGGINS_CLOTH).setRegistryName("stray_pants"), ModItems.STRAY_ROBE = (Item)new ItemArmorExtend(new Item.Properties().func_200916_a(ItemGroup.field_78037_j), ModArmorMaterials.STRAY_CLOTH, EquipmentSlotType.CHEST, modelDB.ITEM_CHESTPLATE).setRegistryName("stray_robe")});
    }

    @SubscribeEvent
    public static void onEffectRegistry(RegistryEvent.Register<Effect> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Effect[]{ModEffects.STUN_IMMUNITY = new SuperarmorEffect()});
    }

    @SubscribeEvent
    public static void onSoundRegistry(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{Sounds.BLADE_HIT, Sounds.BLUNT_HIT, Sounds.BLUNT_HIT_HARD, Sounds.WHOOSH, Sounds.WHOOSH_HARD, Sounds.WHOOSH_SHARP});
    }

    private static ResourceLocation location(String path) {
        return new ResourceLocation("epicfight", path);
    }

    @Mod.EventBusSubscriber(modid="epicfight", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class RegistryClientEvent {
        static AtlasTexture particleTexture;
        static Map<ResourceLocation, IBakedModel> modelRegistry;
        static ModelLoader modelLoader;

        @SubscribeEvent
        public static void onModelRegistry(ModelBakeEvent event) {
            OBJLoader.INSTANCE.addDomain("epicfight");
            RegistryClientEvent.registerItemOBJModel(event, ModItems.GREATSWORD, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GUI, (Object)ForgeBlockStateV1.Transforms.convert((float)-6.5f, (float)-5.0f, (float)0.0f, (float)90.0f, (float)-45.0f, (float)90.0f, (float)0.16f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.25f)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)ForgeBlockStateV1.Transforms.convert((float)6.0f, (float)-8.0f, (float)2.0f, (float)90.0f, (float)45.0f, (float)90.0f, (float)0.2f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)2.17f, (float)-4.2f, (float)3.25f, (float)80.0f, (float)0.0f, (float)0.0f, (float)0.375f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ForgeBlockStateV1.Transforms.leftify((TRSRTransformation)ForgeBlockStateV1.Transforms.convert((float)0.17f, (float)-0.2f, (float)0.25f, (float)80.0f, (float)0.0f, (float)0.0f, (float)0.375f))).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.5f, (float)-0.3f, (float)0.1f, (float)90.0f, (float)0.0f, (float)0.0f, (float)0.4f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.5f, (float)-0.3f, (float)0.1f, (float)90.0f, (float)0.0f, (float)0.0f, (float)0.4f)).build());
            RegistryClientEvent.registerItemOBJModel(event, ModItems.KATANA, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GUI, (Object)ForgeBlockStateV1.Transforms.convert((float)-10.0f, (float)-5.0f, (float)0.0f, (float)90.0f, (float)-45.0f, (float)90.0f, (float)0.5f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.25f)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)ForgeBlockStateV1.Transforms.convert((float)6.0f, (float)-11.0f, (float)5.0f, (float)90.0f, (float)45.0f, (float)90.0f, (float)0.5f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)6.5f, (float)-7.0f, (float)8.5f, (float)80.0f, (float)0.0f, (float)0.0f, (float)0.8f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ForgeBlockStateV1.Transforms.leftify((TRSRTransformation)ForgeBlockStateV1.Transforms.convert((float)0.17f, (float)-0.2f, (float)0.25f, (float)80.0f, (float)0.0f, (float)0.0f, (float)0.8f))).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.5f, (float)-0.3f, (float)0.1f, (float)90.0f, (float)0.0f, (float)0.0f, (float)0.4f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.5f, (float)-0.3f, (float)0.1f, (float)90.0f, (float)0.0f, (float)0.0f, (float)0.4f)).build());
            RegistryClientEvent.registerItemOBJModel(event, ((ItemKatana)ModItems.KATANA).getShealth().func_77973_b(), "katana_sheath", null, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GUI, (Object)ForgeBlockStateV1.Transforms.convert((float)-10.0f, (float)-5.0f, (float)0.0f, (float)90.0f, (float)-45.0f, (float)90.0f, (float)0.5f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.25f)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)ForgeBlockStateV1.Transforms.convert((float)6.0f, (float)-11.0f, (float)5.0f, (float)90.0f, (float)45.0f, (float)90.0f, (float)0.5f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)6.2f, (float)-5.0f, (float)7.35f, (float)88.0f, (float)0.0f, (float)0.0f, (float)0.8f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ForgeBlockStateV1.Transforms.leftify((TRSRTransformation)ForgeBlockStateV1.Transforms.convert((float)0.06f, (float)-0.3f, (float)0.25f, (float)90.0f, (float)0.0f, (float)0.0f, (float)0.8f))).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.5f, (float)-0.3f, (float)0.1f, (float)90.0f, (float)0.0f, (float)0.0f, (float)0.4f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.5f, (float)-0.3f, (float)0.1f, (float)90.0f, (float)0.0f, (float)0.0f, (float)0.4f)).build());
            RegistryClientEvent.registerItemOBJModel(event, ModItems.STONE_SPEAR, "spear", "stone_spear", (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GUI, (Object)ForgeBlockStateV1.Transforms.convert((float)-4.5f, (float)-2.5f, (float)0.0f, (float)90.0f, (float)-45.0f, (float)90.0f, (float)0.25f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.25f)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)ForgeBlockStateV1.Transforms.convert((float)6.0f, (float)-11.0f, (float)5.0f, (float)90.0f, (float)45.0f, (float)90.0f, (float)0.5f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)6.5f, (float)-7.0f, (float)8.5f, (float)80.0f, (float)0.0f, (float)0.0f, (float)0.8f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ForgeBlockStateV1.Transforms.leftify((TRSRTransformation)ForgeBlockStateV1.Transforms.convert((float)0.17f, (float)-0.2f, (float)0.25f, (float)80.0f, (float)0.0f, (float)0.0f, (float)0.8f))).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.5f, (float)-0.3f, (float)0.1f, (float)90.0f, (float)0.0f, (float)0.0f, (float)0.4f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.5f, (float)-0.3f, (float)0.1f, (float)90.0f, (float)0.0f, (float)0.0f, (float)0.4f)).build());
            RegistryClientEvent.registerItemOBJModel(event, ModItems.IRON_SPEAR, "spear", "iron_spear", (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GUI, (Object)ForgeBlockStateV1.Transforms.convert((float)-4.5f, (float)-2.5f, (float)0.0f, (float)90.0f, (float)-45.0f, (float)90.0f, (float)0.25f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.25f)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)ForgeBlockStateV1.Transforms.convert((float)6.0f, (float)-11.0f, (float)5.0f, (float)90.0f, (float)45.0f, (float)90.0f, (float)0.5f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)6.5f, (float)-7.0f, (float)8.5f, (float)80.0f, (float)0.0f, (float)0.0f, (float)0.8f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ForgeBlockStateV1.Transforms.leftify((TRSRTransformation)ForgeBlockStateV1.Transforms.convert((float)0.17f, (float)-0.2f, (float)0.25f, (float)80.0f, (float)0.0f, (float)0.0f, (float)0.8f))).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.5f, (float)-0.3f, (float)0.1f, (float)90.0f, (float)0.0f, (float)0.0f, (float)0.4f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.5f, (float)-0.3f, (float)0.1f, (float)90.0f, (float)0.0f, (float)0.0f, (float)0.4f)).build());
            RegistryClientEvent.registerItemOBJModel(event, ModItems.GOLDEN_SPEAR, "spear", "golden_spear", (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GUI, (Object)ForgeBlockStateV1.Transforms.convert((float)-4.5f, (float)-2.5f, (float)0.0f, (float)90.0f, (float)-45.0f, (float)90.0f, (float)0.25f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.25f)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)ForgeBlockStateV1.Transforms.convert((float)6.0f, (float)-11.0f, (float)5.0f, (float)90.0f, (float)45.0f, (float)90.0f, (float)0.5f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)6.5f, (float)-7.0f, (float)8.5f, (float)80.0f, (float)0.0f, (float)0.0f, (float)0.8f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ForgeBlockStateV1.Transforms.leftify((TRSRTransformation)ForgeBlockStateV1.Transforms.convert((float)0.17f, (float)-0.2f, (float)0.25f, (float)80.0f, (float)0.0f, (float)0.0f, (float)0.8f))).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.5f, (float)-0.3f, (float)0.1f, (float)90.0f, (float)0.0f, (float)0.0f, (float)0.4f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.5f, (float)-0.3f, (float)0.1f, (float)90.0f, (float)0.0f, (float)0.0f, (float)0.4f)).build());
            RegistryClientEvent.registerItemOBJModel(event, ModItems.DIAMOND_SPEAR, "spear", "diamond_spear", (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GUI, (Object)ForgeBlockStateV1.Transforms.convert((float)-4.5f, (float)-2.5f, (float)0.0f, (float)90.0f, (float)-45.0f, (float)90.0f, (float)0.25f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.25f)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)ForgeBlockStateV1.Transforms.convert((float)6.0f, (float)-11.0f, (float)5.0f, (float)90.0f, (float)45.0f, (float)90.0f, (float)0.5f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)6.5f, (float)-7.0f, (float)8.5f, (float)80.0f, (float)0.0f, (float)0.0f, (float)0.8f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ForgeBlockStateV1.Transforms.leftify((TRSRTransformation)ForgeBlockStateV1.Transforms.convert((float)0.17f, (float)-0.2f, (float)0.25f, (float)80.0f, (float)0.0f, (float)0.0f, (float)0.8f))).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.5f, (float)-0.3f, (float)0.1f, (float)90.0f, (float)0.0f, (float)0.0f, (float)0.4f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ForgeBlockStateV1.Transforms.convert((float)0.5f, (float)-0.3f, (float)0.1f, (float)90.0f, (float)0.0f, (float)0.0f, (float)0.4f)).build());
            modelRegistry = event.getModelRegistry();
            modelLoader = event.getModelLoader();
        }

        @SubscribeEvent
        public static void onParticleRegistry(ParticleFactoryRegisterEvent event) {
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)Particles.PORTAL_STRAIGHT.get(), PortalStraightParticle.Factory::new);
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)Particles.HIT_BLUNT.get(), HitBluntParticle.Factory::new);
            Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)Particles.HIT_CUT.get(), (IParticleFactory)new HitCutParticle.Factory());
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)Particles.BLOOD.get(), BloodParticle.Factory::new);
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)Particles.FLASH.get(), BlastParticle.Factory::new);
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)Particles.CUT.get(), CutParticle.Factory::new);
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)Particles.PARRY.get(), ParryParticle.Factory::new);
            Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)Particles.BLAST_PUNCH.get(), (IParticleFactory)new BlastPunchParticle.Factory());
            Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)Particles.BLAST_PUNCH_HUGE.get(), (IParticleFactory)new BlastPunchHugeParticle.Factory());
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)Particles.DUST.get(), DustParticle.Factory::new);
        }

        @SubscribeEvent
        public static void onTextureRegistry(TextureStitchEvent.Pre event) {
            if (event.getMap().getBasePath() == "textures/particle") {
                particleTexture = event.getMap();
                event.addSprite(RegistryEvents.location("blast_punch_huge"));
            } else if (event.getMap().getBasePath() == "textures") {
                event.addSprite(RegistryEvents.location("item/swords"));
                event.addSprite(RegistryEvents.location("item/diamond_spear"));
                event.addSprite(RegistryEvents.location("item/golden_spear"));
                event.addSprite(RegistryEvents.location("item/iron_spear"));
                event.addSprite(RegistryEvents.location("item/stone_spear"));
            }
        }

        @SubscribeEvent
        public static void onTextureRegistryPost(TextureStitchEvent.Post event) {
            if (event.getMap().getBasePath() == "textures/particle") {
                RegistryClientEvent.registerParticleOBJModel(modelRegistry, modelLoader, (BasicParticleType)Particles.BLAST_PUNCH_HUGE.get());
            }
        }

        private static void registerItemOBJModel(ModelBakeEvent event, Item item, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
            RegistryClientEvent.registerItemOBJModel(event, item, item.toString(), null, transforms);
        }

        private static void registerItemOBJModel(ModelBakeEvent event, Item item, String objFileName, String replaceTextureName, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
            IUnbakedModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)RegistryEvents.location("item/" + objFileName + ".obj"), (String)"Missing model");
            if (model instanceof OBJModel) {
                if (replaceTextureName != null) {
                    IUnbakedModel retextured = null;
                    for (String s : ((OBJModel)model).getMatLib().getMaterialNames()) {
                        OBJModel.Material mat = ((OBJModel)model).getMatLib().getMaterial(s);
                        String path = mat.getTexture().getPath();
                        if (!path.contains("epicfight")) continue;
                        retextured = (IUnbakedModel)model.retexture(ImmutableMap.of((Object)("#" + path), (Object)RegistryEvents.location("item/" + replaceTextureName).toString()));
                    }
                    if (retextured != null) {
                        model = retextured;
                    }
                }
                model = (IUnbakedModel)model.process(ImmutableMap.builder().put((Object)"flip-v", (Object)"true").build());
                IBakedModel bakedInvModel = model.bake((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (ISprite)new BasicState(model.getDefaultState(), true), DefaultVertexFormats.field_176599_b);
                bakedInvModel = new PerspectiveMapWrapper(bakedInvModel, transforms);
                event.getModelRegistry().put(new ModelResourceLocation("epicfight:" + item.toString(), "inventory"), bakedInvModel);
            }
        }

        private static void registerParticleOBJModel(Map<ResourceLocation, IBakedModel> modelregistry, ModelLoader modelloader, BasicParticleType particleType) {
            String name = particleType.getRegistryName().func_110623_a();
            IUnbakedModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)RegistryEvents.location("particle/" + name + ".obj"), (String)"Missing model");
            if (model instanceof OBJModel) {
                model = (IUnbakedModel)model.process(ImmutableMap.builder().put((Object)"flip-v", (Object)"true").build());
                IBakedModel bakedInvModel = model.bake((ModelBakery)modelloader, resource -> {
                    ResourceLocation rl = resource.func_110624_b().equals("epicfight") ? new ResourceLocation(resource.func_110624_b(), resource.func_110623_a().substring(9)) : resource;
                    return particleTexture.func_195424_a(rl);
                }, (ISprite)new BasicState(model.getDefaultState(), true), DefaultVertexFormats.field_181704_d);
                modelregistry.put((ResourceLocation)new ModelResourceLocation("epicfight:" + name, "particle"), bakedInvModel);
            }
        }
    }
}

