/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.item;

import com.google.common.collect.Multimap;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.capabilities.item.ModWeaponCapability;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Colliders;
import maninhouse.epicfight.gamedata.Skills;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.item.ItemWeapon;
import net.minecraft.block.BlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;

public class ItemSpear
extends ItemWeapon {
    private final ItemTier material;
    private final float attackDamage;

    public ItemSpear(Item.Properties build, ItemTier materialIn) {
        super(build.func_200915_b((int)((float)materialIn.func_200926_a() * 1.5f)));
        this.material = materialIn;
        this.attackDamage = 3.0f + this.material.func_200929_c();
        this.setStats();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.material.func_200924_f().test(repair) || super.func_82789_a(toRepair, repair);
    }

    public int func_77619_b() {
        return this.material.func_200927_e();
    }

    public boolean func_150897_b(BlockState blockIn) {
        return false;
    }

    public String getToolMaterialName() {
        return this.material.toString();
    }

    @Override
    public void setWeaponCapability() {
    }

    public void setStats() {
        double oneHandImpact = 2.9 + (double)this.material.func_200925_d() * 0.3;
        double twoHandImpact = 1.1 + (double)this.material.func_200925_d() * 0.5;
        this.capability = new ModWeaponCapability(Skills.SLAUGHTER_STANCE, null, Sounds.WHOOSH, Sounds.BLADE_HIT, Colliders.spearNarrow, 4.0 + 4.0 * (double)this.material.func_200925_d(), oneHandImpact, 1, false, true);
        this.capability.addAutoAttackCombos(Animations.SPEAR_AUTO_1);
        this.capability.addAutoAttackCombos(Animations.SPEAR_DASH);
        this.capability.addTwohandAutoAttackCombos(Animations.SPEAR_TWOHAND_AUTO_1);
        this.capability.addTwohandAutoAttackCombos(Animations.SPEAR_TWOHAND_AUTO_2);
        this.capability.addTwohandAutoAttackCombos(Animations.SPEAR_DASH);
        this.capability.addMountAttackCombos(Animations.SPEAR_MOUNT_ATTACK);
        this.capability.setTwoHandStyleAttribute(0.0, twoHandImpact, 3);
        this.capability.addLivingMotionChanger(LivingMotion.RUNNING, Animations.BIPED_RUN_HELDING_WEAPON);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.8, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }
}

