/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.main;

import java.lang.reflect.Field;
import java.util.Queue;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.ProviderEntity;
import maninhouse.epicfight.capabilities.ProviderItem;
import maninhouse.epicfight.client.ClientEngine;
import maninhouse.epicfight.client.eventengine.ClientEvents;
import maninhouse.epicfight.client.eventengine.ControllEngine;
import maninhouse.epicfight.client.eventengine.RenderEngine;
import maninhouse.epicfight.client.input.KeyBindings;
import maninhouse.epicfight.client.shader.Shaders;
import maninhouse.epicfight.events.CapabilityEvent;
import maninhouse.epicfight.events.EntityEvents;
import maninhouse.epicfight.events.PlayerEvents;
import maninhouse.epicfight.events.RegistryEvents;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.gamedata.Skills;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.particle.Particles;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="epicfight")
public class EpicFightMod {
    public static final String MODID = "epicfight";
    @OnlyIn(value=Dist.CLIENT)
    public static Field mainThreadTaskQueue;

    public EpicFightMod() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            Models.LOGICAL_CLIENT.buildArmatureData();
            Models.LOGICAL_SERVER.buildArmatureData();
            mainThreadTaskQueue = ObfuscationReflectionHelper.findField(Minecraft.class, (String)"field_213275_aU");
        } else if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            Models.LOGICAL_SERVER.buildArmatureData();
        } else {
            throw new IllegalArgumentException("UNSIDED?");
        }
        Animations.registerAnimation(FMLEnvironment.dist);
        Skills.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doCommonStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(EntityEvents.class);
        MinecraftForge.EVENT_BUS.register(RegistryEvents.class);
        MinecraftForge.EVENT_BUS.register(CapabilityEvent.class);
        MinecraftForge.EVENT_BUS.register(PlayerEvents.class);
        Particles.PARTICLES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        new ClientEngine();
        try {
            ((Queue)mainThreadTaskQueue.get(Minecraft.func_71410_x())).add(() -> {
                Shaders.loadShaders();
                Models.LOGICAL_CLIENT.buildMeshData();
                ClientEngine.INSTANCE.renderEngine.buildRenderer();
            });
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        ProviderEntity.makeMapClient();
        KeyBindings.registerKeys();
        Skills.setTooltips();
        MinecraftForge.EVENT_BUS.register(ControllEngine.Events.class);
        MinecraftForge.EVENT_BUS.register(RenderEngine.Events.class);
        MinecraftForge.EVENT_BUS.register(RegistryEvents.RegistryClientEvent.class);
        MinecraftForge.EVENT_BUS.register(ClientEvents.class);
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        ModCapabilities.registerCapabilities();
        ModNetworkManager.registerPackets();
        ProviderItem.makeMap();
        ProviderEntity.makeMap();
    }

    public static boolean isPhysicalClient() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }
}

