/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.model;

import java.io.IOException;
import maninhouse.epicfight.client.model.Mesh;
import maninhouse.epicfight.collada.ColladaModelLoader;
import maninhouse.epicfight.model.Armature;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Model {
    @OnlyIn(value=Dist.CLIENT)
    private Mesh mesh;
    private Armature armature;
    private ResourceLocation location;

    public Model(ResourceLocation location) {
        this.location = location;
    }

    public void loadMeshData() {
        try {
            this.mesh = ColladaModelLoader.getArmatureModelData(this.location);
        }
        catch (IOException e) {
            System.err.println(this.location.func_110624_b() + " failed to load!");
        }
    }

    public void loadArmatureData() {
        try {
            this.armature = ColladaModelLoader.getArmature(this.location);
        }
        catch (IOException e) {
            System.err.println(this.location.func_110624_b() + " failed to load!");
        }
    }

    public void loadArmatureData(Armature armature) {
        this.armature = armature;
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    public Armature getArmature() {
        return this.armature;
    }
}

