/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.network.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCLivingMotionChange;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CTSReqPlayerInfo {
    private int entityId;

    public CTSReqPlayerInfo() {
        this.entityId = 0;
    }

    public CTSReqPlayerInfo(int entityId) {
        this.entityId = entityId;
    }

    public static CTSReqPlayerInfo fromBytes(PacketBuffer buf) {
        return new CTSReqPlayerInfo(buf.readInt());
    }

    public static void toBytes(CTSReqPlayerInfo msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
    }

    public static void handle(CTSReqPlayerInfo msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerData playerdata;
            Entity entity = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_73045_a(msg.entityId);
            if (entity != null && entity instanceof ServerPlayerEntity && (playerdata = (ServerPlayerData)entity.getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null) {
                ArrayList motions = Lists.newArrayList();
                ArrayList animations = Lists.newArrayList();
                int i = 0;
                for (Map.Entry<LivingMotion, StaticAnimation> entry : playerdata.getLivingMotionEntrySet()) {
                    motions.add(entry.getKey());
                    animations.add(entry.getValue());
                    ++i;
                }
                LivingMotion[] motionarr = motions.toArray(new LivingMotion[0]);
                StaticAnimation[] animationarr = animations.toArray(new StaticAnimation[0]);
                STCLivingMotionChange mg = new STCLivingMotionChange(playerdata.getOriginalEntity().func_145782_y(), i);
                mg.setMotions(motionarr);
                mg.setAnimations(animationarr);
                ModNetworkManager.sendToPlayer(mg, ((NetworkEvent.Context)ctx.get()).getSender());
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

